/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.cip4.jdflib.util.ThreadUtil;

public class FileSorter {
    private final File[] list;

    public FileSorter(File dir) {
        this(dir == null ? null : dir.listFiles());
    }

    public FileSorter(File[] list) {
        this.list = list;
    }

    public File[] sortLastModified(boolean bNewFirst) {
        for (int i = 1; i < 7; ++i) {
            try {
                if (this.list != null) {
                    Arrays.sort(this.list, new LastModifiedComparator(bNewFirst));
                }
                return this.list;
            }
            catch (Exception x) {
                ThreadUtil.sleep(123 * i);
                continue;
            }
        }
        return this.list;
    }

    public File[] sortLastModified(boolean bNewFirst, long minAge) {
        if (this.list != null) {
            long t0 = System.currentTimeMillis() - minAge;
            ArrayList<File> al = new ArrayList<File>();
            for (File f : this.list) {
                if (f.lastModified() >= t0) continue;
                al.add(f);
            }
            Collections.sort(al, new LastModifiedComparator(bNewFirst));
            File[] ret = new File[al.size()];
            int n = 0;
            for (File f : al) {
                ret[n++] = f;
            }
            return ret;
        }
        return null;
    }

    public int size() {
        return this.list == null ? 0 : this.list.length;
    }

    protected class LastModifiedComparator
    implements Comparator<File> {
        private final int iNewFirst;

        public LastModifiedComparator(boolean newFirst) {
            this.iNewFirst = newFirst ? 1 : -1;
        }

        @Override
        public int compare(File o1, File o2) {
            int n = o1.lastModified() > o2.lastModified() ? -1 : (o1.lastModified() < o2.lastModified() ? 1 : 0);
            return n * this.iNewFirst;
        }
    }
}

