/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.BackupDirectory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class RollingBackupDirectory
extends BackupDirectory {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger ordBackup;
    private final String baseName;
    private final String baseExt;

    public RollingBackupDirectory(File file, int nBackupp, String base) throws IllegalArgumentException {
        super(file, nBackupp);
        this.baseName = UrlUtil.prefix(base);
        this.baseExt = UrlUtil.extension(base);
        this.ordBackup = new AtomicInteger(this.calcOrdBackup());
    }

    private int calcOrdBackup() {
        String ext = this.baseExt == null ? ".*" : ".*." + this.baseExt;
        File[] files = FileUtil.listFilesWithExpression(this, this.baseName + ext);
        int nMax = 0;
        if (files == null) {
            return nMax;
        }
        for (File file : files) {
            int n = this.calcN(file);
            if (n <= nMax) continue;
            nMax = n;
        }
        return nMax;
    }

    private int calcN(File file) {
        if (file == null) {
            return 0;
        }
        String name = file.getName();
        VString v = StringUtil.tokenize(name.substring(this.baseName.length()), ".", false);
        for (String s : v) {
            if (!StringUtil.isInteger(s)) continue;
            return StringUtil.parseInt(s, -1);
        }
        return 0;
    }

    public File getNewFile() {
        return this.getNewFileWithExt(null);
    }

    public synchronized File getNewFileWithExt(String ext) {
        String newExt;
        String string = newExt = this.baseExt == null ? "" : "." + this.baseExt;
        if (StringUtil.getNonEmpty(ext) == null) {
            ext = "";
        } else if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        String newFile = this.baseName + "." + this.ordBackup.incrementAndGet() + ext + newExt;
        return this.getNewFile(newFile);
    }

    @Override
    public String toString() {
        return super.toString() + " baseName=" + this.baseName + " baseExt=" + this.baseExt + " ord=" + this.ordBackup;
    }
}

