/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResource;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.node.JDFActivity;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.StringUtil;

public class WalkEmployee
extends WalkResource {
    @Override
    protected String getXJDFName(KElement jdf) {
        return "Contact";
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFEmployee;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement parent = jdf.getParentNode_KElement();
        JDFEmployee emp = (JDFEmployee)jdf;
        if (parent instanceof JDFAudit || parent instanceof JDFMessage) {
            String personalID = StringUtil.getNonEmpty(emp.getPersonalID());
            xjdf.setAttribute("PersonalID", personalID);
            String author = StringUtil.getNonEmpty(emp.getDescriptiveName());
            xjdf.setAttribute("Author", author);
            return null;
        }
        if (parent instanceof JDFJMF) {
            return null;
        }
        if (parent instanceof JDFDeviceInfo) {
            JDFActivity a = ((JDFDeviceInfo)xjdf).appendActivity();
            a.setPersonalID(emp.getPersonalID());
            return null;
        }
        if (parent instanceof JDFNodeInfo) {
            jdf.appendAttribute("Roles", "CSR", null, " ", true);
            KElement e = this.moveToContact(jdf);
            KElement walk = super.walk(e, xjdf);
            walk.moveAttribute("ExternalID", e);
            return walk;
        }
        KElement e = this.moveToContact(jdf);
        KElement walk = super.walk(e, xjdf);
        ResourceHelper helper = ResourceHelper.getHelper(xjdf);
        helper.appendPartMap(new JDFAttributeMap("ContactType", "Employee"));
        return walk;
    }

    public KElement moveToContact(KElement jdfEmployee) {
        JDFContact contact = (JDFContact)this.safeRename(jdfEmployee, "Contact");
        contact.renameAttribute("PersonalID", "ExternalID", null, null);
        contact.renameAttribute("Roles", "ContactTypeDetails", null, null);
        return contact;
    }

    @Override
    public VString getElementNames() {
        return new VString("Employee", null);
    }
}

