/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoQueue;
import org.cip4.jdflib.auto.JDFAutoQueueEntry;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueEntry;
import org.cip4.jdflib.jmf.JDFQueueFilter;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFQueue
extends JDFAutoQueue {
    private static final long serialVersionUID = 1L;
    private int maxRunningEntries = -1;
    private int maxWaitingEntries = -1;
    private int maxCompletedEntries = 0;
    private boolean automated = false;
    private boolean bAccepting = true;
    private boolean bProcessing = true;
    private CleanupCallback cleanupCallback = null;
    private ExecuteCallback executeCallback = null;
    private Comparator<KElement> queueSorter = null;

    public JDFQueue(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAutoQueue.EnumQueueStatus openQueue() {
        if (this.bAccepting) {
            return this.getQueueStatus();
        }
        this.bAccepting = true;
        return this.setStatusFromEntries();
    }

    public JDFAutoQueue.EnumQueueStatus closeQueue() {
        if (!this.bAccepting) {
            return this.getQueueStatus();
        }
        this.bAccepting = false;
        return this.setStatusFromEntries();
    }

    public JDFAutoQueue.EnumQueueStatus holdQueue() {
        if (!this.bProcessing) {
            return this.getQueueStatus();
        }
        this.bProcessing = false;
        return this.setStatusFromEntries();
    }

    public JDFAutoQueue.EnumQueueStatus resumeQueue() {
        if (this.bProcessing) {
            return this.getQueueStatus();
        }
        this.bProcessing = true;
        return this.setStatusFromEntries();
    }

    public JDFQueue(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFQueue(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFQueue[  --> " + super.toString() + " ]";
    }

    public int getEntryCount() {
        return this.numChildrenByClass(JDFQueueEntry.class, false);
    }

    public VElement getQueueEntryVector() {
        List<JDFQueueEntry> v1 = this.getChildArrayByClass(JDFQueueEntry.class, false, -1);
        VElement v = new VElement();
        if (v1 != null) {
            v.ensureCapacity(v1.size());
            v.addAll(v1);
        }
        return v;
    }

    public synchronized VElement getQueueEntryVector(JDFAttributeMap attMap, VJDFAttributeMap parts) {
        VElement v = this.getChildElementVector("QueueEntry", null, attMap, true, -1, true);
        if (parts != null) {
            for (int i = v.size() - 1; i >= 0; --i) {
                JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
                if (parts.equals(qe.getPartMapVector())) continue;
                v.remove(i);
            }
        }
        return v == null || v.size() == 0 ? null : v;
    }

    public synchronized Map<String, JDFQueueEntry> getQueueEntryIDMap() {
        int siz;
        HashMap<String, JDFQueueEntry> map = null;
        List<JDFQueueEntry> v = this.getChildArrayByClass(JDFQueueEntry.class, false, -1);
        if (v != null && (siz = v.size()) > 0) {
            map = new HashMap<String, JDFQueueEntry>(siz);
            for (int i = 0; i < siz; ++i) {
                JDFQueueEntry qe = v.get(i);
                map.put(qe.getQueueEntryID(), qe);
            }
        }
        return map;
    }

    public synchronized VElement getQueueEntryVector(NodeIdentifier nid) {
        VElement v = this.getQueueEntryVector();
        if (nid == null || v == null || nid.equals(new NodeIdentifier())) {
            return v;
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
            if (qe.matchesNodeIdentifier(nid)) continue;
            v.remove(i);
        }
        return v.size() == 0 ? null : v;
    }

    @Deprecated
    public JDFQueueEntry getEntry(int i) {
        return this.getQueueEntry(i);
    }

    public JDFQueueEntry createQueueEntry(boolean bHeld) {
        if (!this.canAccept()) {
            return null;
        }
        JDFQueueEntry qe = this.appendQueueEntry();
        qe.setQueueEntryID("qe" + JDFQueue.uniqueID(0));
        qe.setSubmissionTime(new JDFDate());
        qe.setQueueEntryStatus(bHeld ? JDFAutoQueueEntry.EnumQueueEntryStatus.Held : JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting);
        return qe;
    }

    public synchronized VElement flushQueue(JDFQueueFilter qf) {
        int siz = 0;
        VElement ve = this.getQueueEntryVector();
        if (ve != null) {
            siz = ve.size();
            JDFQueueFilter.QueueEntryMatcher qeMatch = qf == null ? null : qf.new JDFQueueFilter.QueueEntryMatcher();
            for (int i = siz - 1; i >= 0; --i) {
                JDFQueueEntry qe = (JDFQueueEntry)ve.get(i);
                if (qeMatch == null || qeMatch.matches(qe)) {
                    if (this.cleanupCallback != null) {
                        this.cleanupCallback.cleanEntry(qe);
                    }
                    qe.deleteNode();
                    continue;
                }
                ve.remove(i);
                --siz;
            }
        }
        if (this.automated) {
            this.setStatusFromEntries();
        }
        return siz == 0 ? null : ve;
    }

    @Deprecated
    public VString findQueueEntries(String strJobID, String strJobPartID, VJDFAttributeMap vamParts, JDFAutoQueueEntry.EnumQueueEntryStatus status) {
        VString vsQEntryIDs = new VString();
        int entryCount = this.getEntryCount();
        for (int i = 0; i < entryCount; ++i) {
            JDFQueueEntry entry = this.getQueueEntry(i);
            String strQEJobID = entry.getJobID();
            String strQEJobPartID = entry.getJobPartID();
            VJDFAttributeMap vamQEParts = entry.getPartMapVector();
            JDFAutoQueueEntry.EnumQueueEntryStatus statusQE = entry.getQueueEntryStatus();
            if (!strJobID.equals(strQEJobID) || !strJobPartID.equals(strQEJobPartID) || !vamParts.equals(vamQEParts) || status != null && !status.equals((Object)statusQE)) continue;
            vsQEntryIDs.appendUnique(entry.getQueueEntryID());
        }
        return vsQEntryIDs;
    }

    @Deprecated
    public JDFQueueEntry getEntry(String strQEntryID) {
        return this.getQueueEntry(strQEntryID);
    }

    public JDFQueueEntry getQueueEntry(String strQEntryID) {
        if (JDFQueue.isWildCard(strQEntryID)) {
            return null;
        }
        for (JDFQueueEntry qe = this.getFirstChildElement(JDFQueueEntry.class); qe != null; qe = qe.getNextSiblingElement(JDFQueueEntry.class)) {
            if (!strQEntryID.equals(qe.getQueueEntryID())) continue;
            return qe;
        }
        return null;
    }

    public JDFQueueEntry getQueueEntry(NodeIdentifier nodeID, int nSkip) {
        block5: {
            if (nodeID == null) {
                return null;
            }
            VElement v = this.getQueueEntryVector();
            if (v == null) break block5;
            int siz = v.size();
            int n = 0;
            if (nSkip >= 0) {
                for (int i = 0; i < siz; ++i) {
                    JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
                    NodeIdentifier ni2 = qe.getIdentifier();
                    if (!ni2.matches(nodeID) || n++ < nSkip) continue;
                    return qe;
                }
            } else {
                for (int i = siz - 1; i >= 0; --i) {
                    JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
                    NodeIdentifier ni2 = qe.getIdentifier();
                    if (!ni2.matches(nodeID) || --n > nSkip) continue;
                    return qe;
                }
            }
        }
        return null;
    }

    public int getQueueEntryPos(String strQEntryID) {
        if (StringUtil.getNonEmpty(strQEntryID) == null) {
            return -1;
        }
        VElement v = this.getQueueEntryVector();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
            if (!strQEntryID.equals(qe.getQueueEntryID())) continue;
            return i;
        }
        return -1;
    }

    public synchronized JDFQueueEntry getNextExecutableQueueEntry() {
        return this.getNextExecutableQueueEntry(null);
    }

    public synchronized JDFQueueEntry getNextExecutableQueueEntry(ExecuteCallback cb) {
        if (cb == null) {
            cb = this.executeCallback;
        }
        JDFQueueEntry theEntry = null;
        if (!this.canExecute()) {
            return theEntry;
        }
        for (JDFQueueEntry qe = this.getFirstChildElement(JDFQueueEntry.class); qe != null; qe = qe.getNextSiblingElement(JDFQueueEntry.class)) {
            String qeStatus = qe.getAttribute("Status");
            if ("Waiting".equals(qeStatus)) {
                String qeActivation = StringUtil.getNonEmpty(qe.getAttribute("Activation"));
                if (qeActivation != null && !"Active".equals(qeActivation) || cb != null && !cb.canExecute(qe)) continue;
                theEntry = qe;
                break;
            }
            if (!"Running".equals(qeStatus)) break;
        }
        return theEntry;
    }

    public boolean canExecute() {
        JDFAutoQueue.EnumQueueStatus status = this.getQueueStatus();
        if (JDFAutoQueue.EnumQueueStatus.Blocked.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Held.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Full.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Running.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Waiting.equals((Object)status)) {
            return true;
        }
        return !this.maxRunning();
    }

    public boolean canAccept() {
        JDFAutoQueue.EnumQueueStatus status = this.getQueueStatus();
        if (JDFAutoQueue.EnumQueueStatus.Blocked.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Closed.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Full.equals((Object)status)) {
            return false;
        }
        if (JDFAutoQueue.EnumQueueStatus.Waiting.equals((Object)status)) {
            return true;
        }
        boolean b = this.hasAttribute("QueueSize") ? this.numEntries(null) < this.getQueueSize() : !this.maxWaiting();
        return b;
    }

    @Override
    public synchronized void cleanup() {
        VElement v = this.getQueueEntryVector();
        if (v != null) {
            int siz = v.size();
            int nBad = 0;
            for (int i = 0; i < siz; ++i) {
                JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
                JDFAutoQueueEntry.EnumQueueEntryStatus status = qe.getQueueEntryStatus();
                if (JDFQueue.isWildCard(qe.getQueueEntryID())) {
                    if (this.cleanupCallback != null) {
                        this.cleanupCallback.cleanEntry(qe);
                    }
                    qe.deleteNode();
                    continue;
                }
                if (JDFAutoQueueEntry.EnumQueueEntryStatus.Removed.equals((Object)status)) {
                    if (this.cleanupCallback != null) {
                        this.cleanupCallback.cleanEntry(qe);
                    }
                    qe.deleteNode();
                    continue;
                }
                if (this.maxCompletedEntries < 0 || !qe.isCompleted() || nBad++ < this.maxCompletedEntries) continue;
                if (this.cleanupCallback != null) {
                    this.cleanupCallback.cleanEntry(qe);
                }
                qe.deleteNode();
            }
        }
        this.setStatusFromEntries();
    }

    @Deprecated
    public synchronized JDFQueue copyToResponse(JDFResponse resp, JDFQueueFilter filter) {
        return this.copyToResponse(resp, filter, null);
    }

    public synchronized JDFQueue copyToResponse(JDFResponse resp, JDFQueueFilter filter, JDFQueue priorQueue) {
        if (resp == null) {
            return null;
        }
        resp.removeChildren("Queue", null, null);
        JDFQueue newQueue = filter != null ? filter.copy(this, priorQueue, resp) : (JDFMessage.EnumType.QueueStatus.equals((Object)resp.getEnumType()) ? (JDFQueue)resp.copyElement(this, null) : null);
        return newQueue;
    }

    public int numEntries(JDFAutoQueueEntry.EnumQueueEntryStatus qeStatus) {
        String stat;
        int n = 0;
        String string = stat = qeStatus == null ? null : qeStatus.getName();
        for (JDFQueueEntry qe = this.getFirstChildElement(JDFQueueEntry.class); qe != null; qe = qe.getNextSiblingElement(JDFQueueEntry.class)) {
            if (stat != null && !stat.equals(qe.getAttribute("Status"))) continue;
            ++n;
        }
        return n;
    }

    private boolean maxRunning() {
        return this.maxRunningEntries > 0 && this.hasFewerEntries(JDFAutoQueueEntry.EnumQueueEntryStatus.Running, this.maxRunningEntries);
    }

    private boolean maxWaiting() {
        return this.maxWaitingEntries > 0 && this.hasFewerEntries(JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting, this.maxWaitingEntries);
    }

    public boolean hasFewerEntries(JDFAutoQueueEntry.EnumQueueEntryStatus qeStatus, int entries) {
        String stat;
        int n = 0;
        String string = stat = qeStatus == null ? null : qeStatus.getName();
        for (JDFQueueEntry qe = this.getFirstChildElement(JDFQueueEntry.class); qe != null; qe = qe.getNextSiblingElement(JDFQueueEntry.class)) {
            if (stat != null && !stat.equals(qe.getAttribute("Status")) || ++n < entries) continue;
            return true;
        }
        return false;
    }

    public void setAutomated(boolean _automated) {
        this.automated = _automated;
        if (this.automated) {
            this.setStatusFromEntries();
        }
    }

    public boolean isAutomated() {
        return this.automated;
    }

    @Override
    public int getQueueSize() {
        if (this.hasAttribute("QueueSize")) {
            return super.getQueueSize();
        }
        return this.getEntryCount();
    }

    public synchronized JDFAutoQueue.EnumQueueStatus setStatusFromEntries() {
        JDFAutoQueue.EnumQueueStatus newStatus = null;
        if (this.bAccepting) {
            if (this.bProcessing) {
                boolean maxRunning = this.maxRunning();
                boolean maxWaiting = this.maxWaiting();
                newStatus = !maxRunning ? (!maxWaiting ? JDFAutoQueue.EnumQueueStatus.Waiting : JDFAutoQueue.EnumQueueStatus.Closed) : (!maxWaiting ? JDFAutoQueue.EnumQueueStatus.Running : JDFAutoQueue.EnumQueueStatus.Full);
            } else {
                newStatus = JDFAutoQueue.EnumQueueStatus.Held;
            }
        } else {
            newStatus = this.bProcessing ? JDFAutoQueue.EnumQueueStatus.Closed : JDFAutoQueue.EnumQueueStatus.Blocked;
        }
        if (newStatus != null) {
            this.setQueueStatus(newStatus);
        }
        return newStatus;
    }

    @Override
    public void sortChildren() {
        if (this.queueSorter == null) {
            this.queueSorter = new JDFQueueEntry.QueueEntryComparator();
        }
        this.sortChildren(this.queueSorter);
    }

    public int getMaxCompletedEntries() {
        return this.maxCompletedEntries;
    }

    public void setMaxCompletedEntries(int _maxCompletedEntries) {
        this.maxCompletedEntries = _maxCompletedEntries;
        if (this.automated) {
            this.cleanup();
        }
    }

    public int getMaxRunningEntries() {
        return this.maxRunningEntries;
    }

    public void setMaxRunningEntries(int _maxRunningEntries) {
        this.maxRunningEntries = _maxRunningEntries;
        if (this.automated) {
            this.setStatusFromEntries();
        }
    }

    public void setMaxWaitingEntries(int _maxWaitingEntries) {
        this.maxWaitingEntries = _maxWaitingEntries;
        if (this.automated) {
            this.setStatusFromEntries();
        }
    }

    public void setCleanupCallback(CleanupCallback _cleanupCallback) {
        this.cleanupCallback = _cleanupCallback;
    }

    public void setExecuteCallback(ExecuteCallback _callback) {
        this.executeCallback = _callback;
    }

    public void setQueueSorter(Comparator<KElement> _queueSorter) {
        this.queueSorter = _queueSorter;
    }

    public void sortChild(JDFQueueEntry qe) {
        if (this.queueSorter == null) {
            this.queueSorter = new JDFQueueEntry.QueueEntryComparator();
        }
        this.sortChild(qe, this.queueSorter);
    }

    public static abstract class ExecuteCallback {
        public abstract boolean canExecute(JDFQueueEntry var1);
    }

    public static abstract class CleanupCallback {
        public abstract void cleanEntry(JDFQueueEntry var1);
    }
}

