/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.util.ContainerUtil;

public class ListMap<key, listObject>
extends HashMap<key, List<listObject>> {
    private static final long serialVersionUID = -23L;
    boolean bUnique;

    public void fillInvertedMap(Map<listObject, key> map) {
        boolean keepUnique = this.bUnique;
        this.setUnique(false);
        if (map != null) {
            for (listObject k : map.keySet()) {
                key k2 = map.get(k);
                if (k2 == null) continue;
                this.putOne(k2, k);
            }
        }
        this.setUnique(keepUnique);
    }

    public ListMap() {
        this.setUnique(true);
    }

    public listObject getOne(Object key, int i) {
        List c = (List)this.get(key);
        if (c == null) {
            return null;
        }
        int n = c.size();
        if (i < 0) {
            i += n;
        }
        if (i < 0 || i >= n) {
            return null;
        }
        return (listObject)c.get(i);
    }

    public int getIndex(key key, listObject singleObject) {
        List keyVector = (List)this.get(key);
        if (keyVector == null) {
            return -2;
        }
        return keyVector.indexOf(singleObject);
    }

    public int size(key key) {
        List c = (List)this.get(key);
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    public void putOne(key key, listObject val) {
        Vector<listObject> v = (Vector<listObject>)this.get(key);
        if (v == null) {
            v = new Vector<listObject>();
            this.put(key, v);
        }
        if (!this.bUnique || !v.contains(val)) {
            v.add(val);
        }
    }

    public synchronized void appendUnique(key key, List<listObject> vVal) {
        if (vVal == null) {
            return;
        }
        boolean keepUnique = this.bUnique;
        this.bUnique = true;
        for (listObject val : vVal) {
            this.putOne(key, val);
        }
        this.bUnique = keepUnique;
    }

    public void appendUnique(ListMap<key, listObject> map) {
        if (map == null) {
            return;
        }
        for (Object next : map.keySet()) {
            this.appendUnique(next, (List)map.get(next));
        }
    }

    public List<listObject> getAllValues() {
        List v = new ArrayList();
        Collection c = this.values();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            v = (List)ContainerUtil.addAll(v, (Collection)it.next());
        }
        return v.size() == 0 ? null : v;
    }

    public Map<listObject, key> getInvertedMap() {
        HashMap inverted = new HashMap();
        Set keys = this.keySet();
        for (Object k : keys) {
            List v = (List)this.get(k);
            if (v == null) continue;
            for (Object vo : v) {
                inverted.put(vo, k);
            }
        }
        return inverted;
    }

    public void removeOne(key key, listObject val) {
        List v = (List)this.get(key);
        if (v != null) {
            v.remove(val);
            if (v.size() == 0) {
                this.remove(key);
            }
        }
    }

    public void setOne(key key, listObject newObj, listObject oldObj) {
        List v = (List)this.get(key);
        if (v != null) {
            int i = v.indexOf(oldObj);
            if (i < 0) {
                this.putOne(key, newObj);
            } else {
                v.set(i, newObj);
            }
        } else {
            this.putOne(key, newObj);
        }
    }

    public void setOne(key key, listObject newObj, int pos) {
        Vector<listObject> v = (Vector<listObject>)this.get(key);
        if (v == null) {
            v = new Vector<listObject>();
            this.put(key, v);
        }
        if (pos < 0) {
            pos += v.size();
        }
        if (pos < 0) {
            throw new IllegalArgumentException("index <0 after adding size: " + pos);
        }
        ContainerUtil.ensureSize(pos + 1, v);
        v.set(pos, newObj);
    }

    public boolean isUnique() {
        return this.bUnique;
    }

    public void setUnique(boolean bUnique) {
        this.bUnique = bUnique;
    }
}

