/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Comparator;
import java.util.List;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkSet
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdf, KElement jdf) {
        if (jdf instanceof JDFNode) {
            JDFNode parentNode = (JDFNode)jdf;
            String procUsage = StringUtil.getNonEmpty(xjdf.getAttribute("ProcessUsage"));
            if ("Product".equals(procUsage) && !JDFNode.EnumType.Product.equals((Object)parentNode.getEnumType())) {
                return null;
            }
            VString types = parentNode.getTypes();
            if (types == null || types.size() <= 1) {
                xjdf.removeAttribute("CombinedProcessIndex");
            }
        }
        this.reorderResources(xjdf);
        return jdf;
    }

    void reorderResources(KElement xjdf) {
        SetHelper h = new SetHelper(xjdf);
        List<ResourceHelper> vp = h.getPartitionList();
        if (ContainerUtil.size(vp) > 1) {
            vp.sort(new PartSizeComparator());
        }
        for (ResourceHelper p : vp) {
            xjdf.moveElement(p.getRoot(), null);
        }
    }

    protected String getJDFResName(KElement e) {
        SetHelper h = new SetHelper(e);
        String name = h.getName();
        return name;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return SetHelper.isSet(toCheck);
    }

    static class PartSizeComparator
    implements Comparator<ResourceHelper> {
        PartSizeComparator() {
        }

        @Override
        public int compare(ResourceHelper o1, ResourceHelper o2) {
            return o1.getPartMap().size() - o2.getPartMap().size();
        }
    }
}

