/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoComChannel;
import org.cip4.jdflib.auto.JDFAutoUsageCounter;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.BaseGoldenTicket;
import org.cip4.jdflib.goldenticket.JMFGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComChannel;
import org.cip4.jdflib.resource.process.JDFCompany;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFPerson;
import org.cip4.jdflib.resource.process.JDFUsageCounter;
import org.cip4.jdflib.util.StringUtil;

public class MISGoldenTicket
extends BaseGoldenTicket {
    protected int misICSLevel;
    protected int jmfICSLevel;
    protected boolean bUsageCounter = false;
    public int preStart = 600;
    public int duration = this.preStart / 2;
    public int scheduleHours = -1;
    public int scheduleDuration = -1;
    protected boolean grayBox = true;

    @Override
    public VString getICSVersions() {
        VString v = super.getICSVersions();
        String icsTag = "MIS_L" + this.misICSLevel + "-" + this.theVersion.getName();
        v.appendUnique(icsTag);
        return v;
    }

    public MISGoldenTicket(int misLevel, JDFElement.EnumVersion jdfVersion, int jmfLevel) {
        super(2, jdfVersion);
        this.misICSLevel = misLevel;
        this.jmfICSLevel = jmfLevel;
    }

    public MISGoldenTicket(MISGoldenTicket parent) {
        super(parent);
        this.misICSLevel = parent.misICSLevel;
        this.jmfICSLevel = parent.jmfICSLevel;
        this.getNIFromParent = parent.getNIFromParent;
        this.duration = parent.duration;
    }

    @Override
    public void assign(JDFNode node) {
        super.assign(node);
        if (this.jmfICSLevel > 0) {
            JMFGoldenTicket goldenTicket = new JMFGoldenTicket(this.jmfICSLevel, this.theVersion);
            goldenTicket.devID = null;
            goldenTicket.assign(this.theNode);
        }
        super.init();
    }

    @Override
    protected JDFNodeInfo initNodeInfo() {
        JDFNodeInfo ni = super.initNodeInfo();
        if (this.theParentNode == null) {
            JDFEmployee emp = ni.appendEmployee();
            emp.setPersonalID("personalID1");
            emp.setRoles(new VString("CSR", null));
            if (this.returnURL != null) {
                ni.setTargetRoute(this.returnURL);
            }
            this.schedule(null, this.scheduleHours, this.scheduleDuration);
        }
        return ni;
    }

    @Override
    public void execute(VJDFAttributeMap vNodeMap, boolean bOutAvail, boolean bFirst) {
        JDFComment c = this.theExpandedNode.appendComment();
        c.setName("OperatorText");
        c.setText(StringUtil.getRandomString());
        super.execute(vNodeMap, bOutAvail, bFirst);
    }

    protected JDFUsageCounter initUsageCounter() {
        if (!this.bUsageCounter) {
            return null;
        }
        JDFUsageCounter usageCounter = (JDFUsageCounter)this.theNode.getCreateResource("UsageCounter", JDFResourceLink.EnumUsage.Input, 0);
        usageCounter.setScope(JDFAutoUsageCounter.EnumScope.Job);
        return usageCounter;
    }

    @Override
    public void init() {
        super.init();
        if (this.misICSLevel < 0) {
            return;
        }
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("MIS Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        if (!this.theNode.hasAncestorAttribute("JobID", null)) {
            this.theNode.setJobID("Job" + KElement.uniqueID(0));
        }
        if (this.grayBox) {
            this.theNode.setType(JDFNode.EnumType.ProcessGroup);
        }
        this.initNodeInfo();
        this.initCustomerInfo();
        this.initUsageCounter();
    }

    protected JDFCustomerInfo initCustomerInfo() {
        JDFCustomerInfo customerInfo;
        if (this.theParentNode != null && (customerInfo = this.theParentNode.getCustomerInfo()) != null) {
            this.theNode.linkResource((JDFResource)customerInfo, JDFResourceLink.EnumUsage.Input, null);
            return customerInfo;
        }
        JDFCustomerInfo ci = this.theNode.getCreateCustomerInfo();
        ci.setResStatus(JDFResource.EnumResStatus.Available, false);
        ci.setCustomerID("customerID");
        ci.setCustomerJobName("customer job name");
        ci.setCustomerOrderID("customerOrder_1");
        JDFContact contact = ci.appendContact();
        contact.makeRootResource(null, null, true);
        contact.setContactTypes(new VString("Customer Administrator", " "));
        JDFPerson person = contact.appendPerson();
        person.setFamilyName("T\u00f6pfer");
        person.setFirstName("Harald");
        JDFComChannel phone = contact.appendComChannel();
        phone.setPhoneNumber("+666 42 123456", ".", JDFAutoComChannel.EnumChannelType.Phone);
        JDFComChannel fax = contact.appendComChannel();
        fax.setPhoneNumber("+666 42 123455", ".", JDFAutoComChannel.EnumChannelType.Fax);
        JDFComChannel mail = contact.appendComChannel();
        mail.setEMailLocator("harald.topfer@thepits.net");
        JDFCompany comp = contact.appendCompany();
        comp.setOrganizationName("The Pits");
        return ci;
    }

    @Override
    protected JDFDevice initDevice(JDFNode reuseNode) {
        JDFDevice dev = super.initDevice(reuseNode);
        if (this.misICSLevel < 2) {
            return dev;
        }
        if (dev == null) {
            JDFResourceLink rl = null;
            if (reuseNode != null) {
                rl = this.theNode.linkResource(reuseNode.getResource("Device", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
            }
            if (rl == null && this.theParentNode != null) {
                JDFResourceLink jDFResourceLink = this.theNode.linkResource(this.theParentNode.getResource("Device", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
            }
        }
        if (this.devID != null) {
            dev = (JDFDevice)this.theNode.getCreateResource("Device", JDFResourceLink.EnumUsage.Input, 0);
            dev.setResStatus(JDFResource.EnumResStatus.Available, false);
            dev.setDeviceID(this.devID);
            dev.setDescriptiveName("Device " + this.devID);
        }
        return dev;
    }

    @Override
    public void addAmountLink(String link) {
        if (this.amountLinks == null) {
            this.amountLinks = new VString();
        }
        this.amountLinks.appendUnique(link);
    }

    public void setGrayBox(boolean _grayBox) {
        this.grayBox = _grayBox;
    }

    @Override
    protected void initJDF() {
        super.initJDF();
        if (this.grayBox) {
            this.theNode.setType(JDFNode.EnumType.ProcessGroup);
        }
    }
}

