/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.cformat.PrintfFormat;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFNumberList;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.UrlUtil;

public class StringUtil {
    public static final String UTF8 = StandardCharsets.UTF_8.name();
    private static final String m_sep = " ";
    @Deprecated
    public static final String m_URIEscape = "|#%?@&=+$,;[]\\\"'<>^{}~";
    private static String[] strings = new String[]{"Randomly inserted error", "Me. I'm dishonest! And a dishonest man you can always trust to be dishonest... honestly!", "fooBar", "Snafu", "Soon TM is a registered trademark of CIP4 and does not imply, either implicitly or explicitly, any action will take place in any given time, if ever.", "Programming today is a race between software engineers striving to build bigger and better programs, and the Universe trying to produce bigger and better idiots. So far, the Universe is winning.", "Nichtsnutz geht \u00fcber Eigennutz!", "Dumb people are always blissfully unaware of how dumb they really are\u2026", "Well, it\u2019s no secret that the best thing about a secret is secretly telling someone your secret, thereby adding another secret to their secret collection of secrets, secretly.", "Bad Karma", "Ihr Instrumente freilich spottet mein, Mit Rad und K\u00e4mmen, Walz und B\u00fcgel: Ich stand am Tor, ihr solltet Schl\u00fcssel sein; Zwar euer Bart ist kraus, doch hebt ihr nicht die Riegel.", "What do you expect from a simulator", "Paper Jam", "Strawberry jam", "Elderberry jam", "Your mother was a hamster and your father smelt of elderberries!", "I'm French! Why do think I have this outrageous accent, you silly king-a?!", "It's just a flesh wound.", "All right, we'll call it a draw.", "Oh, oh, I see! Running away, eh? You yellow bastards! Come back here and take what's coming to you! I'll bite your legs off!", "You don't frighten us, English pig-dogs!", "Go and boil your bottom, sons of a silly person.", "I blow my nose at you, so-called Arthur King, you and all your silly English k-nnnnniggets. Thpppppt! Thppt! Thppt!", "I don't wanna talk to you no more, you empty headed animal food trough wiper!", "I fart in your general direction!", "Listen, strange women lyin' in ponds distributin' swords is no basis for a system of government. Supreme executive power derives from a mandate from the masses, not from some farcical aquatic ceremony", "C'est un lapin, lapin de bois.", "Quoi? Un cadeau. What? A present. Oh, un cadeau. Oui, oui. Hurry. What? Let's go. Oh. On y va. Bon magne. Over here...", "Oh. Oh, I see. Running away, eh? You yellow bastards! Come back here and take what's coming to you. I'll bite your legs off!", "You're using coconuts!", "The swallow may fly south with the sun or the house martin or the plover may seek warmer climes in winter, yet these are not strangers to our land?", "Are you suggesting coconuts migrate?", "It's not a question of where he grips it! It's a simple question of weight ratios! A five ounce bird could not carry a one pound coconut.", "Listen. In order to maintain air-speed velocity, a swallow needs to beat its wings forty-three times every second, right?", "Oh, King, eh, very nice. And how d'you get that, eh? By exploiting the workers! By 'anging on to outdated imperialist dogma which perpetuates the economic and social differences in our society. If there's ever going to be any progress with the--", "Oh! Come and see the violence inherent in the system! Help! Help! I'm being repressed!", "Here I am, brain the size of a planet, and they ask me to take you to the bridge. Call that job satisfaction, 'cause I don't.", "Ghastly, isn't it? All the doors on this spaceship have been programmed to have a cheery and sunny disposition.", "whazzap?", "Explain again how sheep's bladders may be employed to prevent earthquakes.", "Pardon me for breathing, which I never do anyway so I don't know why I even bothered to say it. Oh god, I'm so depressed.", "I've got this pain in all the diodes down my left side", "I would like to say that it is a very great pleasure, honour and privilege for me to open this bridge, but I can't because my lying circuits are all out of commission", "Do you want me to sit in the corner and rust, or just fall apart where I'm standing?", "You may think you've read Hamlet before, but you can't really appreciate it until you've read it in the original Klingon.", "What's this, then? \"Romanes eunt domus\"? People called Romanes, they go, the house?", "Life's a piece of shit when you look at it. Life's a laugh and death's a joke; it's true.", "Excuse me. Are you the Judean People's Front? Fuck off! We're the People's Front of Judea", "How many Romans? - Aaaaagh ! Plural, plural, er, \"ite\" ! - \"Domus\"? Nominative? \"Go home\" is motion towards, isn't it? - Dative ! -  Aaagh ! Not the dative, not the dative ! Er, er, accusative, \"Domum\" ! - But \"Domus\" takes the locative, which is...? Er, \"Domum\" ! ", "Making it worse? How can it be worse? Jehovah! Jehovah! Jehovah! ", "No, I'm only joking. I'm not really Brian. No, I'm not Brian. I was only - It was a joke. I'm only pulling your leg! It's a joke! I'm not him! I'm just having you on! Put me back! Bloody Romans! Can't take a joke! ", "Er, well, um, if you're dropping by again, do pop in. Heh. And thanks a lot for the gold and frankincense, er, but don't worry too much about the myrrh next time. All right? Heh. Thank you. Good-bye.", "Under the terms of the Roman occupancy, we're entitled to be crucified in a purely Jewish area.", "Amongst our weaponry are such diverse elements as: fear, surprise, ruthless efficiency, an almost fanatical devotion to the Pope, and nice red uniforms - Oh damn!", "*Nobody* expects the Spanish Inquisition! Our chief weapon is surprise, surprise and fear, fear and surprise. Our *two* weapons are fear and surprise, and ruthless efficiency. Our *three* weapons are fear and surprise and ruthless efficiency and an almost fanatical dedication to the pope. Our *four*... No... Amongst our weapons... Amongst our weaponry are such elements as fear, sur- I'll come in again. ", "NOBODY expects the Spanish Inquisition!", "Hm! She is made of harder stuff! Cardinal Fang! Fetch...THE COMFY CHAIR!", "So you think you are strong because you can survive the soft cushions. Well, we shall see. Biggles! Put her in the Comfy Chair!", "Tungsten carbide drills? What the bloody hell's tungsten carbide drills? - It's something they use in coal mining, father.' Your bloody fancy talk since you left London.", "I'll tell you what's wrong with it, my lad. It's dead, that's what's wrong with it!", "All right then, if it's restin', I'll wake him up! (shouts into cage) Hello Polly! I've got a nice cuttlefish for you when you wake up, Polly Parrot!", "Look, I took the liberty of examining that parrot, and I discovered the only reason that it had been sitting on its perch in the first place was that it had been nailed there.", "Look matey (picks up the parrot) this parrot wouldn't voom if you put four thousand volts through it! It's bleedin' demised!", "It's not pining, it's passed on. This parrot is no more! It has ceased to be. It's expired and gone to meet its maker.This is a late parrot. It's a stiff. Bereft of life, it rests in peace. If you hadn't nailed it to the perch it would be pushing up the daisies. It's rung down the curtain and joined the choir invisible. This is an ex-parrot.", "Pining for the fjords, what kind of talk is that? Look, why did it fall flat on its back the moment I got it home?", "Whatever it was, I'm sure it was better than my plan to get out of this by pretending to be mad. I mean, who would have noticed another madman round here?", "C: Big, blue wobbly thing that mermaids live in.", "Baldrick, you wouldn't recognize a subtle plan if it painted itself purple and danced naked on a harpsicord singing 'subtle plans are here again'.", "To you it's a potato, to me it's a potato. But to Sir Walter Bloody Raleigh it's country estates, fine carriages, and as many girls as his tongue can cope with. He's making a fortune out of the things; people are smoking them, building houses out of them... They'll be eating them next.", "E: Look, there's no need to panic. Someone in the crew will know how to steer this thing.\nR: The crew, milord?\nE: Yes, the crew.\nR: What crew?\nE: I was under the impression that it was common maritime practice for a ship to have a crew.\nR: Opinion is divided on the subject.\n", "If we do happen to step on a mine, Sir, what do we do ?\nNormal procedure, Lieutenant, is to jump 200 feet in the air and scatter oneself over a wide area.", "Gentlemen, you can't fight in here, this is the War Room!", "I love it when a plan comes together", "Das also war des Pudels Kern!", "I feel that if a person can't communicate the very least he can do is to shut up", "Always carry a flagon of whiskey in case of snakebite and furthermore always carry a small snake.", "Anyone who hates children and animals can't be all bad.", "Ein Teil von jener Kraft, Die stets das B\u00f6se will und stets das Gute schafft.", "Von allen Geistern, die verneinen, ist mir der Schalk am wenigsten zur Last.", "And the Lord spake, saying, 'First shalt thou take out the Holy Pin. Then, shalt thou count to three, no more, no less. Three shalt be the number thou shalt count, and the number of the counting shall be three. Four shalt thou not count, nor either count thou two, excepting that thou then proceed to three. Five is right out. Once the number three, being the third number, be reached, then lobbest thou thy Holy Hand Grenade of Antioch towards thy foe, who, being naughty in my sight, shall snuff it.", "The slightest thought hadn't even begun to speculate about the merest possibility of crossing my mind.", "Right, Baldrick, let's try again, shall we? This is called adding. If I have two beans, and then I add two more beans, what do I have?\nSome beans.\nYes...and no. Let's try again, shall we? I have two beans, then I add two more beans. What does that make?\nA very small casserole.\nBaldrick, the ape creatures of the Indus have mastered this. Now try again. One, two, three, four. So how many are there?\nThree\nWhat?\nAnd that one.\nThree and that one. So if I add that one to the three what will I have?\nOh! Some beans.\nYes. To you Baldrick, the Renaissance was just something that happened to other people wasn't it?", "It's got a cop motor, a 440 cubic inch plant, it's got cop tires, cop suspensions, cop shocks. It's a model made before catalytic converters so it'll run good on regular gas. What do you say, is it the new Bluesmobile or what?", "Yes. The plans were on display in the bottom of a locked filing cabinet, stuck in a disused lavatory with a sign on the door saying 'Beware of the Leopard'", "It's 106 miles to Chicago, we got a full tank of gas, half a pack of cigarettes, it's dark, and we're wearing sunglasses. ", "Ich bin der Geist, der stets verneint! Und das mit Recht; denn alles, was entsteht,  Ist wert, da\u00df es zugrunde geht;  Drum besser w\u00e4r's, da\u00df nichts entst\u00fcnde.  So ist denn alles, was ihr S\u00fcnde,  Zerst\u00f6rung, kurz das B\u00f6se nennt,  Mein eigentliches Element.", "Als Gregor Samsa eines Morgens aus unruhigen Tr\u00e4umen erwachte, fand er sich in seinem Bett zu einem ungeheueren Ungeziefer verwandelt.", "Du hast wohl recht; ich finde nicht die Spur\nvon einem Geist, und alles ist Dressur.", "'I got very bored and depressed, so I went and plugged myself in to its external computer feed. I talked to the computer at great length and explained my view of the Universe to it', said Marvin. 'And what happened?' pressed Ford. 'It committed suicide.'", "Wie nur dem Kopf nicht alle Hoffnung schwindet,\nDer immerfort an schalem Zeuge klebt,\nMit gier'ger Hand nach Sch\u00e4tzen gr\u00e4bt,\nUnd froh ist, wenn er Regenw\u00fcrmer findet!", "Der Dadaist ist ein K\u00fcnstler, bei dem das Produkt als solches nebens\u00e4chlich ist. Er ist ein Geistesreisender, der immer neue Erfahrungen macht. Ein Zeichen daf\u00fcr, dass Dadaismus doch produktiv im herk\u00f6mmlichen Sinne der bildenden Kunst ist, zeigt der groteske Humor, der sich in den Gedichten und Bildern wieder findet. Auch die Ironie, die die K\u00fcnstler in ihre Werke einflie\u00dfen lassen, spricht f\u00fcr modale Pr\u00e4senz von \u201eSinn im Unsinn\u201c, der immer dort ist, wo er nicht zu sein scheint.", "Half a bee, philosophically, must, ipso facto, half not be. But half the bee has got to be, vis a vis its entity - do you see? But can a bee be said to be or not to be an entire bee when half the bee is not a bee due to some ancient injury?", "Mein sch\u00f6nes Fr\u00e4ulein, darf ich wagen, Meinen Arm und Geleit Ihr anzutragen? Bin weder Fr\u00e4ulein, weder sch\u00f6n, Kann ungeleitet nach Hause gehn.", "And I'm thinking you weren't burdened with an overabundance of schooling. So why don't we just ignore each other 'til we go away.", "Im \u00fcbrigen will ich keines Menschen Urteil, ich will nur Kenntnisse verbreiten, ich berichte nur, auch Ihnen, hohe Herren von der Akademie, habe ich nur berichtet.", "I'm afraid not. The guns have stopped because we are about to attack. Not even our generals are mad enough to shell their own men. They feel it's more sporting to let the Germans do it. ", "If they take the ship they will rape us to death, eat our flesh, and sew our skins in to their clothing, and if we're very, very lucky, they\u2019ll do it in that order.", "Hier konnte niemand sonst Einla\u00df erhalten, denn dieser Eingang war nur f\u00fcr dich bestimmt. Ich gehe jetzt und schlie\u00dfe ihn.", "Hohe Herren von der Akademie! Sie erweisen mir die Ehre, mich aufzufordern, der Akademie einen Bericht \u00fcber mein \u00e4ffisches Vorleben einzureichen.", "Not only is this incomprehensible, but the ink is ugly and the paper is from the wrong kind of tree.", "If the code and the comments disagree, then both are probably wrong.", "A radioactive cat has eighteen half-lives.", "Silence! I kill you!", "Although golf was originally restricted to wealthy, overweight Protestants, today it's open to anybody who owns hideous clothing.", "Base eight is just like base ten really - if you're missing two fingers", "Biology is the only science in which multiplication means the same thing as division.", "My dog's not eating, he no longer barks; He hit the propeller and turned into sparks", "One leg is missing; the other is gone; The third leg is scattered all over the lawn; No need explaining the one leg remaining is spinning on the carport floor", "\"Once the rockets are up, who cares where they come down? That's not my department,\" says Wernher von Braun.", "Last quote"};

    private StringUtil() {
    }

    public static String getRandomString() {
        int pos = (int)((double)strings.length * Math.random() * 0.99999);
        return strings[pos];
    }

    public static String zappTokenWS(String str, String delim) {
        StringBuilder s = new StringBuilder();
        StringArray vs = new StringArray(str, delim);
        int size = vs.size();
        if (size > 0) {
            s.append(vs.get(0).trim());
            for (int i = 1; i < size; ++i) {
                s.append(delim);
                s.append(vs.get(i).trim());
            }
        }
        return s.toString();
    }

    public static String sprintf(String format, String template) {
        if (template == null || format == null) {
            return null;
        }
        template = StringUtil.replaceString(template, "\\,", "__comma__\u00e4\u00f6-eher selten");
        VString vTemplate = StringUtil.tokenize(template, ",", false);
        Object[] vObj = new Object[vTemplate.size()];
        for (int i = 0; i < vObj.length; ++i) {
            String s = vTemplate.get(i);
            vObj[i] = StringUtil.isInteger(s) ? Integer.valueOf(StringUtil.parseInt(s, 0)) : (StringUtil.isNumber(s) ? Double.valueOf(StringUtil.parseDouble(s, 0.0)) : StringUtil.replaceString(s, "__comma__\u00e4\u00f6-eher selten", ","));
        }
        return StringUtil.sprintf(format, vObj);
    }

    public static String sprintf(String format, Object[] objects) {
        int nStart;
        if (objects == null || format == null) {
            return null;
        }
        format = StringUtil.replaceString(format, "%%", "__percent__\u00e4\u00f6-eher selten");
        boolean bStart = format.startsWith("%");
        VString tokens = StringUtil.tokenize(format, "%", false);
        int n = nStart = bStart ? 0 : 1;
        if (tokens.size() > objects.length + nStart) {
            throw new IllegalArgumentException("not enough tokens to satisfy format");
        }
        String s = bStart ? "" : tokens.get(0);
        for (int i = nStart; i < tokens.size(); ++i) {
            PrintfFormat f = new PrintfFormat("");
            f.set("%" + tokens.get(i));
            Object ob = objects[i - nStart];
            if (ob instanceof String) {
                s = s + f.tostr((String)ob);
                continue;
            }
            if (ob instanceof Integer) {
                s = s + f.tostr((Integer)ob);
                continue;
            }
            if (ob instanceof Long) {
                s = s + f.tostr((Long)ob);
                continue;
            }
            if (ob instanceof Double) {
                s = s + f.tostr((Double)ob);
                continue;
            }
            if (!(ob instanceof ValuedEnum)) continue;
            s = s + f.tostr(((ValuedEnum)ob).getName());
        }
        return StringUtil.replaceString(s, "__percent__\u00e4\u00f6-eher selten", "%");
    }

    public static String setvString(String[] a, String sep, String front, String back) {
        if (a == null) {
            return null;
        }
        VString v = new VString(a);
        return StringUtil.setvString(v, sep, front, back);
    }

    public static String setvString(List<?> v) {
        return StringUtil.setvString(v, m_sep, null, null);
    }

    public static String setvString(List<?> v, String sep, String front, String back) {
        if (v == null) {
            return null;
        }
        int siz = v.size();
        StringBuilder buf = new StringBuilder(siz * 16);
        if (front != null) {
            buf.append(front);
        }
        boolean next = false;
        for (int i = 0; i < siz; ++i) {
            Object elementAt;
            if (next && sep != null) {
                buf.append(sep);
            }
            if ((elementAt = v.get(i)) instanceof String) {
                buf.append((String)elementAt);
                next = true;
                continue;
            }
            if (elementAt instanceof ValuedEnum) {
                buf.append(((ValuedEnum)elementAt).getName());
                next = true;
                continue;
            }
            if (elementAt == null) continue;
            throw new IllegalArgumentException("illegal vector contents");
        }
        if (back != null) {
            buf.append(back);
        }
        String ret = buf.toString();
        return StringUtil.getNonEmpty(ret);
    }

    public static String leftStr(String strWork, int n) {
        if (strWork == null) {
            return null;
        }
        if (n < 0) {
            n = strWork.length() + n;
        }
        if (n <= 0) {
            return null;
        }
        return strWork.substring(0, n <= strWork.length() ? n : strWork.length());
    }

    public static String substring(String strWork, int first, int last) {
        if (strWork == null) {
            return null;
        }
        if (first < 0) {
            first = strWork.length() + first;
        }
        if (first < 0) {
            first = 0;
        }
        if (first > strWork.length()) {
            return null;
        }
        if (last <= 0) {
            last = strWork.length() + last;
        }
        if (last < first) {
            return null;
        }
        if (last >= strWork.length()) {
            last = strWork.length();
        }
        return strWork.substring(first, last);
    }

    public static String rightStr(String strWork, int n) {
        if (strWork == null) {
            return null;
        }
        if (n < 0) {
            n = strWork.length() + n;
        }
        if (n <= 0) {
            return null;
        }
        if (n > strWork.length()) {
            return strWork;
        }
        return strWork.substring(strWork.length() - n);
    }

    public static VString tokenize(String strWork, String delim, boolean delim2token) {
        if (delim2token) {
            delim = delim == null ? m_sep : delim;
            VString v = new VString();
            StringTokenizer st = new StringTokenizer(strWork, delim, delim2token);
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
            return v;
        }
        return new VString(strWork, delim);
    }

    public static VString tokenizeBrackets(String strWork, char delimIn, char delimOut) {
        if (strWork == null) {
            return null;
        }
        VString v = new VString();
        int depth = 0;
        int pos0 = 0;
        for (int i = 0; i < strWork.length(); ++i) {
            char c = strWork.charAt(i);
            if (c == delimIn) {
                if (v.isEmpty()) {
                    v.add(strWork.substring(0, i));
                    pos0 = i + 1;
                    continue;
                }
                ++depth;
                continue;
            }
            if (c != delimOut || depth-- != 0) continue;
            if (v.isEmpty()) {
                v.add(strWork.substring(0, i));
                v.add("");
            } else {
                v.add(strWork.substring(pos0, i));
            }
            pos0 = i + 1;
            break;
        }
        if (pos0 <= strWork.length()) {
            v.add(strWork.substring(pos0));
        }
        return v;
    }

    public static boolean hasToken(String strWork, String token, String delim, int iSkip) {
        if (StringUtil.isEmpty(strWork)) {
            return false;
        }
        if (delim == null) {
            delim = m_sep;
        }
        if (iSkip == 0 || iSkip == -1) {
            return StringUtil.indexOfToken(strWork, token, delim, 0) >= 0;
        }
        if (iSkip < -1) {
            StringArray a = StringArray.getVString(strWork, null);
            String[] as = a.toArray(new String[0]);
            return StringUtil.hasToken(as, token, iSkip);
        }
        int posToken1 = strWork.indexOf(token);
        if (posToken1 < 0) {
            return false;
        }
        if (posToken1 > 0) {
            --posToken1;
        }
        String substring = strWork.substring(posToken1);
        StringTokenizer st = new StringTokenizer(substring, delim, false);
        int n = 0;
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(token) || n++ < iSkip) continue;
            return true;
        }
        return false;
    }

    public static boolean hasToken(String[] strWork, String token, int iSkip) {
        block4: {
            if (strWork == null) break block4;
            int n = 0;
            if (iSkip < 0) {
                for (int i = strWork.length - 1; i >= 0; --i) {
                    if (!token.equals(strWork[i]) || --n > iSkip) continue;
                    return true;
                }
            } else {
                for (String element : strWork) {
                    if (!token.equals(element) || n++ < iSkip) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String addToken(String strWork, String delim, String newToken) {
        if (strWork == null) {
            return newToken;
        }
        if (newToken == null) {
            return strWork;
        }
        while (strWork != null && strWork.endsWith(delim)) {
            strWork = StringUtil.leftStr(strWork, -delim.length());
        }
        while (newToken != null && newToken.startsWith(delim)) {
            newToken = StringUtil.rightStr(newToken, -delim.length());
        }
        return (strWork == null ? "" : strWork) + delim + newToken;
    }

    public static String removeToken(String strWork, int index, String delim) {
        return StringUtil.getNonEmpty(StringUtil.replaceToken(strWork, index, delim, null));
    }

    public static String replaceToken(String strWork, String oldToken, String delim, String newToken) {
        int pos = StringUtil.posOfToken(strWork, oldToken, delim, 0);
        return pos >= 0 ? StringUtil.replaceToken(strWork, pos, delim, newToken) : strWork;
    }

    public static String removeToken(String strWork, String oldToken, String delim) {
        return StringUtil.replaceToken(strWork, oldToken, delim, null);
    }

    public static String replaceToken(String strWork, int index, String delim, String newToken) {
        if (delim == null) {
            delim = m_sep;
        }
        VString v = StringUtil.tokenize(strWork, delim, false);
        if (index < 0) {
            index += v.size();
        }
        if (index >= v.size() || index < 0) {
            return strWork;
        }
        VString v2 = StringUtil.tokenize(strWork, delim, true);
        int n = 0;
        int i = 0;
        for (String token : v2) {
            if (!delim.equals(token)) {
                if (n == index) break;
                ++n;
            }
            ++i;
        }
        if (newToken == null) {
            v2.remove(i);
            if (i > 0) {
                v2.remove(i - 1);
            } else if (i < v2.size()) {
                v2.remove(i);
            }
        } else {
            v2.set(i, newToken);
        }
        return StringUtil.setvString(v2, null, null, null);
    }

    public static String token(String strWork, int index, String delim) {
        int pos;
        if (StringUtil.getNonEmpty(strWork) == null) {
            return null;
        }
        if (delim == null) {
            delim = m_sep;
        }
        int n = pos = delim.length() == 1 ? strWork.indexOf(delim) : 0;
        if (pos < 0) {
            return index == -1 || index == 0 ? strWork : null;
        }
        if (index < 0) {
            VString v = StringUtil.tokenize(strWork, delim, false);
            index = v.size() + index;
            if (index < 0) {
                return null;
            }
            if (index < v.size()) {
                return v.get(index);
            }
            return null;
        }
        StringTokenizer st = new StringTokenizer(strWork, delim, false);
        int n2 = 0;
        String s = null;
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (n2++ != index) continue;
            return s;
        }
        return null;
    }

    public static String replaceCharSet(String strWork, String charSet, String replaceString, int offset) {
        if (charSet == null) {
            return strWork;
        }
        for (int i = 0; i < charSet.length(); ++i) {
            strWork = StringUtil.replaceChar(strWork, charSet.charAt(i), replaceString, offset);
        }
        return strWork;
    }

    public static String replaceChar(String strWork, char c, String replaceString, int offset) {
        if (strWork == null) {
            return null;
        }
        if (offset > strWork.length() || strWork.indexOf(c, offset) < 0) {
            return strWork;
        }
        StringBuilder b = new StringBuilder(strWork.length() * 2);
        int lastPos = offset;
        b.append(strWork.substring(0, offset));
        while (lastPos >= 0) {
            int pos = strWork.indexOf(c, lastPos);
            if (pos >= 0) {
                b.append(strWork.substring(lastPos, pos));
                if (replaceString != null) {
                    b.append(replaceString);
                }
            } else {
                b.append(strWork.substring(lastPos));
            }
            lastPos = pos >= 0 ? pos + 1 : pos;
        }
        return b.toString();
    }

    public static String replaceString(String strWork, String toReplace, String replaceBy) {
        return new StringReplacer(strWork).replaceString(toReplace, replaceBy);
    }

    public static String xmlNameEscape(String strWork) {
        String strWorkLocal = strWork;
        strWorkLocal = StringUtil.replaceChar(strWorkLocal, '*', "_star_", 0);
        strWorkLocal = StringUtil.replaceChar(strWorkLocal, '&', "_and_", 0);
        return strWorkLocal;
    }

    @Deprecated
    public static String extension(String pathName) {
        return UrlUtil.extension(pathName);
    }

    @Deprecated
    public static String prefix(String strWork) {
        return UrlUtil.prefix(strWork);
    }

    public static String normalize(String strWork, boolean toLower) {
        return StringUtil.normalize(strWork, toLower, m_sep);
    }

    public static String normalize(String strWork) {
        return StringUtil.normalize(strWork, false, m_sep);
    }

    public static String normalize(String strWork, boolean toLower, String replace) {
        if (strWork == null) {
            return null;
        }
        if (StringUtil.getNonEmpty(strWork = strWork.trim()) == null) {
            return null;
        }
        if (replace == null) {
            replace = "";
        }
        strWork = strWork.replaceAll("\\s+", replace);
        if (toLower) {
            strWork = strWork.toLowerCase();
        }
        return strWork;
    }

    public static String getDefaultNull(String s, String def) {
        return s == null || s.equals(def) ? null : s;
    }

    public static int getDistance(String s1, String s2, boolean normalize, boolean ignoreCase, boolean ignoreEmpty, boolean reduceSubstring) {
        if (!reduceSubstring) {
            return StringUtil.getDistance(s1, s2, normalize, ignoreCase, ignoreEmpty);
        }
        int s11 = StringUtil.length(s1);
        int s21 = StringUtil.length(s2);
        int min = Math.min(s11, s21);
        int max = Math.max(s11, s21);
        if (min == 0) {
            return 0;
        }
        String base = s11 < s21 ? s2 : s1;
        String other = s11 < s21 ? s1 : s2;
        int steps = max - min + 1;
        int ret = Integer.MAX_VALUE;
        for (int i = 0; i < steps; ++i) {
            int d = StringUtil.getDistance(base.substring(i, min + i), other, normalize, ignoreCase, ignoreEmpty);
            ret = Math.min(d, ret);
            if (ret != 0) continue;
            return ret;
        }
        return ret;
    }

    public static int length(String s1) {
        return s1 == null ? 0 : s1.length();
    }

    public static int getDistance(String s1, String s2, boolean normalize, boolean ignoreCase, boolean ignoreEmpty) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if (ignoreCase) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
        }
        if (normalize) {
            s1 = StringUtil.normalize(s1, false);
            s2 = StringUtil.normalize(s2, false);
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
        }
        if (s1.equals(s2) || ignoreEmpty && ("".equals(s1) || "".equals(s2))) {
            return 0;
        }
        int minLen = Math.min(s1.length(), s2.length());
        int factor = 1;
        for (int i = 0; i < 4; ++i) {
            if (minLen > i) continue;
            factor *= 2;
        }
        return factor * StringUtils.getLevenshteinDistance((String)s1, (String)s2);
    }

    public static String getNonEmpty(String s) {
        return StringUtil.isEmpty(s) ? null : s;
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static boolean isEmpty(Collection<String> v) {
        return v == null || v.isEmpty() || v.size() == 1 && StringUtil.isEmpty(v.iterator().next());
    }

    public static boolean hasContent(String s) {
        return s != null && !"".equals(s) && StringUtil.normalize(s, false) != null;
    }

    @Deprecated
    public static String newExtension(String strWork, String newExt) {
        return UrlUtil.newExtension(strWork, newExt);
    }

    @Deprecated
    public static String xmlNameSpace(String strWork) {
        return KElement.xmlnsPrefix(strWork);
    }

    @Deprecated
    public static String mime(String strWork) {
        return UrlUtil.getMimeTypeFromURL(strWork);
    }

    public static boolean isNMTOKEN(String strWork) {
        if (strWork == null) {
            return false;
        }
        if (strWork.length() >= 64) {
            return false;
        }
        if ("*".equals(strWork)) {
            return true;
        }
        return StringUtil.matches(strWork, "(\\pL|[0-9]|\\.|:|\\-|_)+");
    }

    public static boolean isID(String strWork) {
        if (strWork == null || strWork.length() == 0) {
            return false;
        }
        if (StringUtils.isNumeric((String)strWork.substring(0, 1))) {
            return false;
        }
        return StringUtil.isNMTOKEN(strWork);
    }

    public static boolean isEqual(double d1, double d2) {
        return StringUtil.isEqual(d1, d2, 1.0E-6);
    }

    public static boolean isEqual(double d1, double d2, double delta) {
        if (d1 == d2) {
            return true;
        }
        if (delta > 0.0) {
            if (Math.abs(d1 - d2) <= delta) {
                return true;
            }
            if (delta < 0.42 && d1 != 0.0 && Math.abs(d2 / d1 - 1.0) < delta) {
                return true;
            }
        }
        return false;
    }

    public static int compareTo(double d1, double d2) {
        if (StringUtil.isEqual(d1, d2)) {
            return 0;
        }
        return d1 < d2 ? -1 : 1;
    }

    @Deprecated
    public static boolean isNMTOKENS(String strWork) {
        return StringUtil.isNMTOKENS(strWork, false);
    }

    public static boolean isNMTOKENS(String strWork, boolean bID) {
        if (strWork == null) {
            return false;
        }
        VString vs = StringUtil.tokenize(strWork, "\t ", false);
        int s = vs.size();
        if (s == 0) {
            return true;
        }
        for (int i = 0; i < s; ++i) {
            if ((!bID || StringUtil.isID(vs.get(i))) && StringUtil.isNMTOKEN(vs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBoolean(String strWork) {
        return StringUtil.parseBoolean(strWork, true) == StringUtil.parseBoolean(strWork, false);
    }

    public static boolean isDate(String strWork) {
        return JDFDate.createDate(strWork) != null;
    }

    public static boolean isNumberList(String strWork) {
        return JDFNumberList.createNumberList(strWork) != null;
    }

    public static Charset getCharset(String csName) {
        try {
            return Charset.forName(csName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EDataType getDataType(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtil.isNumber(s)) {
            return StringUtil.isInteger(s) ? EDataType.integer : EDataType.number;
        }
        if (StringUtil.isBoolean(s)) {
            return EDataType.bool;
        }
        if (StringUtil.isDate(s)) {
            return EDataType.date;
        }
        if (StringUtil.isNumberList(s)) {
            return EDataType.numberlist;
        }
        return EDataType.string;
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        String dStr = str.trim();
        if (dStr.isEmpty()) {
            return false;
        }
        char first = dStr.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9' || first == 'I' || first == '.') {
            if (dStr.indexOf(m_sep) >= 0) {
                return false;
            }
            return !Double.isNaN(StringUtil.parseDouble(str, Double.NaN));
        }
        return false;
    }

    public static String wipeInvalidXML10Chars(String strText, String replace) {
        String strTextLocal = strText;
        char[] chars = strTextLocal.toCharArray();
        boolean found = false;
        int n = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (n > 0) {
                chars[i - n] = chars[i];
            }
            if (StringUtil.isValidXML10Char(chars[i])) continue;
            if (replace != null) {
                chars[i] = replace.charAt(0);
            } else {
                ++n;
            }
            found = true;
        }
        if (found) {
            strTextLocal = new String(chars);
            if (n > 0) {
                strTextLocal = strTextLocal.substring(0, chars.length - n);
            }
        }
        return strTextLocal;
    }

    private static boolean isValidXML10Char(char c) {
        if (c >= ' ' && c <= '\ud7ff') {
            return true;
        }
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        return c >= '\ue000' && c <= '\ufffd';
    }

    public static int find_last_not_of(String strWork, String strNotList) {
        if (strWork == null) {
            return -1;
        }
        if (strNotList == null || strNotList.length() == 0) {
            return strWork.length() - 1;
        }
        for (int i = strWork.length() - 1; i >= 0; --i) {
            if (strNotList.indexOf(strWork.charAt(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    public static int posOfToken(String strWork, String name, String separator, int iSkip) {
        if (strWork == null || name == null || strWork.indexOf(name) < 0) {
            return -1;
        }
        int posOfToken = -1;
        VString vNames = StringUtil.tokenize(strWork, separator, false);
        if (iSkip == -1 || iSkip == 0) {
            posOfToken = vNames.indexOf(name);
        } else {
            int occurence = 0;
            for (int i = 0; i < vNames.size(); ++i) {
                String strName = vNames.elementAt(i);
                if (!strName.equals(name) || occurence++ != iSkip) continue;
                posOfToken = i;
                break;
            }
        }
        return posOfToken;
    }

    @Deprecated
    public static boolean hasToken(String strWork, String token, String delim) {
        return StringUtil.hasToken(strWork, token, delim, 0);
    }

    public static int indexOfToken(String strWork, String token, String delim, int start) {
        if (delim == null) {
            delim = m_sep;
        }
        if (strWork != null) {
            int tl = token.length();
            int sl = strWork.length();
            int p0 = start;
            while (tl + p0 <= sl) {
                int posToken1 = strWork.indexOf(token, p0);
                if (posToken1 < 0) {
                    return posToken1;
                }
                if (posToken1 == 0 && (tl == sl || delim.indexOf(strWork.charAt(tl)) >= 0)) {
                    return posToken1;
                }
                if (posToken1 > 0 && delim.indexOf(strWork.charAt(posToken1 - 1)) >= 0 && (sl == posToken1 + tl || delim.indexOf(strWork.charAt(posToken1 + tl)) >= 0)) {
                    return posToken1;
                }
                if (posToken1 < 0) continue;
                p0 = posToken1 + 1;
            }
        }
        return -1;
    }

    public static int numSubstrings(String strWork, String subString) {
        if (strWork == null || subString == null || subString.length() == 0) {
            return 0;
        }
        int n = 0;
        int pos = 0;
        while (pos >= 0) {
            if ((pos = strWork.indexOf(subString, pos)) < 0) continue;
            ++n;
            ++pos;
        }
        return n;
    }

    public static String setRawBytes(byte[] buffer, int len) {
        if (len < 0) {
            len = buffer.length;
        }
        char[] target = null;
        if (len > 0) {
            target = new char[len];
            for (int i = 0; i < len; ++i) {
                target[i] = (char)buffer[i];
            }
        } else {
            target = new char[]{};
        }
        return new String(target);
    }

    public static byte[] getRawBytes(String strUnicode) {
        char[] pBuf = strUnicode.toCharArray();
        int len = pBuf.length;
        byte[] pc = new byte[len];
        for (int i = 0; i < len; ++i) {
            pc[i] = (byte)(pBuf[i] & 0xFF);
        }
        return pc;
    }

    public static String setHexBinaryBytes(byte[] buffer, int len) {
        char[] target = null;
        if (buffer != null) {
            if (len < 0) {
                len = buffer.length;
                target = new char[len * 2];
            }
            if (len > 0) {
                target = new char[len * 2];
                for (int i = 0; i < len; ++i) {
                    char c = (char)((buffer[i] & 0xF0) >> 4);
                    target[2 * i] = c >= '\n' ? (char)(55 + c) : (char)(48 + c);
                    c = (char)(buffer[i] & 0xF);
                    target[2 * i + 1] = c >= '\n' ? (char)(55 + c) : (char)(48 + c);
                }
            } else {
                target = new char[]{};
            }
        } else {
            target = new char[]{};
        }
        return new String(target);
    }

    public static byte[] getHexBinaryBytes(byte[] unicodeArray) {
        int len;
        byte[] emptyArray = new byte[]{};
        int n = len = unicodeArray == null ? 0 : unicodeArray.length;
        if (len % 2 > 0) {
            return emptyArray;
        }
        byte[] pc = new byte[len / 2];
        int c = 48;
        int i = 0;
        while (i < len / 2) {
            int p = unicodeArray[i * 2] & 0xFF;
            if (p >= 48 && p <= 57) {
                c = (byte)(p - 48);
            } else if (p >= 65 && p <= 70) {
                c = (byte)(10 + p - 65);
            } else if (p >= 97 && p <= 102) {
                c = (byte)(10 + p - 97);
            } else {
                return emptyArray;
            }
            pc[i] = (byte)(c << 4);
            p = unicodeArray[i * 2 + 1] & 0xFF;
            if (p >= 48 && p <= 57) {
                c = (byte)(p - 48);
            } else if (p >= 65 && p <= 70) {
                c = (byte)(10 + p - 65);
            } else if (p >= 97 && p <= 102) {
                c = (byte)(10 + p - 97);
            } else {
                return emptyArray;
            }
            int n2 = i++;
            pc[n2] = (byte)(pc[n2] + c);
        }
        return pc;
    }

    public static byte[] getUTF8Bytes(String strUnicode) {
        if (StringUtil.getNonEmpty(strUnicode) != null) {
            return strUnicode.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    @Deprecated
    public static byte[] setUTF8String(String strUnicode) {
        return StringUtil.getUTF8Bytes(strUnicode);
    }

    public static String getUTF8String(byte[] utf8) {
        if (utf8 != null && utf8.length != 0) {
            try {
                String s = new String(utf8, UTF8);
                if (s.indexOf(65533) >= 0) {
                    s = new String(utf8, "Cp1252");
                }
                return s;
            }
            catch (UnsupportedEncodingException e) {
                return new String(utf8, StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    public static String formatDouble(double d) {
        return new NumberFormatter().formatDouble(d);
    }

    public static String formatInteger(int i) {
        String s = null;
        s = i == Integer.MAX_VALUE ? "INF" : (i == Integer.MIN_VALUE ? "-INF" : String.valueOf(i));
        return s;
    }

    public static String formatLong(long i) {
        String s = null;
        s = i == Long.MAX_VALUE ? "INF" : (i == Long.MIN_VALUE ? "-INF" : String.valueOf(i));
        return s;
    }

    public static boolean isInteger(String str) {
        String intStr;
        if (str == null || str.isEmpty()) {
            return false;
        }
        String string = intStr = str.charAt(0) == ' ' ? str.trim() : str;
        if (intStr.isEmpty()) {
            return false;
        }
        char first = intStr.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9' || first == 'I' || first == 'u') {
            if (str.charAt(0) != ' ') {
                intStr = str.trim();
            }
            if (intStr.equals("INF") || intStr.equals("-INF")) {
                return true;
            }
            if (intStr.equals("unbounded")) {
                return true;
            }
            try {
                Integer.parseInt(intStr);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLong(String str) {
        if (str == null) {
            return false;
        }
        String intStr = str.trim();
        if (intStr.length() == 0) {
            return false;
        }
        char first = intStr.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9' || first == 'I' || first == 'u' || first == '.') {
            if (intStr.equals("INF")) {
                return true;
            }
            if (intStr.equals("-INF")) {
                return true;
            }
            if (intStr.equals("unbounded")) {
                return true;
            }
            try {
                Long.parseLong(intStr);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static String escape(String strToEscape, String strCharSet, String strEscapeChar, int iRadix, int iEscapeLen, int iEscapeBelow, int iEscapeAbove) {
        byte[] a_toEscape = StringUtil.getUTF8Bytes(strToEscape);
        return StringUtil.getUTF8String(StringUtil.escape(a_toEscape, strCharSet, strEscapeChar, iRadix, iEscapeLen, iEscapeBelow, iEscapeAbove));
    }

    public static boolean equals(String a, String b) {
        return ContainerUtil.equals(StringUtil.getNonEmpty(a), StringUtil.getNonEmpty(b));
    }

    public static byte[] escape(byte[] a_toEscape, String strCharSet, String strEscapeChar, int iRadix, int iEscapeLen, int iEscapeBelow, int iEscapeAbove) {
        if (a_toEscape == null) {
            return null;
        }
        if (strEscapeChar == null) {
            strEscapeChar = "\\";
        }
        if (iEscapeAbove < 0) {
            iEscapeAbove = Integer.MAX_VALUE;
        }
        int l = a_toEscape.length;
        byte[] escaped = new byte[a_toEscape.length * 4];
        int posE = 0;
        byte[] escapeCharbytes = strEscapeChar.getBytes();
        for (int i = 0; i < l; ++i) {
            int cToEscape = a_toEscape[i];
            if (cToEscape < 0) {
                cToEscape = 256 + cToEscape;
            }
            if (cToEscape > iEscapeAbove || cToEscape < iEscapeBelow || strCharSet != null && strCharSet.indexOf(cToEscape) != -1) {
                byte[] byArray = escapeCharbytes;
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte escapeCharbyte;
                    escaped[posE] = escapeCharbyte = byArray[j];
                    ++posE;
                }
                if (iRadix > 0) {
                    byte[] bufbytes;
                    int lenBuf;
                    StringBuilder buf = new StringBuilder();
                    if (iRadix == 2) {
                        buf.append(Integer.toBinaryString(cToEscape));
                    } else if (iRadix == 8) {
                        buf.append(Integer.toOctalString(cToEscape));
                    } else if (iRadix == 10) {
                        buf.append(Integer.toString(cToEscape));
                    } else if (iRadix == 16) {
                        buf.append(Integer.toHexString(cToEscape));
                    } else {
                        throw new IllegalArgumentException("StringUtil.escape radix out of range");
                    }
                    if (iEscapeLen > 0 && (lenBuf = buf.length()) < iEscapeLen) {
                        for (int j = 0; j < iEscapeLen - lenBuf; ++j) {
                            buf.insert(j, '0');
                        }
                    }
                    byte[] byArray2 = bufbytes = buf.toString().getBytes();
                    int n2 = byArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        byte bufbyte;
                        escaped[posE] = bufbyte = byArray2[j];
                        ++posE;
                    }
                    buf.delete(0, buf.length());
                    continue;
                }
                if (iRadix < 0) continue;
                escaped[posE] = a_toEscape[i];
                ++posE;
                continue;
            }
            escaped[posE] = a_toEscape[i];
            ++posE;
        }
        byte[] stringByte = new byte[posE];
        for (int i = 0; i < posE; ++i) {
            stringByte[i] = escaped[i];
        }
        return stringByte;
    }

    public static String unEscape(String strToUnescape, String strEscapeChar, int iRadix, int escapeLen) {
        if (strToUnescape == null) {
            return null;
        }
        byte[] byteUnEscape = StringUtil.getUTF8Bytes(strToUnescape);
        byteUnEscape = StringUtil.unEscape(byteUnEscape, strEscapeChar, iRadix, escapeLen);
        return StringUtil.getUTF8String(byteUnEscape);
    }

    public static byte[] unEscape(byte[] byteUnEscape, String strEscapeChar, int iRadix, int escapeLen) {
        if (byteUnEscape == null) {
            return null;
        }
        byte[] byteEscape = new byte[byteUnEscape.length];
        byte escapeChar = strEscapeChar.getBytes()[0];
        int n = 0;
        byte[] escapeSeq = new byte[escapeLen];
        for (int i = 0; i < byteUnEscape.length; ++i) {
            if (byteUnEscape[i] != escapeChar || i >= byteUnEscape.length - escapeLen) {
                byteEscape[n++] = byteUnEscape[i];
                continue;
            }
            if (iRadix <= 0 && i + 1 < byteUnEscape.length) {
                byteEscape[n++] = byteUnEscape[++i];
                continue;
            }
            for (int j = 0; j < escapeLen; ++j) {
                escapeSeq[j] = byteUnEscape[i + j + 1];
            }
            String strIsEscaped = new String(escapeSeq);
            try {
                Integer integer = Integer.valueOf(strIsEscaped, iRadix);
                byteEscape[n++] = (byte)integer.intValue();
            }
            catch (NumberFormatException ex) {
                byteEscape[n++] = escapeChar;
                for (int j = 0; j < escapeLen; ++j) {
                    byteEscape[n++] = byteUnEscape[i + j + 1];
                }
            }
            i += escapeLen;
        }
        byte[] stringByte = null;
        if (n == byteEscape.length) {
            stringByte = byteEscape;
        } else {
            stringByte = new byte[n];
            for (int i = 0; i < n; ++i) {
                stringByte[i] = byteEscape[i];
            }
        }
        return stringByte;
    }

    @Deprecated
    public static String vStringToString(VString vs) {
        return StringUtil.setvString(vs, m_sep, null, null);
    }

    public static double parseDouble(String s, double def) {
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).isEmpty()) {
            return def;
        }
        char first = s.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9' || first == 'I' || first == 'u' || first == '.') {
            if (s.equalsIgnoreCase("INF") || s.equalsIgnoreCase("unbounded")) {
                return Double.MAX_VALUE;
            }
            if (s.equalsIgnoreCase("-INF")) {
                return -1.7976931348623157E308;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                try {
                    s = StringUtil.replaceChar(s, ',', ".", 0);
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return def;
    }

    public static boolean parseBoolean(String s, boolean def) {
        if (s == null) {
            return def;
        }
        if ("false".equals(s = s.trim().toLowerCase()) || "0".equals(s)) {
            return false;
        }
        if ("true".equals(s) || "1".equals(s)) {
            return true;
        }
        return def;
    }

    public static int parseInt(String s, int def) {
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).isEmpty()) {
            return def;
        }
        char first = s.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9' || first == 'I' || first == 'u') {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                s = s.toLowerCase();
                int pos0x = s.indexOf("0x");
                if (pos0x >= 0) {
                    s = (pos0x > 0 ? StringUtil.leftStr(s, pos0x) : "") + s.substring(pos0x + 2);
                    try {
                        return Integer.parseInt(s, 16);
                    }
                    catch (NumberFormatException nfe) {
                        return def;
                    }
                }
                if (s.equalsIgnoreCase("INF") || s.equalsIgnoreCase("unbounded")) {
                    return Integer.MAX_VALUE;
                }
                if (s.equalsIgnoreCase("-INF")) {
                    return Integer.MIN_VALUE;
                }
                try {
                    double d = Double.parseDouble(s);
                    if (d > 2.147483647E9) {
                        return Integer.MAX_VALUE;
                    }
                    if (d < -2.147483648E9) {
                        return Integer.MIN_VALUE;
                    }
                    return (int)(d + 0.4999);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return def;
    }

    public static long parseLong(String s, long def) {
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).isEmpty()) {
            return def;
        }
        char first = s.charAt(0);
        if (first == '+' || first == '-' || first >= '0' && first <= '9' || first == 'I' || first == 'u') {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                s = s.toLowerCase();
                int pos0x = s.indexOf("0x");
                if (pos0x >= 0) {
                    s = (pos0x > 0 ? StringUtil.leftStr(s, pos0x) : "") + s.substring(pos0x + 2);
                    try {
                        return Long.parseLong(s, 16);
                    }
                    catch (NumberFormatException nfe) {
                        return def;
                    }
                }
                if (s.equalsIgnoreCase("INF") || s.equalsIgnoreCase("unbounded")) {
                    return Long.MAX_VALUE;
                }
                if (s.equalsIgnoreCase("-INF")) {
                    return Long.MIN_VALUE;
                }
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException nfe) {
                    try {
                        double d = Double.parseDouble(s);
                        if (d > 9.223372036854776E18) {
                            return Long.MAX_VALUE;
                        }
                        if (d < -9.223372036854776E18) {
                            return Long.MIN_VALUE;
                        }
                        return (long)(d + 0.4999);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
            }
        }
        return def;
    }

    public static String uncToUrl(String unc, boolean bEscape128) {
        return UrlUtil.fileToUrl(new File(unc), bEscape128);
    }

    public static String pathToName(String pathName) {
        if (UrlUtil.isWindowsLocalPath(pathName) || UrlUtil.isUNC(pathName)) {
            return StringUtil.token(pathName, -1, "\\");
        }
        return StringUtil.token(pathName, -1, "/");
    }

    @Deprecated
    public static boolean isWindowsLocalPath(String pathName) {
        return UrlUtil.isWindowsLocalPath(pathName);
    }

    @Deprecated
    public static boolean isUNC(String pathName) {
        return UrlUtil.isUNC(pathName);
    }

    public static String simpleRegExptoRegExp(String simpleRegExp) {
        return StringUtil.simpleRegExptoRegExp(simpleRegExp, false);
    }

    public static String simpleRegExptoRegExp(String simpleRegExp, boolean alwaysSimple) {
        if (StringUtil.isEmpty(simpleRegExp)) {
            return null;
        }
        if (!alwaysSimple && StringUtils.containsAny((String)simpleRegExp, (String)"{([|")) {
            return simpleRegExp;
        }
        simpleRegExp = StringUtil.escape(simpleRegExp, ".\\{}|[]()", "\\", 0, 0, 0, Integer.MAX_VALUE);
        String[] in = new String[]{"*", "+", "?"};
        String[] out = new String[]{"(.*)", "(.+)", "(.)"};
        for (int i = 0; i < in.length; ++i) {
            StringBuilder b = new StringBuilder(simpleRegExp.length() * 2);
            int lastPos = 0;
            while (lastPos >= 0) {
                int posSimpleToken = simpleRegExp.indexOf(in[i], lastPos);
                if (posSimpleToken >= 0) {
                    b.append(simpleRegExp.substring(lastPos, posSimpleToken));
                    b.append(out[i]);
                } else {
                    b.append(simpleRegExp.substring(lastPos));
                }
                lastPos = posSimpleToken >= 0 ? posSimpleToken + 1 : posSimpleToken;
            }
            simpleRegExp = b.toString();
        }
        return simpleRegExp;
    }

    public static boolean matchesSimple(String str, String regExp) {
        return StringUtil.matchesSimple(str, regExp, false);
    }

    public static boolean matchesSimple(String str, String regExp, boolean alwaysSimple) {
        regExp = StringUtil.simpleRegExptoRegExp(regExp, alwaysSimple);
        return StringUtil.matches(str, regExp);
    }

    public static boolean equals(String attribute, String attribute2, double delta) {
        if (StringUtil.isEmpty(attribute)) {
            return StringUtil.isEmpty(attribute2);
        }
        if (StringUtil.equals(attribute.trim(), attribute2.trim())) {
            return true;
        }
        if (delta >= 0.0) {
            boolean isNumber;
            EDataType dt = StringUtil.getDataType(attribute);
            EDataType dt2 = StringUtil.getDataType(attribute2);
            boolean bl = isNumber = EDataType.number.equals((Object)dt) && EDataType.integer.equals((Object)dt2) || EDataType.number.equals((Object)dt2) && EDataType.integer.equals((Object)dt);
            if (!isNumber && !ContainerUtil.equals((Object)dt, (Object)dt2)) {
                return false;
            }
            if (EDataType.integer.equals((Object)dt) && !isNumber) {
                return StringUtil.parseInt(attribute, -1) == StringUtil.parseInt(attribute2, -2);
            }
            if (EDataType.number.equals((Object)dt) || isNumber) {
                double parseDouble = StringUtil.parseDouble(attribute, -1.0);
                double parseDouble2 = StringUtil.parseDouble(attribute2, -2.0);
                return StringUtil.isEqual(parseDouble, parseDouble2, delta);
            }
            if (EDataType.bool.equals((Object)dt)) {
                return StringUtil.parseBoolean(attribute, true) == StringUtil.parseBoolean(attribute2, false);
            }
            if (EDataType.numberlist.equals((Object)dt)) {
                JDFNumberList nl1 = JDFNumberList.createNumberList(attribute);
                JDFNumberList nl2 = JDFNumberList.createNumberList(attribute2);
                return nl1.matches(nl2, delta);
            }
            if (EDataType.date.equals((Object)dt)) {
                JDFDate d1 = JDFDate.createDate(attribute);
                JDFDate d2 = JDFDate.createDate(attribute2);
                return (double)Math.abs(d1.getTimeInMillis() - d2.getTimeInMillis()) < delta;
            }
        }
        return false;
    }

    public static boolean matches(String str, String regExp) {
        boolean b;
        if (regExp == null || regExp.length() == 0 || "*".equals(regExp)) {
            return true;
        }
        if (str == null) {
            return false;
        }
        try {
            b = str.matches(regExp);
        }
        catch (PatternSyntaxException e) {
            b = false;
        }
        return b;
    }

    public static boolean matchesIgnoreCase(String str, String regExp) {
        return StringUtil.matchesIgnoreCase(str, regExp, false);
    }

    public static boolean matchesIgnoreCase(String str, String regExp, boolean alwaysSimple) {
        return StringUtil.matchesSimple(str == null ? null : str.toLowerCase(), regExp == null ? null : regExp.toLowerCase(), alwaysSimple);
    }

    public static void concatStrings(VString vS, String appendString) {
        if (vS != null) {
            for (int i = 0; i < vS.size(); ++i) {
                String s = vS.get(i);
                s = s + appendString;
                vS.setElementAt(s, i);
            }
        }
    }

    public static String concat(String s1, String s2, String delim) {
        if (StringUtil.isEmpty(s1)) {
            return StringUtil.getNonEmpty(s2);
        }
        if (StringUtil.isEmpty(s2)) {
            return s1;
        }
        if (StringUtil.isEmpty(delim)) {
            return s1 + s2;
        }
        return s1 + delim + s2;
    }

    public static String createString(InputStream is) {
        if (is == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        int n = 0;
        byte[] by = new byte[4000];
        do {
            try {
                n = is.read(by);
            }
            catch (IOException e) {
                n = -1;
            }
            if (n <= 0) continue;
            String s = new String(by, 0, n);
            b.append(s);
        } while (n >= 0);
        return b.toString();
    }

    @Deprecated
    public static String getRelativeURL(File f, File baseDir) {
        return UrlUtil.getRelativeURL(f, baseDir, true);
    }

    @Deprecated
    public static String getRelativeURL(File f, File baseDir, boolean bEscape128) {
        return UrlUtil.getRelativeURL(f, baseDir, bEscape128);
    }

    @Deprecated
    public static String getRelativePath(File f, File fCWD) {
        return UrlUtil.getRelativePath(f, fCWD);
    }

    @Deprecated
    public static VString getNamesVector(Class<? extends ValuedEnum> e) {
        return EnumUtil.getNamesVector(e);
    }

    @Deprecated
    public static Vector<ValuedEnum> getEnumsVector(Class<? extends ValuedEnum> e) {
        return EnumUtil.getEnumsVector(e);
    }

    @Deprecated
    public static String fileToUrl(File f, boolean b) {
        return UrlUtil.fileToUrl(f, b);
    }

    public static String stripPrefix(String str, String prefix, boolean bIgnoreCase) {
        if (str != null && prefix != null && (bIgnoreCase && str.toLowerCase().startsWith(prefix.toLowerCase()) || str.startsWith(prefix))) {
            str = StringUtil.rightStr(str, -prefix.length());
        }
        return str;
    }

    public static String stripQuote(String str, String quote, boolean bTrim) {
        if (str == null || quote == null) {
            return str;
        }
        if (bTrim) {
            str = str.trim();
        }
        if (str.length() >= 2 && str.startsWith(quote) && str.endsWith(quote)) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String stripNot(String work, String keepChars) {
        if (work == null || keepChars == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(work.length());
        for (int i = 0; i < work.length(); ++i) {
            if (keepChars.indexOf(work.charAt(i)) < 0) continue;
            b.append(work.charAt(i));
        }
        return b.length() > 0 ? b.toString() : null;
    }

    public static String trim(String work, String trimChars) {
        int i;
        if (work == null) {
            return null;
        }
        if (trimChars == null) {
            return StringUtil.getNonEmpty(work.trim());
        }
        int nStart = 0;
        int nEnd = work.length();
        for (i = 0; i < work.length() && trimChars.indexOf(work.charAt(i)) >= 0; ++i) {
            nStart = i + 1;
        }
        i = work.length() - 1;
        while (i >= nStart && trimChars.indexOf(work.charAt(i)) >= 0) {
            nEnd = i--;
        }
        String trimmed = work.substring(nStart, nEnd);
        return trimmed.length() > 0 ? trimmed : null;
    }

    public static String formatDouble(double value, int precision) {
        return new NumberFormatter().formatDouble(value, precision);
    }

    public static class StringReplacer {
        private String strWork;
        private boolean reRead;

        public void setReRead(boolean reRead) {
            this.reRead = reRead;
        }

        public StringReplacer(String str) {
            this.strWork = str;
            this.reRead = true;
        }

        public String replaceString(String toReplace, String replaceBy) {
            if (StringUtil.getNonEmpty(toReplace) == null || StringUtil.equals(toReplace, replaceBy)) {
                return this.strWork;
            }
            if (replaceBy != null && replaceBy.contains(toReplace)) {
                this.reRead = false;
            }
            if (this.strWork == null) {
                return this.strWork;
            }
            int lenIn = this.strWork.length();
            int indexOf = this.strWork.indexOf(toReplace);
            if (indexOf < 0) {
                return this.strWork;
            }
            int len = toReplace.length();
            StringBuilder b = new StringBuilder(this.strWork.length() * 2);
            do {
                b.append(this.strWork.substring(0, indexOf));
                if (replaceBy != null) {
                    b.append(replaceBy);
                }
                this.strWork = this.strWork.substring(indexOf + len);
            } while ((indexOf = this.strWork.indexOf(toReplace)) >= 0);
            b.append(this.strWork);
            String outString = b.toString();
            int lenOut = outString.length();
            return lenOut == lenIn || !this.reRead ? outString : StringUtil.replaceString(outString, toReplace, replaceBy);
        }
    }

    static enum EDataType {
        string,
        integer,
        number,
        bool,
        numberlist,
        date;

    }
}

