/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoResourceLink;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.IAmountPoolContainer;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFPool;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.PartitionGetter;
import org.cip4.jdflib.resource.process.JDFLot;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFResourceLink
extends JDFAutoResourceLink
implements IAmountPoolContainer {
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[1];
    private static final long serialVersionUID = 1L;

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public static boolean isResourceLink(KElement e) {
        return e instanceof JDFResourceLink && !(e instanceof JDFPartAmount);
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString v = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        if (!v.contains("CombinedProcessIndex") && !this.validCombinedProcessIndex()) {
            v.add("CombinedProcessIndex");
        }
        return v;
    }

    @Override
    public void setUsage(EnumUsage enumVar) {
        this.setAttribute("Usage", enumVar == null ? null : enumVar.getName(), null);
    }

    @Override
    public EnumUsage getUsage() {
        return EnumUsage.getEnum(this.getAttributeRaw("Usage"));
    }

    public void generateCombinedProcessIndex() {
        JDFResource linkRoot;
        VString types;
        JDFNode n = this.getParentJDF();
        if (n != null && (types = n.getTypes()) != null && (linkRoot = this.getLinkRoot()) != null) {
            JDFNode.CombinedProcessIndexHelper.generateCombinedProcessIndex(linkRoot, this.getUsage(), this.getEnumProcessUsage(), this, types);
        }
    }

    public boolean validCombinedProcessIndex() {
        JDFIntegerList vCombined = this.getCombinedProcessIndex();
        if (vCombined == null) {
            return true;
        }
        JDFNode parentJDF = this.getParentJDF();
        if (parentJDF == null) {
            return false;
        }
        VString types = parentJDF.getTypes();
        if (types == null) {
            return false;
        }
        int typSize = types.size();
        int size = vCombined.size();
        for (int i = 0; i < size; ++i) {
            int combinedIndex = vCombined.getInt(i);
            if (combinedIndex >= 0 && combinedIndex < typSize) continue;
            return false;
        }
        return true;
    }

    public JDFResourceLink(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourceLink(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourceLink(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFResourceLink[ --> " + super.toString() + " ]";
    }

    public void unpartition(boolean bRemovePartMapVector, boolean bRemoveAmountPool) {
        if (bRemovePartMapVector) {
            this.setPartMapVector(null);
        }
        JDFAmountPool ap = this.getAmountPool();
        if (bRemoveAmountPool && ap != null) {
            JDFPartAmount pa = ap.getPartAmount(0);
            this.setAttributes(pa);
            ap.deleteNode();
        }
    }

    public boolean setTarget(JDFResource resourceTarget) {
        if (resourceTarget.isResourceElement()) {
            throw new JDFException("attempting to link to a resource subelement");
        }
        this.appendHRef(resourceTarget.getResourceRoot(), "rRef", null);
        if (!resourceTarget.isResourceRoot()) {
            this.removeChildren("Part", null, null);
            JDFAttributeMap mPart = resourceTarget.getPartMap();
            if (mPart != null && mPart.size() > 0) {
                JDFPart part = this.appendPart();
                part.setAttributes(mPart);
            }
        }
        return true;
    }

    public double getAmount(JDFAttributeMap mPart) {
        return JDFAmountPool.AmountPoolHelper.getAmount(this, mPart);
    }

    public double getMinAmount(JDFAttributeMap mPart) {
        return JDFAmountPool.AmountPoolHelper.getMinAmount(this, mPart);
    }

    public double getMaxAmount(JDFAttributeMap mPart) {
        return JDFAmountPool.AmountPoolHelper.getMaxAmount(this, mPart);
    }

    @Override
    public JDFResource getLinkRoot() {
        JDFResource eLink = super.getLinkRoot(null);
        if (eLink != null && !eLink.getNodeName().equals(this.getLinkedResourceName())) {
            return null;
        }
        return eLink;
    }

    @Deprecated
    public JDFResource getLinkTarget() {
        return this.getTarget();
    }

    public void setQuantity(int quant) {
        this.setAttribute("Amount", quant, (String)null);
    }

    public void setAmount(double value, JDFAttributeMap mPart) {
        this.setAmountPoolAttribute("Amount", StringUtil.formatDouble(value), null, mPart);
    }

    public void setMinAmount(double value, JDFAttributeMap mPart) {
        this.setAmountPoolAttribute("MinAmount", StringUtil.formatDouble(value), null, mPart);
    }

    public void setMaxAmount(double value, JDFAttributeMap mPart) {
        this.setAmountPoolAttribute("MaxAmount", StringUtil.formatDouble(value), null, mPart);
    }

    public JDFResource.EnumResStatus getStatusJDF() {
        return JDFResource.EnumResStatus.getEnum(this.getLinkRoot().getResStatus(false).getName());
    }

    public JDFResource.EnumResStatus getStatusFromLeaves() {
        VElement v = this.getTargetVector(0);
        if (ContainerUtil.isEmpty(v)) {
            return JDFResource.EnumResStatus.Incomplete;
        }
        JDFResource.EnumResStatus status = JDFResource.EnumResStatus.Available;
        for (KElement e : v) {
            JDFResource.EnumResStatus s2 = ((JDFResource)e).getStatusFromLeaves(false);
            status = (JDFResource.EnumResStatus)EnumUtil.min(s2, status);
        }
        return status;
    }

    public void setStatus(JDFResource.EnumResStatus s) {
        VElement targets = this.getTargetVector(-1);
        for (int i = 0; i < targets.size(); ++i) {
            ((JDFResource)targets.elementAt(i)).setResStatus(s, true);
        }
    }

    public boolean isLocal() {
        JDFNode linkParent = this.getParentJDF();
        JDFNode resParent = this.getTarget().getParentJDF();
        return resParent.isEqual(linkParent);
    }

    public JDFPart getPart(int i) {
        return (JDFPart)this.getElement("Part", null, i);
    }

    public JDFPart getCreatePart(int i) {
        return (JDFPart)this.getCreateElement_KElement("Part", null, i);
    }

    public String getAuditString() {
        String s = this.getNodeName();
        return s.substring(3, s.length()) + "Audit";
    }

    public VElement getParts() {
        return this.getChildElementVector("Part", null, null, true, 0, false);
    }

    public void setPart(String key, String value) {
        JDFPart part = this.getCreatePart(0);
        part.setAttribute(key, value, null);
    }

    public void setPartition(JDFResource.EnumPartIDKey key, String value) {
        while (this.hasChildElement("Part", null)) {
            this.removePart(0);
        }
        JDFPart part = this.getCreatePart(0);
        part.setAttribute(key.getName(), value, null);
    }

    public void removePart(int iSkip) {
        this.removeChild("Part", null, iSkip);
    }

    public boolean isExecutable(JDFAttributeMap partMap, boolean bCheckChildren) {
        VElement leaves2;
        if (!this.hasResourcePartMap(partMap, false)) {
            return false;
        }
        VElement leaves = new VElement();
        boolean bExec = false;
        if (bCheckChildren) {
            leaves2 = this.getTargetVector(-1);
            for (KElement e : leaves2) {
                if (e == null) continue;
                JDFResource p = (JDFResource)e;
                List<JDFResource> targetVector = p.getLeafArray(false);
                leaves.addAll(targetVector);
            }
        } else {
            leaves2 = this.getTargetVector(-1);
            for (KElement e : leaves2) {
                JDFResource leaf = (JDFResource)e;
                if ((leaf = leaf.getPartition(partMap, null)) == null) continue;
                leaves.add(leaf);
            }
        }
        leaves.unify();
        for (int i = 0; i < leaves.size(); ++i) {
            JDFResource leaf = (JDFResource)leaves.elementAt(i);
            if (partMap != null && !partMap.isEmpty() && !partMap.overlapMap(leaf.getPartMap())) continue;
            JDFResource.EnumResStatus status = leaf.getResStatus(true);
            if (JDFResource.EnumResStatus.InUse.equals((Object)status)) {
                return false;
            }
            boolean bl = bExec = status != null && this.getMinStatus().getValue() <= status.getValue();
            if (bExec) continue;
            return false;
        }
        return true;
    }

    protected JDFResourceLinkPool getResourceLinkPool() {
        if (this.getParentNode_KElement() != null) {
            return (JDFResourceLinkPool)this.getParentNode_KElement();
        }
        return null;
    }

    @Override
    public JDFResource getTarget() {
        VJDFAttributeMap vmParts = this.getPartMapVector();
        JDFResource linkRoot = this.getLinkRoot();
        if (VJDFAttributeMap.isEmpty(vmParts)) {
            return linkRoot;
        }
        if (linkRoot != null && vmParts.size() == 1) {
            PartitionGetter partitionGetter = new PartitionGetter(linkRoot);
            partitionGetter.setFollowIdentical(true);
            JDFResource partition = partitionGetter.getPartition(vmParts.get(0), linkRoot.getPartUsage());
            if (partition != null) {
                return partition;
            }
        }
        VElement v = this.getMapTargetVector(vmParts, -1, true);
        JDFResource commonAncestor = (JDFResource)v.getCommonAncestor();
        return commonAncestor;
    }

    public VElement getTargetVector(int nMax) {
        VJDFAttributeMap vmParts = this.getPartMapVector();
        return this.getMapTargetVector(vmParts, nMax, true);
    }

    public VElement getRawTargetVector(int nMax) {
        VJDFAttributeMap vmParts = this.getPartMapVector();
        return this.getMapTargetVector(vmParts, nMax, false);
    }

    private VElement getMapTargetVector(VJDFAttributeMap vmParts, int nMax, boolean followIdentical) {
        VElement v = new VElement();
        JDFResource resRoot = this.getLinkRoot();
        if (resRoot == null) {
            return v;
        }
        if (VJDFAttributeMap.isEmpty(vmParts)) {
            v.addElement(resRoot);
            return v;
        }
        JDFResource.EnumPartUsage partUsage = resRoot.getPartUsage();
        if (JDFResource.EnumPartUsage.Implicit.equals((Object)partUsage)) {
            vmParts.reduceMap(resRoot.getPartIDKeys().getSet());
        }
        if (VJDFAttributeMap.isEmpty(vmParts)) {
            v.addElement(resRoot);
            return v;
        }
        PartitionGetter partitionGetter = new PartitionGetter(resRoot);
        partitionGetter.setFollowIdentical(followIdentical);
        return partitionGetter.getPartitionVector(vmParts, partUsage);
    }

    public JDFPool getPool() {
        KElement deepParentNotName = this.getDeepParentNotName(this.getLocalName());
        if (deepParentNotName != null) {
            return (JDFPool)deepParentNotName;
        }
        return null;
    }

    public boolean hasResourcePartMap(JDFAttributeMap partMap, boolean bCheckResource) {
        block11: {
            int siz;
            VJDFAttributeMap vPart;
            block12: {
                boolean bImplicit;
                block10: {
                    KElement childByTagName;
                    JDFResource linkRoot = this.getLinkRoot();
                    if (linkRoot == null) {
                        return false;
                    }
                    JDFResource.EnumPartUsage partUsage = linkRoot.getPartUsage();
                    bImplicit = JDFResource.EnumPartUsage.Implicit.equals((Object)partUsage);
                    if (!bCheckResource) break block10;
                    if (partMap == null || partMap.isEmpty()) {
                        return true;
                    }
                    JDFResource partition = linkRoot.getPartition(partMap, partUsage);
                    if (partition != null && partition != linkRoot) {
                        return true;
                    }
                    if (bImplicit && (childByTagName = linkRoot.getElement(linkRoot.getNodeName())) == null) {
                        return true;
                    }
                    break block11;
                }
                vPart = this.getPartMapVector();
                if ((partMap == null || partMap.isEmpty()) && (vPart == null || vPart.isEmpty())) {
                    return true;
                }
                int n = siz = vPart == null ? 0 : vPart.size();
                if (!bImplicit) break block12;
                if (siz == 0 || vPart == null) {
                    return true;
                }
                for (int i = 0; i < siz; ++i) {
                    if (!vPart.elementAt(i).overlapMap(partMap)) continue;
                    return true;
                }
                break block11;
            }
            if (siz == 0 && !bCheckResource) {
                return true;
            }
            if (vPart == null) break block11;
            for (int i = 0; i < siz; ++i) {
                JDFAttributeMap part = vPart.elementAt(i);
                if (part == null || part.size() == 0) {
                    return true;
                }
                if (!part.subMap(partMap)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean overlapsResourcePartMap(JDFAttributeMap partMap) {
        int siz;
        if (partMap.isEmpty()) {
            return true;
        }
        VJDFAttributeMap vPart = this.getPartMapVector();
        int n = siz = vPart == null ? 0 : vPart.size();
        if (siz == 0) {
            return true;
        }
        if (vPart != null) {
            for (int i = 0; i < siz; ++i) {
                if (!vPart.elementAt(i).overlapMap(partMap)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isResourceSelected(JDFResource resourceToCheck) {
        boolean b_ResurceIsSelected = false;
        VElement resourceLeavesFromResource = resourceToCheck.getLeaves(false);
        VElement resourceLeavesFromLink = this.getTargetVector(-1);
        int i_NoResourceLeavesFromResource = resourceLeavesFromResource.size();
        int i_NoResourceLeavesFromLink = resourceLeavesFromLink.size();
        int i_CurrentLeafFromLink = 0;
        boolean b_SelectionIsPossible = true;
        for (int i_CurrentLeafFromResource = 0; b_SelectionIsPossible && i_CurrentLeafFromResource < i_NoResourceLeavesFromResource; ++i_CurrentLeafFromResource) {
            JDFResource currentLeafFromResource = (JDFResource)resourceLeavesFromResource.elementAt(i_CurrentLeafFromResource);
            boolean b_ResourceFoundInLink = false;
            while (!b_ResourceFoundInLink && i_CurrentLeafFromLink < i_NoResourceLeavesFromLink) {
                JDFResource currentLeafFromLink = (JDFResource)resourceLeavesFromLink.elementAt(i_CurrentLeafFromLink);
                b_ResourceFoundInLink = currentLeafFromResource == currentLeafFromLink;
                ++i_CurrentLeafFromLink;
            }
            b_SelectionIsPossible = b_ResourceFoundInLink;
        }
        b_ResurceIsSelected = b_SelectionIsPossible;
        return b_ResurceIsSelected;
    }

    public VJDFAttributeMap getResourcePartMapVector() {
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        VJDFAttributeMap vPartMap = this.getPartMapVector();
        int nPartChildren = vPartMap == null ? 0 : vPartMap.size();
        JDFResource root = this.getLinkRoot();
        List<JDFResource> leaves = root.getLeafArray(false);
        for (JDFResource r : leaves) {
            JDFAttributeMap leafMap = r.getPartMap();
            if (nPartChildren > 0 && vPartMap != null) {
                for (int j = 0; j < nPartChildren; ++j) {
                    JDFAttributeMap mPart = vPartMap.elementAt(j);
                    if (!mPart.overlapMap(leafMap)) continue;
                    vMap.addElement(leafMap.orMap(mPart));
                }
                continue;
            }
            vMap.addElement(leafMap);
        }
        return vMap.size() == 0 ? null : vMap;
    }

    public VElement getLeafVector() {
        VJDFAttributeMap vmParts = this.getPartMapVector();
        JDFResource resRoot = this.getLinkRoot();
        if (resRoot == null) {
            return null;
        }
        VElement v = new VElement();
        if (vmParts == null) {
            return resRoot.getLeaves(false);
        }
        JDFResource.EnumPartUsage partUsage = resRoot.getPartUsage();
        for (int i = 0; i < vmParts.size(); ++i) {
            VElement vr = resRoot.getPartitionVector(vmParts.elementAt(i), partUsage);
            for (KElement e : vr) {
                JDFResource targ = (JDFResource)e;
                VElement leaves = targ.getLeaves(false);
                for (int k = 0; k < leaves.size(); ++k) {
                    JDFResource leaf = (JDFResource)leaves.get(k);
                    while (!leaf.getPartMap().overlapMap(vmParts.elementAt(i)) && !leaf.isResourceRoot()) {
                        leaf = (JDFResource)leaf.getParentNode();
                    }
                    v.add(leaf);
                }
            }
        }
        v.unify();
        return v.isEmpty() ? null : v;
    }

    public String getLinkedResourceName() {
        String nodeName = this.getNodeName();
        return StringUtil.leftStr(nodeName, -4);
    }

    public String getNamedProcessUsage() {
        String s = this.getProcessUsage();
        if (JDFResourceLink.isWildCard(s)) {
            s = this.getAttribute("Usage", null, "");
        }
        s = this.getLinkedResourceName() + ":" + s;
        return s;
    }

    public boolean validResourcePosition() {
        return this.validResourcePosition(this.getLinkRoot());
    }

    @Override
    public boolean isValid(JDFElement.EnumValidationLevel level) {
        boolean b;
        JDFElement.EnumValidationLevel levelLocal = level;
        if (levelLocal == null) {
            levelLocal = JDFElement.EnumValidationLevel.Complete;
        }
        if (!(b = super.isValid(levelLocal))) {
            return false;
        }
        if (this instanceof JDFPartAmount) {
            return true;
        }
        if (levelLocal != JDFElement.EnumValidationLevel.Complete && levelLocal != JDFElement.EnumValidationLevel.Incomplete && levelLocal != JDFElement.EnumValidationLevel.RecursiveIncomplete) {
            return true;
        }
        if (!this.validResourcePosition()) {
            return false;
        }
        VElement vRes = this.getTargetVector(0);
        if (!(vRes != null && !vRes.isEmpty() || levelLocal != JDFElement.EnumValidationLevel.Complete && levelLocal != JDFElement.EnumValidationLevel.RecursiveComplete)) {
            return false;
        }
        if (levelLocal.equals((Object)JDFElement.EnumValidationLevel.Complete)) {
            return true;
        }
        for (KElement e : vRes) {
            JDFElement.EnumValidationLevel valDown;
            JDFResource r = (JDFResource)e;
            if (!this.getNodeName().equals(r.getLinkString())) {
                return false;
            }
            if (levelLocal.getValue() < JDFElement.EnumValidationLevel.RecursiveIncomplete.getValue() || r.isValid(valDown = levelLocal == JDFElement.EnumValidationLevel.RecursiveIncomplete ? JDFElement.EnumValidationLevel.Incomplete : JDFElement.EnumValidationLevel.Complete)) continue;
            return false;
        }
        return true;
    }

    public boolean isPhysical() {
        boolean fIsPhysical = false;
        JDFResource resource = this.getLinkRoot();
        if (resource != null) {
            fIsPhysical = resource.isPhysical();
        }
        return fIsPhysical;
    }

    public boolean isImplementation() {
        boolean fIsImplementation = false;
        JDFResource linkRoot = this.getLinkRoot();
        if (linkRoot != null && linkRoot.getResourceClass() == JDFResource.EnumResourceClass.Implementation) {
            fIsImplementation = true;
        }
        return fIsImplementation;
    }

    public JDFPart appendPart() {
        return (JDFPart)this.appendElement("Part", null);
    }

    @Override
    public JDFAmountPool getCreateAmountPool() {
        if (this instanceof JDFPartAmount) {
            throw new JDFException("JDFResourceLink.getCreateAmountPool: calling method on PartAmount object");
        }
        return (JDFAmountPool)this.getCreateElement_KElement("AmountPool", null, 0);
    }

    @Override
    public JDFAmountPool appendAmountPool() {
        if (this instanceof JDFPartAmount) {
            throw new JDFException("JDFResourceLink.appendAmountPool: calling method on PartAmount object");
        }
        return (JDFAmountPool)this.appendElementN("AmountPool", 1, null);
    }

    @Override
    public JDFLot getLot(int n) {
        return (JDFLot)this.getElement("Lot", null, n);
    }

    public void reduceParts() {
        VJDFAttributeMap vParts = this.getPartMapVector();
        if (vParts.isEmpty()) {
            return;
        }
        VJDFAttributeMap vReducedParts = this.getLinkRoot().reducePartVector(vParts);
        if (vParts != vReducedParts) {
            this.setPartMapVector(vReducedParts);
        }
    }

    public void expandTarget(boolean bForce) {
        VJDFAttributeMap apParts;
        JDFResource r = this.getLinkRoot();
        if (r == null) {
            return;
        }
        if ((r.getPartUsage() == JDFResource.EnumPartUsage.Explicit || bForce) && (apParts = this.getPartMapVector()) != null) {
            for (int i = 0; i < apParts.size(); ++i) {
                VElement vExist = r.getPartitionVector(apParts.elementAt(i), null);
                if (!vExist.isEmpty()) continue;
                r.getCreatePartition(apParts.elementAt(i), null);
            }
        }
    }

    public void expandAmountPool() {
        VJDFAttributeMap apParts = this.getResourcePartMapVector();
        if (apParts == null) {
            return;
        }
        VString attribs = new VString();
        attribs.add("Amount");
        attribs.add("ActualAmount");
        for (int j = 0; j < attribs.size(); ++j) {
            String attribName = attribs.get(j);
            if (!this.hasAttribute(attribName)) continue;
            String att = this.getAttribute(attribName, null, null);
            for (int i = 0; i < apParts.size(); ++i) {
                this.setAmountPoolAttribute(attribName, att, null, apParts.elementAt(i));
            }
        }
    }

    public double getMinAmountPoolAttribute(String attrib, String nameSpaceURI, JDFAttributeMap mPart, int def) {
        JDFAmountPool ap = this.getAmountPool();
        if (ap == null) {
            return def;
        }
        VElement vPartAmount = ap.getMatchingPartAmountVector(mPart);
        boolean bMatch = false;
        double d = Double.MAX_VALUE;
        int size = vPartAmount.size();
        for (int i = 0; i < size; ++i) {
            JDFPartAmount pa = (JDFPartAmount)vPartAmount.elementAt(i);
            double realAttribute = pa.getRealAttribute(attrib, nameSpaceURI, def);
            if (realAttribute == (double)def || !(realAttribute < d)) continue;
            bMatch = true;
            d = realAttribute;
        }
        return bMatch ? d : (double)def;
    }

    public JDFAmountPool.AmountMap getAmountMap(VString vPartIDKeys) {
        return JDFAmountPool.AmountPoolHelper.getAmountMap(this, vPartIDKeys);
    }

    public String getAmountPoolAttribute(String attrib, String nameSpaceURI, JDFAttributeMap mPart, int iSkip) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolAttribute(this, attrib, nameSpaceURI, mPart, iSkip);
    }

    public String getAmountPoolAttribute(String attrib, String nameSpaceURI, VJDFAttributeMap vPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolAttribute(this, attrib, nameSpaceURI, vPart);
    }

    @Deprecated
    public boolean hasAmountPoolAttribute(String attrib, String nameSpaceURI, JDFAttributeMap mPart) {
        return this.getAmountPoolAttribute(attrib, nameSpaceURI, mPart, 0) != null;
    }

    public void setAmountPoolAttribute(String attrib, String value, String nameSpaceURI, VJDFAttributeMap vPart) {
        JDFAmountPool.AmountPoolHelper.setAmountPoolAttribute((IAmountPoolContainer)this, attrib, value, nameSpaceURI, vPart);
    }

    public void setAmountPoolAttribute(String attrib, String value, String nameSpaceURI, JDFAttributeMap mPart) {
        JDFAmountPool.AmountPoolHelper.setAmountPoolAttribute((IAmountPoolContainer)this, attrib, value, nameSpaceURI, mPart);
    }

    public double getAmountPoolSumDouble(String attName, VJDFAttributeMap vPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolSumDouble(this, attName, vPart);
    }

    public double getAmountPoolDouble(String attName, VJDFAttributeMap vPart) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolDouble((IAmountPoolContainer)this, attName, vPart);
    }

    public double getAmountPoolDouble(String attName, JDFAttributeMap mPart) {
        JDFResource r = this.getTarget();
        double d = 0.0;
        JDFAmountPool amountPool = this.getAmountPool();
        if (amountPool == null && this.hasAttribute(attName)) {
            return this.getRealAttribute(attName, null, 0.0);
        }
        if (r == null || JDFResource.EnumPartUsage.Implicit.equals((Object)r.getPartUsage()) || this instanceof JDFPartAmount) {
            d = JDFAmountPool.AmountPoolHelper.getAmountPoolDouble((IAmountPoolContainer)this, attName, mPart);
        } else if (amountPool != null) {
            List<JDFResource> vResLeaves = r.getLeafArray(false);
            HashSet<JDFPartAmount> hsDone = new HashSet<JDFPartAmount>();
            for (KElement kElement : vResLeaves) {
                JDFAttributeMap m2;
                JDFResource resLeaf = (JDFResource)kElement;
                JDFAttributeMap m = resLeaf.getPartMap();
                if (m != null && !m.overlapMap(mPart)) continue;
                JDFAttributeMap jDFAttributeMap = m2 = m == null ? mPart : m.getOrMap(mPart);
                JDFPartAmount pa = amountPool.getPartAmount(mPart);
                if (hsDone.contains(pa)) continue;
                double delta = JDFAmountPool.AmountPoolHelper.getAmountPoolMinDouble(this, attName, m2);
                if (m2.get("Condition") == null) {
                    JDFAttributeMap m2Good = m2.clone();
                    m2Good.put("Condition", "Good");
                    double deltaGood = JDFAmountPool.AmountPoolHelper.getAmountPoolMinDouble(this, attName, m2Good);
                    delta = Math.max(delta, deltaGood);
                }
                if (delta > 0.0) {
                    d += delta;
                }
                hsDone.add(pa);
            }
            if (d == 0.0) {
                d = JDFAmountPool.AmountPoolHelper.getAmountPoolDouble((IAmountPoolContainer)this, attName, mPart);
            }
        }
        return d;
    }

    public void setActualAmount(double value, JDFAttributeMap mPart) {
        this.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(value), null, mPart);
    }

    public double getActualAmount(JDFAttributeMap mPart) {
        double amountPoolDouble = this.getAmountPoolDouble("ActualAmount", mPart);
        return amountPoolDouble == -1.0 ? 0.0 : amountPoolDouble;
    }

    public JDFNode.EnumProcessUsage getEnumProcessUsage() {
        return JDFNode.EnumProcessUsage.getEnum(this.getAttribute("ProcessUsage", null, null));
    }

    public void setProcessUsage(JDFNode.EnumProcessUsage processUsage) {
        this.setAttribute("ProcessUsage", processUsage == null ? null : processUsage.getName(), null);
    }

    @Override
    public JDFResource.EnumResStatus getMinStatus() {
        JDFResource.EnumResStatus returnEnum = this.hasAttribute("MinStatus") ? JDFResource.EnumResStatus.getEnum(this.getAttribute("MinStatus")) : (this.getUsage() == EnumUsage.Output ? JDFResource.EnumResStatus.Unavailable : (this.getBoolAttribute("DraftOK", null, false) ? JDFResource.EnumResStatus.Draft : JDFResource.EnumResStatus.Available));
        return returnEnum;
    }

    @Override
    public JDFResource.EnumResStatus getMinLateStatus() {
        if (!this.hasAttribute("MinLateStatus")) {
            return this.getMinStatus();
        }
        return JDFResource.EnumResStatus.getEnum(this.getAttribute("MinLateStatus", null, null));
    }

    @Deprecated
    public void setPipePartIDKeys(VString keys) {
        Vector<JDFResource.EnumPartIDKey> vEnum = new Vector<JDFResource.EnumPartIDKey>();
        for (int i = 0; i < keys.size(); ++i) {
            vEnum.add(JDFResource.EnumPartIDKey.getEnum(keys.elementAt(i)));
        }
        this.setPipePartIDKeys(vEnum);
    }

    public Vector<JDFResource.EnumPartIDKey> getPipePartIDKeysEnum() {
        Vector<JDFResource.EnumPartIDKey> v = null;
        JDFResource res = this.getTarget();
        VString vPartIDKeys = res.getPartIDKeys();
        v = this.hasAttribute("PipePartIDKeys") ? this.getEnumerationsAttribute("PipePartIDKeys", null, JDFResource.EnumPartIDKey.getEnum(0), false) : res.getPipePartIDKeysEnum();
        for (int i = 0; i < v.size(); ++i) {
            if (vPartIDKeys.contains(v.elementAt(i).getName())) continue;
            throw new JDFException("JDFResourceLink.getPipePartIDKeys: key " + (Object)((Object)v.elementAt(i)) + " is not subset of PartIDKey");
        }
        return v;
    }

    @Override
    public void setCombinedProcessIndex(JDFIntegerList value) {
        if (value != null && value.size() == 0) {
            value = null;
        }
        this.setAttribute("CombinedProcessIndex", (JDFNumList)value, (String)null);
    }

    public void setCombinedProcessIndex(int value) {
        this.setAttribute("CombinedProcessIndex", (JDFNumList)new JDFIntegerList(value), (String)null);
    }

    public VString getCombinedProcessTypes() {
        VString vs = null;
        JDFNode parentJDF = this.getParentJDF();
        VString vTypes = parentJDF == null ? null : parentJDF.getTypes();
        JDFIntegerList il = this.getCombinedProcessIndex();
        if (il == null && !this.hasAttribute("CombinedProcessType")) {
            vs = vTypes;
        } else if (il != null && vTypes != null) {
            int[] intArray = il.getIntArray();
            int size = vTypes.size();
            vs = new VString();
            for (int index : intArray) {
                if (index >= size) continue;
                vs.add(vTypes.get(index));
            }
        } else if (this.hasAttribute("CombinedProcessType")) {
            vs = new VString();
            vs.add(this.getCombinedProcessType());
        }
        if (vs != null) {
            vs.unify();
            if (vs.size() == 0) {
                vs = null;
            }
        }
        return vs;
    }

    @Override
    public void setDraftOK(boolean value) {
        JDFElement.EnumVersion eVer = this.getVersion(true);
        if (eVer.getValue() < JDFElement.EnumVersion.Version_1_3.getValue()) {
            this.setAttribute("DraftOK", value, null);
        } else if (value) {
            this.setMinStatus(JDFResource.EnumResStatus.Draft);
        } else {
            this.setMinStatus(EnumUsage.Output.equals((Object)this.getUsage()) ? JDFResource.EnumResStatus.Unavailable : JDFResource.EnumResStatus.Available);
        }
    }

    @Override
    public boolean getDraftOK() {
        if (this.hasAttribute("DraftOK")) {
            return this.getBoolAttribute("DraftOK", null, false);
        }
        if (!this.hasAttribute("MinStatus")) {
            return false;
        }
        return this.getMinStatus().getValue() <= JDFResource.EnumResStatus.Draft.getValue();
    }

    @Override
    public String getPipeProtocol() {
        String str = "";
        if (!this.hasAttribute("PipeProtocol")) {
            JDFResource res = this.getTarget();
            if (res != null) {
                str = res.getPipeProtocol();
            }
        } else {
            str = this.getAttribute("PipeProtocol");
        }
        return str;
    }

    @Override
    public String getPipeURL() {
        String str = "";
        if (!this.hasAttribute("PipeURL")) {
            JDFResource res = this.getTarget();
            if (res != null) {
                str = res.getPipeURL();
            }
        } else {
            str = this.getAttribute("PipeURL");
        }
        return str;
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public JDFAttributeMapArray getPartMapArray() {
        return super.getPartMapArray();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public boolean matchesString(String namedResLink) {
        VElement v;
        if (namedResLink == null) {
            return false;
        }
        boolean bMatch = namedResLink.equals(this.getNamedProcessUsage());
        bMatch = bMatch || namedResLink.equals(this.getLinkedResourceName());
        bMatch = bMatch || namedResLink.equals(this.getLocalName());
        bMatch = bMatch || namedResLink.equals(this.getNodeName());
        bMatch = bMatch || namedResLink.equals(this.getrRef());
        bMatch = bMatch || namedResLink.equals(this.getAttribute("Usage"));
        boolean bl = bMatch = bMatch || namedResLink.equals(this.getLinkedResourceName() + ":" + this.getAttribute("Usage"));
        if (!bMatch && StringUtil.token(namedResLink, 0, ":").equals(this.getLinkedResourceName()) && (v = this.getTargetVector(0)) != null) {
            int siz = v.size();
            for (int i = 0; i < siz; ++i) {
                if (!((JDFResource)v.elementAt(i)).matchesString(namedResLink)) continue;
                return true;
            }
        }
        return bMatch;
    }

    static {
        JDFResourceLink.elemInfoTable[0] = new ElemInfoTable("Part", 0x33333333L);
    }

    public static class EnumUsage
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumUsage Input = new EnumUsage("Input");
        public static final EnumUsage Output = new EnumUsage("Output");

        protected EnumUsage(String name) {
            super(name, m_startValue++);
        }

        public static EnumUsage getEnum(String enumName) {
            return (EnumUsage)EnumUsage.getEnum(EnumUsage.class, (String)enumName);
        }

        public static EnumUsage getEnum(int enumValue) {
            return (EnumUsage)EnumUsage.getEnum(EnumUsage.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumUsage.getEnumMap(EnumUsage.class);
        }

        public static List getEnumList() {
            return EnumUsage.getEnumList(EnumUsage.class);
        }

        public static Iterator iterator() {
            return EnumUsage.iterator(EnumUsage.class);
        }

        public EnumUsage invert() {
            return Output.equals((Object)this) ? Input : Output;
        }

        public boolean isInput() {
            return Input.equals((Object)this);
        }
    }
}

