/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.List;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkAudit;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.util.StringUtil;

public class WalkResourceAudit
extends WalkAudit {
    @Override
    public KElement walk(KElement xjdf, KElement jdf) {
        this.moveFromSender(xjdf, xjdf.getElement("Header"));
        JDFResourceInfo ri = (JDFResourceInfo)xjdf.getElement("ResourceInfo");
        KElement ret = super.walk(xjdf, jdf);
        this.linkSet(ri, ret);
        return null;
    }

    private void linkSet(JDFResourceInfo ri, KElement resAudit) {
        String id;
        ResourceHelper ph;
        if (ri == null) {
            return;
        }
        XJDFHelper h = this.xjdfToJDFImpl.xjdf;
        KElement resSet = ri.getElement("ResourceSet");
        SetHelper sha = resSet == null ? null : new SetHelper(resSet);
        SetHelper sh = sha == null ? null : h.getSet(sha.getName(), sha.getUsage(), sha.getProcessUsage());
        ResourceHelper resourceHelper = ph = sh == null ? null : sh.getPartition(ri.getPartMapVector());
        if (ph == null) {
            ph = sh == null ? null : sh.getPartition(0);
        }
        String string = id = ph == null ? null : this.xjdfToJDFImpl.idMap.get(ph.getID()).getID();
        if (id != null) {
            JDFResourceLink link = (JDFResourceLink)resAudit.appendElement(sh.getName() + "Link", null);
            link.setAttribute("rRef", id);
            link.setUsage(sha.getUsage());
            VJDFAttributeMap partMapVector = sha.getPartMapVector();
            partMapVector.removeKey("ProductPart");
            if (partMapVector != null) {
                for (JDFAttributeMap partMap : partMapVector) {
                    String sheetName = partMap.get("SheetName");
                    String signatureName = partMap.get("SignatureName");
                    if (StringUtil.getNonEmpty(sheetName) == null || StringUtil.getNonEmpty(signatureName) != null) continue;
                    signatureName = "Sig_" + sheetName;
                    partMap.put("SignatureName", signatureName);
                }
            }
            partMapVector.unify();
            link.setPartMapVector(partMapVector);
            JDFAmountPool ap = link.appendAmountPool();
            List<JDFAmountPool> aps = sha.getRoot().getChildArrayByClass(JDFAmountPool.class, true, 0);
            for (JDFAmountPool ap1 : aps) {
                VElement partAmounts = ap1.getChildElementVector("PartAmount", null);
                for (KElement pa : partAmounts) {
                    this.xjdfToJDFImpl.walkTree(pa, ap);
                }
            }
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return "AuditResource".equals(toCheck.getLocalName());
    }

    @Override
    String getJDFName(KElement e) {
        return "ResourceAudit";
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("AuditResource", null);
    }
}

