/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPerson;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.resource.process.JDFAddress;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFPerson
extends JDFAutoPerson
implements IMatches {
    private static final long serialVersionUID = 1L;

    public JDFPerson(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPerson(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPerson(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPerson[  --> " + super.toString() + " ]";
    }

    @Override
    public void setFamilyName(String familyName) {
        String oldName = this.getAttribute("FamilyName", null, null);
        super.setFamilyName(familyName);
        if (familyName == null) {
            return;
        }
        String descName = this.getDescriptiveName();
        if (descName == null || descName.equals("")) {
            this.setDescriptiveName(familyName);
        } else if (descName.equals(this.getFirstName())) {
            this.setDescriptiveName(this.getFirstName() + " " + familyName);
        } else if (oldName != null && descName.endsWith(oldName)) {
            descName = StringUtil.replaceString(descName, oldName, familyName);
            this.setDescriptiveName(descName);
        }
    }

    @Override
    public void setFirstName(String firstName) {
        String oldName = this.getAttribute("FirstName", null, null);
        super.setFirstName(firstName);
        if (firstName == null) {
            return;
        }
        String descName = this.getDescriptiveName();
        if (descName == null || descName.equals("")) {
            this.setDescriptiveName(firstName);
        } else if (descName.equals(this.getFamilyName())) {
            this.setDescriptiveName(firstName + " " + this.getFamilyName());
        } else if (oldName != null && descName.startsWith(oldName)) {
            descName = StringUtil.replaceString(descName, oldName, firstName);
            this.setDescriptiveName(descName);
        }
    }

    @Override
    public String getDescriptiveName() {
        String s = StringUtil.getNonEmpty(super.getDescriptiveName());
        if (s == null) {
            VString vs = new VString();
            s = StringUtil.getNonEmpty(this.getNamePrefix());
            if (s != null) {
                vs.add(s);
            }
            if ((s = StringUtil.getNonEmpty(this.getFirstName())) != null) {
                vs.add(s);
            }
            if ((s = StringUtil.getNonEmpty(this.getFamilyName())) != null) {
                vs.add(s);
            }
            if ((s = StringUtil.getNonEmpty(this.getNameSuffix())) != null) {
                vs.add(s);
            }
            s = StringUtil.setvString(vs, " ", null, null);
        }
        return s;
    }

    @Override
    public boolean matches(Object subset) {
        boolean matches = false;
        if (subset instanceof String) {
            matches = StringUtil.getDistance(this.getDescriptiveName(), (String)subset, true, true, true) <= 2;
        } else if (subset instanceof JDFPerson) {
            JDFPerson other = (JDFPerson)subset;
            if (StringUtil.getDistance(this.getFamilyName(), other.getFamilyName(), true, true, false) > 0) {
                return false;
            }
            if (StringUtil.getDistance(this.getFirstName(), other.getFirstName(), true, true, true) > 1) {
                return false;
            }
            if (StringUtil.getDistance(this.getAdditionalNames(), other.getAdditionalNames(), true, true, true) > 1) {
                return false;
            }
            if (StringUtil.getDistance(this.getNameSuffix(), other.getNameSuffix(), true, true, true) > 1) {
                return false;
            }
            if (StringUtil.getDistance(this.getNamePrefix(), other.getNamePrefix(), true, true, true) > 1) {
                return false;
            }
            matches = ContainerUtil.matchesExisting(this.getAddress(), other.getAddress());
        }
        return matches;
    }

    @Deprecated
    public JDFAddress getAddress(int i) {
        return super.getAddress();
    }

    @Deprecated
    public JDFAddress getCreateAddress(int i) {
        return super.getCreateAddress();
    }
}

