/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process.prepress;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAssetListCreationParams;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.process.JDFFileSpec;

public class JDFAssetListCreationParams
extends JDFAutoAssetListCreationParams {
    private static final String SEARCH_PATH = "SearchPath";
    private static final long serialVersionUID = 1L;

    public JDFAssetListCreationParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAssetListCreationParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAssetListCreationParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFAssetListCreationParams[  --> " + super.toString() + " ]";
    }

    public JDFFileSpec getSearchPath(int iSkip) {
        int iSkipLocal = iSkip;
        JDFFileSpec res = null;
        VElement v = this.getChildElementVector("FileSpec", null, null, true, 0, false);
        int siz = v.size();
        for (int i = 0; i < siz; ++i) {
            res = (JDFFileSpec)v.elementAt(i);
            if (!res.hasAttribute("ResourceUsage") || !SEARCH_PATH.equals(res.getResourceUsage())) continue;
            if (iSkipLocal < 0) break;
            --iSkipLocal;
        }
        return res;
    }

    public JDFFileSpec getCreateSearchPath(int iSkip) {
        JDFFileSpec res = this.getSearchPath(iSkip);
        if (res == null) {
            res = this.appendSearchPath();
        }
        return res;
    }

    public JDFFileSpec appendSearchPath() {
        JDFFileSpec res = this.appendFileSpec();
        res.setResourceUsage(SEARCH_PATH);
        return res;
    }

    @Override
    public VString getInvalidElements(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString vElem = new VString();
        int n = 0;
        int nElem = this.numChildElements("FileSpec", null);
        for (int i = 0; i < nElem; ++i) {
            String ru = this.getFileSpec(i).getResourceUsage();
            if (ru.equals(SEARCH_PATH)) continue;
            vElem.appendUnique("FileSpec");
            if (++n < nMax) break;
            return vElem;
        }
        vElem.appendUnique(this.getInvalidElements(level, bIgnorePrivate, nMax - n));
        return vElem;
    }
}

