/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PrefixInputStream
extends FilterInputStream {
    private final InputStream streamPre;
    private boolean bDone = false;

    public PrefixInputStream(InputStream stream1, InputStream stream2) {
        super(stream2);
        this.streamPre = stream1;
    }

    public PrefixInputStream(String prefix, InputStream stream2) {
        super(stream2);
        this.streamPre = new ByteArrayInputStream(prefix.getBytes());
    }

    @Override
    public int read() throws IOException {
        if (!this.bDone) {
            int read = this.streamPre.read();
            if (read != -1) {
                return read;
            }
            this.bDone = true;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.bDone) {
            int read = this.streamPre.read(b, off, len);
            if (read != -1) {
                return read;
            }
            this.bDone = true;
        }
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.bDone) {
            int read = this.streamPre.read(b);
            if (read != -1) {
                return read;
            }
            this.bDone = true;
        }
        return super.read(b);
    }
}

