/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFDurationRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;

public class JDFDurationRangeList
extends JDFRangeList {
    public JDFDurationRangeList() {
    }

    public static JDFDurationRangeList createDurationRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFDurationRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFDurationRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public JDFDurationRangeList(JDFDurationRangeList rl) {
        this.rangeList = new ArrayList(rl.rangeList);
    }

    public boolean inRange(JDFDuration x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFDurationRange r = (JDFDurationRange)this.rangeList.get(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFDurationRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        StringArray vs = StringArray.getVString(zappedWS, " \t");
        this.rangeList.clear();
        for (String str : vs) {
            try {
                JDFDurationRange dr = new JDFDurationRange(str);
                this.rangeList.add(dr);
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFDurationRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFDurationRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFDurationRange r) {
        this.rangeList.add(r);
    }

    public void append(JDFDuration xMin, JDFDuration xMax) {
        this.append(new JDFDurationRange(xMin, xMax));
    }

    public void append(JDFDuration x) {
        this.append(new JDFDurationRange(x, x));
    }

    @Override
    public boolean isOrdered() {
        int n;
        ArrayList<JDFDuration> v = this.getOrderedArray();
        int n2 = n = v == null ? 0 : v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDuration first = v.get(0);
        JDFDuration last = v.get(n);
        for (int j = 0; j < n; ++j) {
            JDFDuration value = v.get(j);
            JDFDuration nextvalue = v.get(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isShorter(last) && (value.isShorter(nextvalue) || value.equals(nextvalue)) || first.isLonger(last) && (value.isLonger(nextvalue) || value.equals(nextvalue))) continue;
            return false;
        }
        return true;
    }

    protected ArrayList<JDFDuration> getOrderedArray() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return null;
        }
        ArrayList<JDFDuration> v = new ArrayList<JDFDuration>();
        for (int i = 0; i < siz; ++i) {
            JDFDurationRange r = (JDFDurationRange)this.rangeList.get(i);
            v.add(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.add(r.getRight());
        }
        return v;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFDuration last;
        int n;
        ArrayList<JDFDuration> v = this.getOrderedArray();
        int n2 = n = v == null ? 0 : v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDuration first = v.get(0);
        if (first.equals(last = v.get(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFDuration value = v.get(j);
            JDFDuration nextvalue = v.get(j + 1);
            if (first.isShorter(last) && value.isShorter(nextvalue) || first.isLonger(last) && value.isLonger(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

