/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.fixversion.WalkPool;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.util.EnumUtil;

public class WalkJMF
extends WalkPool {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFJMF;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("JMF", null);
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFJMF jmf = (JDFJMF)e1;
        if (this.fixVersion.version != null) {
            if (EnumUtil.aLessThanB(this.fixVersion.version, JDFElement.EnumVersion.Version_2_0)) {
                jmf.setVersion(this.fixVersion.version);
                jmf.setMaxVersion(this.fixVersion.version);
            }
            if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_1_3, this.fixVersion.version)) {
                if (!jmf.hasAttribute("AgentName")) {
                    jmf.setAgentName(JDFAudit.getStaticAgentName());
                }
                if (!jmf.hasAttribute("AgentVersion")) {
                    jmf.setAgentName(JDFAudit.getStaticAgentVersion());
                }
            } else {
                jmf.removeAttribute("AgentName");
                jmf.removeAttribute("AgentVersion");
            }
        }
        return super.walk(e1, trackElem);
    }
}

