/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Vector;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.AuditPoolHelper;
import org.cip4.jdflib.extensions.MessageResourceHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.pool.JDFAmountPool;

class AuditMover {
    final KElement newRoot;

    AuditMover(KElement newRoot) {
        this.newRoot = newRoot;
    }

    void copySetsToAudits() {
        XJDFHelper h = new XJDFHelper(this.newRoot);
        AuditPoolHelper ah = h.getCreateAuditPool();
        Vector<SetHelper> sets = h.getSets();
        if (sets != null) {
            for (SetHelper set : sets) {
                MessageResourceHelper arh = ah.getMessageResourceHelper(set);
                if (arh == null) {
                    this.copySetToAudits(set, ah);
                    continue;
                }
                this.copySetToAudits(set, null);
            }
        }
    }

    void copySetToAudits(SetHelper set, AuditPoolHelper ah) {
        for (ResourceHelper rh : set.getPartitionList()) {
            this.moveActualToAudit(rh, ah);
        }
    }

    void moveActualToAudit(ResourceHelper ph, AuditPoolHelper ah) {
        if (JDFAmountPool.AmountPoolHelper.getAmountPoolSumDouble(ph, "AcualWaste", null) > 0.0 || JDFAmountPool.AmountPoolHelper.getAmountPoolSumDouble(ph, "ActualAmount", null) > 0.0) {
            MessageResourceHelper arh;
            SetHelper shAudit;
            ResourceHelper phNew;
            JDFAmountPool apNew;
            SetHelper sh = ph.getSet();
            if (ah != null && (apNew = (phNew = (shAudit = (arh = ah.getCreateMessageResourceHelper(sh)).getSet()).getCreateVPartition(ph.getPartMapVector(), false)).getAmountPool()) == null) {
                JDFAmountPool amountPool = ph.getAmountPool();
                JDFAmountPool apCopied = (JDFAmountPool)phNew.getRoot().copyElement(amountPool, null);
                for (JDFPartAmount pa : apCopied.getAllPartAmount()) {
                    pa.removeAttribute("Amount");
                    pa.removeAttribute("Waste");
                    pa.removeAttribute("MaxAmount");
                    pa.removeAttribute("MinAmount");
                    pa.renameAttribute("ActualAmount", "Amount");
                    pa.renameAttribute("ActualWaste", "Waste");
                }
            }
            JDFAmountPool amountPool = ph.getAmountPool();
            for (JDFPartAmount pa : amountPool.getAllPartAmount()) {
                pa.removeAttribute("ActualAmount");
                pa.removeAttribute("ActualWaste");
            }
        }
    }

    public String toString() {
        return "AuditMover [" + (this.newRoot != null ? "newRoot=" + this.newRoot : "") + "]";
    }
}

