/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJDFZipWriter;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;

class MultiJDFToXJDF {
    private final JDFToXJDF jdfToXJDF;

    void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        File file = new File(fileName);
        if (file.canRead()) {
            if (replace) {
                boolean ok = file.delete();
                if (!ok) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Cannot delet output: " + fileName));
                }
            } else {
                throw new JDFException("output file exists: " + file.getPath());
            }
        }
        FileUtil.writeFile(this.getZipWriter(rootNode), new File(fileName));
    }

    XJDFZipWriter getZipWriter(JDFNode rootNode) {
        this.jdfToXJDF.setSingleNode(true);
        List<XJDFHelper> vXJDFs = this.getXJDFs(rootNode, true);
        XJDFZipWriter w = new XJDFZipWriter();
        for (XJDFHelper h : vXJDFs) {
            w.addXJDF(h);
        }
        return w;
    }

    MultiJDFToXJDF(JDFToXJDF jdfToXJDF) {
        this.jdfToXJDF = jdfToXJDF;
    }

    List<XJDFHelper> getXJDFs(JDFNode root, boolean ordered) {
        if (root == null) {
            return null;
        }
        this.jdfToXJDF.setSingleNode(true);
        ArrayList<XJDFHelper> vRet = new ArrayList<XJDFHelper>();
        VElement v = this.getProcessNodes(root);
        boolean keepProduct = this.jdfToXJDF.wantProduct;
        this.jdfToXJDF.wantProduct = true;
        this.jdfToXJDF.preFixVersion(root);
        this.jdfToXJDF.setPreprocess(false);
        if ("Product".equals(root.getType())) {
            XJDFHelper xjdfHelper = this.convertSingle(root);
            vRet.add(xjdfHelper);
        }
        this.jdfToXJDF.wantProduct = false;
        if (ordered) {
            this.reorderNodes(v);
        }
        for (KElement n : v) {
            XJDFHelper xjdfHelper = this.convertSingle(n);
            vRet.add(xjdfHelper);
        }
        this.jdfToXJDF.wantProduct = keepProduct;
        this.jdfToXJDF.setPreprocess(true);
        return vRet;
    }

    void reorderNodes(VElement v) {
        int i;
        HashMap<JDFNode, VElement> mapPred = new HashMap<JDFNode, VElement>();
        int size = v.size();
        for (i = 0; i < size; ++i) {
            JDFNode ni = (JDFNode)v.get(i);
            mapPred.put(ni, ni.getPredecessors(true, false));
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                JDFNode ni = (JDFNode)v.get(i);
                JDFNode nj = (JDFNode)v.get(j);
                if (!((VElement)mapPred.get(nj)).contains(ni)) continue;
                v.remove(ni);
                v.insertElementAt(ni, j);
            }
        }
    }

    private XJDFHelper convertSingle(KElement n) {
        KElement xjdf = this.jdfToXJDF.makeNewJDF((JDFNode)n, null);
        XJDFHelper xjdfHelper = new XJDFHelper(xjdf);
        if (this.jdfToXJDF.isCleanup()) {
            xjdfHelper.cleanUp();
        }
        this.jdfToXJDF.completedRefs.clear();
        return xjdfHelper;
    }

    VElement getProcessNodes(JDFNode rootNode) {
        List<JDFNode> v = rootNode.getTreeByClass(JDFNode.class, true);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFNode n = v.get(i);
            if (!n.isProcessNode()) {
                v.remove(i);
                continue;
            }
            this.ensureJobPartID(i, n);
        }
        VElement v2 = new VElement();
        v2.addAll(v);
        return v2;
    }

    private void ensureJobPartID(int i, JDFNode n) {
        String nam = n.getJobPartID(false);
        if (StringUtil.getNonEmpty(nam) == null) {
            nam = "Part_" + i;
            n.setJobPartID(nam);
        }
    }

    public String toString() {
        return "MultiJDFToXJDF [" + (this.jdfToXJDF != null ? "jdfToXJDF=" + this.jdfToXJDF : "") + "]";
    }
}

