/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.cxf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFCMYKColor;
import org.cip4.jdflib.datatypes.JDFLabColor;
import org.cip4.jdflib.datatypes.JDFNumberList;
import org.cip4.jdflib.datatypes.JDFRGBColor;
import org.cip4.jdflib.datatypes.JDFTransferFunction;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.cxf.CxFBase;

public class CxFColorObject
extends CxFBase {
    CxFColorObject(KElement object) {
        super(object);
    }

    public JDFColor getJDFColor() {
        JDFColor c = (JDFColor)JDFElement.createRoot("Color");
        if (this.root != null) {
            c.copyAttribute("Name", this.root);
            c.setLab(this.getCieLab());
            c.setsRGB(this.getRGBColor());
            c.setCMYK(this.getCMYKColor());
            c.setAttribute("Spectrum", this.getSpectrum().toString());
        }
        return c;
    }

    public JDFLabColor getCieLab() {
        KElement cie = this.getXPathElement("ColorValues/ColorCIELab");
        if (cie == null) {
            return null;
        }
        double l = StringUtil.parseDouble(cie.getXPathAttribute("L", null), 0.0);
        double a = StringUtil.parseDouble(cie.getXPathAttribute("A", null), 0.0);
        double b = StringUtil.parseDouble(cie.getXPathAttribute("B", null), 0.0);
        return new JDFLabColor(l, a, b);
    }

    public JDFRGBColor getRGBColor() {
        KElement cie = this.getXPathElement("ColorValues/ColorSRGB");
        if (cie == null) {
            return null;
        }
        double range = StringUtil.parseDouble(cie.getXPathAttribute("MaxRange", null), 255.0);
        double r = StringUtil.parseDouble(cie.getXPathAttribute("R", null), 0.0);
        double g = StringUtil.parseDouble(cie.getXPathAttribute("G", null), 0.0);
        double b = StringUtil.parseDouble(cie.getXPathAttribute("B", null), 0.0);
        return new JDFRGBColor(r / range, g / range, b / range);
    }

    public JDFTransferFunction getSpectrum() {
        KElement spectrum = this.getXPathElement("ColorValues/ReflectanceSpectrum");
        if (spectrum == null) {
            return null;
        }
        double start = spectrum.getRealAttribute("StartWL", null, 0.0);
        if (start == 0.0) {
            return null;
        }
        JDFNumberList l = JDFNumberList.createNumberList(spectrum.getText());
        if (l == null) {
            return null;
        }
        JDFTransferFunction tf = new JDFTransferFunction();
        tf.set(start, 10.0, l.getDoubleVector());
        return tf;
    }

    public JDFCMYKColor getCMYKColor() {
        KElement cie = this.getXPathElement("DeviceColorValues/ColorCMYK");
        if (cie == null) {
            return null;
        }
        double range = StringUtil.parseDouble(cie.getXPathAttribute("MaxRange", null), 255.0);
        double c = StringUtil.parseDouble(cie.getXPathAttribute("Cyan", null), 255.0);
        double m = StringUtil.parseDouble(cie.getXPathAttribute("Magenta", null), 0.0);
        double y = StringUtil.parseDouble(cie.getXPathAttribute("Yellow", null), 0.0);
        double k = StringUtil.parseDouble(cie.getXPathAttribute("Black", null), 0.0);
        return new JDFCMYKColor(c / range, m / range, y / range, k / range);
    }
}

