/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.ExtensionListener;
import org.cip4.jdflib.util.hotfolder.FileTime;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.HotFolderRunner;

public class HotFolder {
    private static int defaultStabilizeTime = 6666;
    public int stabilizeTime = defaultStabilizeTime;
    private final File dir;
    private String allExtensions;
    private long lastModified = -1L;
    private ArrayList<FileTime> lastFileTime;
    protected final ArrayList<ExtensionListener> hfl;
    final Set<File> hfRunning;
    private static final Log log = LogFactory.getLog(HotFolder.class);

    public void setMaxConcurrent(int maxConcurrent) {
        HotFolderRunner.getCreateTherunner().setMaxConcurrent(maxConcurrent);
    }

    public ExtensionListener getListener(int i) {
        return ContainerUtil.get(this.hfl, i);
    }

    public int getMaxConcurrent() {
        HotFolderRunner r = HotFolderRunner.getTherunner();
        return r == null ? 0 : r.getMaxConcurrent();
    }

    boolean loop() {
        long t0 = System.currentTimeMillis();
        long lastMod = this.dir.lastModified();
        int n = this.lastFileTime.size();
        if (lastMod > this.lastModified || n > 0 || t0 - this.lastModified < 42000L) {
            int i;
            this.lastModified = lastMod;
            File[] files = this.getHotFiles();
            if (this.lastFileTime.size() > 0 && files != null) {
                int fileListLength = files.length;
                for (i = 0; i < this.lastFileTime.size(); ++i) {
                    FileTime ft;
                    boolean found = false;
                    FileTime lftAt = this.lastFileTime.get(i);
                    for (int j = 0; j < fileListLength; ++j) {
                        boolean processed;
                        File fileJ = files[j];
                        if (fileJ == null || !fileJ.equals(lftAt.f) || !(processed = this.processSingleFile(lftAt))) continue;
                        found = processed;
                        files[j] = null;
                    }
                    if (found || (ft = this.lastFileTime.get(i)).exists()) continue;
                    this.lastFileTime.remove(i--);
                }
            }
            if (files != null) {
                List<File> vf = ContainerUtil.toArrayList(files);
                for (i = vf.size() - 1; i >= 0; --i) {
                    if (vf.get(i) != null) continue;
                    vf.remove(i);
                }
                if (!vf.isEmpty()) {
                    files = vf.toArray(new File[0]);
                    for (File f : files = new FileSorter(files).sortLastModified(false)) {
                        this.lastFileTime.add(new FileTime(f, false));
                    }
                }
            }
        }
        return this.lastFileTime.size() != n;
    }

    public File getDir() {
        return this.dir;
    }

    String getAllExtensions() {
        if (this.allExtensions != null) {
            return this.allExtensions;
        }
        if (this.hfl == null) {
            return null;
        }
        StringArray allextensions = new StringArray();
        try {
            for (ExtensionListener element : this.hfl) {
                Set<String> ext = element.extension;
                if (ext != null) {
                    allextensions.addAll(ext);
                    continue;
                }
                return null;
            }
            allextensions.unify();
            this.allExtensions = allextensions.getString(",", null, null);
            return this.allExtensions;
        }
        catch (Exception x) {
            return null;
        }
    }

    ArrayList<FileTime> getLastFileTime() {
        return this.lastFileTime;
    }

    void setLastFileTime(ArrayList<FileTime> lastFileTime) {
        this.lastFileTime = lastFileTime;
    }

    @Deprecated
    public HotFolder(File _dir) {
        this(_dir, null, null);
    }

    public synchronized void addListener(HotFolderListener _hfl, String ext) {
        if (this.hfl != null) {
            this.hfl.add(new ExtensionListener(_hfl, ext));
        }
        this.allExtensions = null;
        this.lastModified = 0L;
    }

    public HotFolder(File _dir, String ext, HotFolderListener _hfl) {
        this.dir = _dir;
        this.dir.mkdirs();
        this.dir.setWritable(true);
        this.lastFileTime = new ArrayList();
        this.hfl = new ArrayList();
        this.hfRunning = new HashSet<File>();
        this.allExtensions = null;
        HotFolderRunner.getCreateTherunner();
        if (_hfl != null) {
            this.addListener(_hfl, ext);
            this.restart();
        }
    }

    public synchronized void restart() {
        int mc = this.getMaxConcurrent();
        this.stop();
        if (this.dir.canWrite()) {
            log.info((Object)("Restarting " + this.toString()));
        } else {
            log.error((Object)("Cannot use read only hot folder at " + this));
        }
        HotFolderRunner r = HotFolderRunner.getCreateTherunner();
        this.setMaxConcurrent(mc);
        r.add(this);
        this.lastModified = -1L;
        this.hfRunning.clear();
    }

    public synchronized void stop() {
        HotFolderRunner r = HotFolderRunner.getTherunner();
        if (r != null && r.contains(this)) {
            r.remove(this);
            log.info((Object)("stopped hot folder at: " + this.dir.getAbsolutePath()));
        }
    }

    File[] getHotFiles() {
        HotFolderRunner r = HotFolderRunner.getTherunner();
        if (r == null) {
            return null;
        }
        File[] files = FileUtil.listFilesWithExtension(this.dir, this.getAllExtensions());
        int n = 0;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.canWrite()) {
                    log.warn((Object)("ignoring read only file in hot folder: " + file));
                    files[i] = null;
                    continue;
                }
                if (file.isDirectory() || file.isHidden() || this.hfRunning.contains(file)) {
                    files[i] = null;
                    continue;
                }
                ++n;
            }
        }
        return n == 0 ? null : files;
    }

    boolean processSingleFile(FileTime lftAt) {
        boolean found = true;
        if (lftAt.sameModified() && lftAt.modified + (long)this.stabilizeTime < System.currentTimeMillis()) {
            this.lastFileTime.remove(lftAt);
            HotFolderRunner.getTherunner().runFile(new HotFileRunner(lftAt.f));
        } else if (!lftAt.exists()) {
            log.warn((Object)("removed disappearing hot file " + lftAt));
            this.lastFileTime.remove(lftAt);
            found = false;
        } else {
            lftAt.updateModified();
        }
        return found;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.dir + " " + this.lastModified;
    }

    public static int getDefaultStabilizeTime() {
        return defaultStabilizeTime;
    }

    public static void setDefaultStabilizeTime(int defaultStabilizeTime) {
        if (defaultStabilizeTime > 0) {
            HotFolder.defaultStabilizeTime = defaultStabilizeTime;
        }
    }

    public int getStabilizeTime() {
        return this.stabilizeTime;
    }

    public void setStabilizeTime(int stabilizeTime) {
        if (stabilizeTime >= 2000) {
            this.stabilizeTime = stabilizeTime;
        }
    }

    public int hashCode() {
        return this.dir == null ? 0 : this.dir.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.dir == null) {
            return obj == null;
        }
        if (!(obj instanceof HotFolder)) {
            return false;
        }
        return this.dir.equals(((HotFolder)obj).dir);
    }

    class HotFileRunner
    implements Runnable {
        final File fileJ;

        HotFileRunner(File fileJ) {
            HotFolder.this.hfRunning.add(fileJ);
            this.fileJ = fileJ;
        }

        @Override
        public void run() {
            for (ExtensionListener xl : HotFolder.this.hfl) {
                try {
                    xl.hotFile(this.fileJ);
                }
                catch (Throwable x) {
                    log.error((Object)"exception processing hot file", x);
                }
            }
            if (this.fileJ != null) {
                HotFolder.this.hfRunning.remove(this.fileJ);
                log.info((Object)("completed running " + this));
            }
        }

        public String toString() {
            return "HotFileRunner [fileJ=" + this.fileJ + "]";
        }
    }
}

