/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.hotfolder.HotFolder;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.StorageHotFolderListener;

public class StorageHotFolder {
    final HotFolder hf;
    final File storageDir;
    final Log log = LogFactory.getLog(this.getClass());
    int retry = 1;
    boolean synchronous = true;
    final List<StorageHotFolderListener> listenerImpl;

    public File getHfDirectory() {
        return this.hf.getDir();
    }

    public StorageHotFolder(File _hotFolderDir, File storageDir, String ext, HotFolderListener hfListener) {
        this.storageDir = storageDir;
        storageDir.mkdirs();
        storageDir.setWritable(true);
        if (!storageDir.isDirectory()) {
            this.log.error((Object)("Storage Directory is not a directory: " + storageDir.getAbsolutePath()));
        } else {
            this.moveFromTemp(_hotFolderDir);
        }
        this.listenerImpl = new ArrayList<StorageHotFolderListener>();
        this.hf = new HotFolder(_hotFolderDir, null, null);
        if (hfListener != null) {
            this.addListener(hfListener, ext);
            this.restart();
        }
    }

    private void moveFromTemp(File _hotFolderDir) {
        File[] junk = this.storageDir.listFiles();
        if (junk != null && junk.length > 0) {
            this.log.warn((Object)("moving " + junk.length + " legacy temp files from: " + this.storageDir.getPath()));
            for (File f : junk) {
                File fMoved = FileUtil.moveFileToDir(f, _hotFolderDir);
                if (fMoved == null) {
                    this.log.warn((Object)("cannot move " + f.getName() + " from temp dir"));
                    continue;
                }
                this.log.info((Object)("moving " + f.getName() + " from temp dir to main hot folder"));
            }
        }
    }

    public void stop() {
        this.hf.stop();
    }

    public void restart() {
        this.hf.restart();
    }

    public StorageHotFolderListener addListener(HotFolderListener _hfl, String ext) {
        StorageHotFolderListener storageListener = new StorageHotFolderListener(this.storageDir, _hfl, this);
        this.hf.addListener(storageListener, ext);
        this.listenerImpl.add(storageListener);
        return storageListener;
    }

    public StorageHotFolderListener getListener(int i) {
        return this.listenerImpl.get(i);
    }

    public void setOKStorage(File ok) {
        for (StorageHotFolderListener shfl : this.listenerImpl) {
            shfl.setOKStorage(FileUtil.getFileInDirectory(this.getHfDirectory(), ok));
        }
    }

    public void copyCompleted(File storedFile, boolean ok) {
        this.listenerImpl.get(0).copyCompleted(storedFile, ok);
    }

    public void setErrorStorage(File error) {
        for (StorageHotFolderListener shfl : this.listenerImpl) {
            shfl.setErrorStorage(FileUtil.getFileInDirectory(this.getHfDirectory(), error));
        }
    }

    public void setMaxStore(int maxStore) {
        for (StorageHotFolderListener shfl : this.listenerImpl) {
            shfl.setMaxStore(maxStore);
        }
    }

    public void setMaxAux(int maxStore) {
        for (StorageHotFolderListener shfl : this.listenerImpl) {
            shfl.setMaxAux(maxStore);
        }
    }

    public void setMaxConcurrent(int maxConcurrent) {
        this.hf.setMaxConcurrent(maxConcurrent);
    }

    public void setStabilizeTime(int stabilizeTime) {
        this.hf.setStabilizeTime(stabilizeTime);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[hf=" + this.hf + ", storageDir=" + this.storageDir + " retry=" + this.retry;
    }

    protected int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        if (retry < 1) {
            retry = 1;
        }
        this.retry = retry;
    }

    public int getMaxConcurrent() {
        return this.hf.getMaxConcurrent();
    }

    public int getStabilizeTime() {
        return this.hf.getStabilizeTime();
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

