/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.OrderedTaskQueue;

public class MultiTaskQueue
extends OrderedTaskQueue {
    private int maxParallel = 0;
    private ThreadPoolExecutor executor;
    private final Vector<OrderedTaskQueue.TaskRunner> current = new Vector();
    int nThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiTaskQueue getCreateQueue(String name, int maxParallel) {
        name = MultiTaskQueue.getThreadName(name);
        Map map = theMap;
        synchronized (map) {
            OrderedTaskQueue orderedTaskQueue = (OrderedTaskQueue)theMap.get(name);
            if (!(orderedTaskQueue instanceof MultiTaskQueue)) {
                orderedTaskQueue = new MultiTaskQueue(name);
                theMap.put(name, orderedTaskQueue);
            }
            MultiTaskQueue multiTaskQueue = (MultiTaskQueue)orderedTaskQueue;
            multiTaskQueue.setMaxParallel(maxParallel);
            return multiTaskQueue;
        }
    }

    public void setMaxParallel(int maxParallel) {
        if (maxParallel > 0 && maxParallel != this.maxParallel) {
            this.maxParallel = maxParallel;
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(maxParallel, new MyThreadFactory());
        }
    }

    public int getCurrentRunning() {
        return this.current.size();
    }

    @Override
    public boolean interruptCurrent(int minAge) {
        ArrayList<OrderedTaskQueue.TaskRunner> currentCopy = new ArrayList<OrderedTaskQueue.TaskRunner>();
        currentCopy.addAll(this.current);
        boolean bRet = false;
        for (OrderedTaskQueue.TaskRunner next : currentCopy) {
            if (next.getRunTime() < (long)minAge) continue;
            this.interruptRunner(next);
            bRet = bRet || !this.current.contains(next);
        }
        return bRet;
    }

    public boolean interruptTask(Runnable theRunner) {
        ArrayList<OrderedTaskQueue.TaskRunner> currentCopy = new ArrayList<OrderedTaskQueue.TaskRunner>();
        currentCopy.addAll(this.current);
        boolean bRet = false;
        for (OrderedTaskQueue.TaskRunner next : currentCopy) {
            if (next.theTask != theRunner) continue;
            this.interruptRunner(next);
            bRet = !this.current.contains(next);
            break;
        }
        return bRet;
    }

    private void interruptRunner(OrderedTaskQueue.TaskRunner next) {
        int n = 1;
        if (next.myThread == null) {
            this.current.remove(next);
            this.log.info((Object)("Zapped idle " + next));
        } else {
            while (this.current.contains(next)) {
                next.interrupt();
                if (ThreadUtil.sleep(++n) && n <= 10) continue;
                break;
            }
        }
    }

    ArrayList<Runnable> getCurrent(int minAge) {
        ArrayList<OrderedTaskQueue.TaskRunner> currentCopy = new ArrayList<OrderedTaskQueue.TaskRunner>();
        currentCopy.addAll(this.current);
        ArrayList<Runnable> vReturn = new ArrayList<Runnable>();
        for (OrderedTaskQueue.TaskRunner next : currentCopy) {
            if (next.getRunTime() < (long)minAge) continue;
            vReturn.add(next.theTask);
        }
        return vReturn;
    }

    MultiTaskQueue(String name) {
        super(name);
        this.setMaxParallel(2);
        this.nThread = 1;
        super.start();
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName() + " " + this.idle + " queue: " + this.queue;
    }

    @Override
    void runTask(OrderedTaskQueue.TaskRunner r) {
        this.idle.set(0);
        NextRunner nr = new NextRunner(r);
        this.current.add(nr);
        this.executor.submit(nr);
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    @Override
    public int executing() {
        return this.executor == null ? 0 : this.executor.getActiveCount();
    }

    @Override
    public int size() {
        return super.size() + this.current.size();
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, MultiTaskQueue.this.getName() + "_" + MultiTaskQueue.this.nThread++);
            t.setDaemon(true);
            return t;
        }
    }

    private class NextRunner
    extends OrderedTaskQueue.TaskRunner {
        NextRunner(OrderedTaskQueue.TaskRunner r) {
            super(r.theTask);
            this.tQueue = r.tQueue;
            this.tStart = r.tStart;
            this.tEnd = r.tEnd;
        }

        @Override
        public void run() {
            super.run();
            MultiTaskQueue.this.current.remove(this);
            ThreadUtil.notifyAll(MultiTaskQueue.this.mutex);
            MultiTaskQueue.this.idle.set(0);
        }
    }
}

