/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.IDPart;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.PostConverter;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFPrepWalker;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UnitParser;

public class XJDFToJDFImpl
extends PackageElementWalker {
    static final String PRODUCT_NAME = "generated product component";
    JDFDoc jdfDoc;
    Map<String, IDPart> idMap;
    boolean firstConvert;
    boolean firstproductInList;
    boolean foundProduct;
    boolean foundProductList;
    JDFNode currentJDFNode;
    XJDFHelper xjdf;
    boolean createProduct;
    boolean convertUnits;
    private JDFElement.EnumVersion version;
    private boolean bConvertTilde;
    private boolean typeLinks;
    private boolean heuristicLink;

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkXElement constructWalker = (WalkXElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }

    public boolean isCreateProduct() {
        return this.createProduct;
    }

    public void setCreateProduct(boolean createProduct) {
        this.createProduct = createProduct;
    }

    public boolean isConvertUnits() {
        return this.convertUnits;
    }

    public void setConvertUnits(boolean convertUnits) {
        this.convertUnits = convertUnits;
    }

    public boolean isbConvertTilde() {
        return this.bConvertTilde;
    }

    public XJDFToJDFImpl(JDFDoc template) {
        super(new BaseWalkerFactory());
        this.reset(template);
    }

    public void reset(JDFDoc template) {
        this.createProduct = true;
        this.firstproductInList = true;
        this.firstConvert = true;
        this.currentJDFNode = null;
        this.foundProductList = false;
        this.jdfDoc = template == null ? null : template.clone();
        this.idMap = null;
        this.foundProduct = false;
        this.bConvertTilde = true;
        this.convertUnits = false;
        this.typeLinks = false;
        this.heuristicLink = true;
        this.version = this.getVersion(template);
    }

    private JDFElement.EnumVersion getVersion(JDFDoc template) {
        JDFElement.EnumVersion v;
        JDFNode n = template == null ? null : template.getJDFRoot();
        JDFElement.EnumVersion enumVersion = v = n != null ? n.getVersion(true) : null;
        if (v == null) {
            v = JDFAudit.getDefaultJDFVersion();
        }
        return v;
    }

    public void resetProduct() {
        this.foundProduct = false;
        this.foundProductList = false;
        this.firstproductInList = true;
    }

    protected JDFDoc convert(KElement _xjdf) {
        if (_xjdf == null) {
            return null;
        }
        boolean isJMF = this.prepareConvert(_xjdf);
        if (isJMF) {
            this.convertXJMF();
        } else {
            this.prepareRoot();
            KElement root = this.xjdf.getRoot();
            JDFNode theNode = this.findNode(root, true);
            if (theNode == null) {
                return null;
            }
            this.walkTree(root, theNode);
            this.postConvert(theNode);
        }
        return this.jdfDoc;
    }

    protected void postConvert(JDFNode theNode) {
        PostConverter postConverter = new PostConverter(this, theNode);
        postConverter.postConvert();
    }

    private void convertXJMF() {
        KElement root = this.xjdf.getRoot();
        this.idMap = new IDFinder().getMap(root);
        this.walkTree(root, this.jdfDoc.getRoot());
    }

    private boolean prepareConvert(KElement _xjdf) {
        KElement newXJDF = new JDFDoc(_xjdf.cloneNewDoc().getOwnerDocument()).getRoot();
        this.idMap = new IDFinder().getMap(newXJDF);
        String docType = newXJDF.getLocalName();
        boolean isJMF = "JMF".equals(docType) || "XJMF".equals(docType);
        this.xjdf = new XJDFHelper(newXJDF);
        if (this.jdfDoc == null) {
            String strDocType = isJMF ? "JMF" : "JDF";
            this.jdfDoc = new JDFDoc(strDocType);
            this.jdfDoc.copyMeta(newXJDF.getOwnerDocument_KElement());
        }
        this.xjdf.setAttribute("MaxVersion", this.getXJDFVersion().getName());
        this.xjdf.setAttribute("Version", this.getVersion().getName());
        new XJDFPrepWalker().walkTree(newXJDF, null);
        this.xjdf.cleanUp(false);
        return isJMF;
    }

    protected KElement reparse(KElement xjdf) {
        if (xjdf != null && !(xjdf.getOwnerDocument() instanceof DocumentJDFImpl)) {
            JDFDoc doc = new JDFDoc(xjdf.getOwnerDocument());
            doc.setInitOnCreate(false);
            KElement xjdf2 = doc.getRoot();
            if (!xjdf2.getLocalName().equals(xjdf.getLocalName())) {
                xjdf2 = xjdf2.getChildByTagName(xjdf.getNodeName(), xjdf.getNamespaceURI(), 0, xjdf.getAttributeMap(), false, true);
            }
            int i = 0;
            while (xjdf2 != null) {
                if (xjdf.isEqual(xjdf2)) {
                    xjdf = xjdf2;
                    break;
                }
                xjdf2 = xjdf2.getChildByTagName(xjdf.getNodeName(), xjdf.getNamespaceURI(), ++i, xjdf.getAttributeMap(), false, true);
            }
            if (xjdf2 == null) {
                this.log.error((Object)"SNAFU converting xjdf - retaining old");
            }
        }
        return xjdf;
    }

    private JDFNode prepareRoot() {
        JDFNode root = this.jdfDoc.getJDFRoot();
        if (this.firstConvert) {
            root.getCreateAuditPool().addModified(null, null);
        } else if (!"Product".equals(root.getType())) {
            root = this.createProductRoot();
        }
        return root;
    }

    public boolean canConvert(KElement xjdf) {
        return xjdf == null ? false : "XJDF".equals(xjdf.getLocalName());
    }

    private JDFNode findNode(KElement xjdf, boolean create) {
        JDFNode n;
        JDFNode root = this.jdfDoc.getJDFRoot();
        String jpID = xjdf.getAttribute("JobPartID", null, null);
        JDFNode jDFNode = n = jpID == null ? null : root.getJobPart(jpID, null);
        if (n == null) {
            if (!root.hasAttribute("Type")) {
                return root;
            }
            if (jpID == null) {
                List<JDFNode> nodes = root.getTreeByClass(JDFNode.class, true);
                nodes.remove(0);
                nodes.add(root);
                VString xTypes = StringUtil.tokenize(xjdf.getAttribute("Types"), null, false);
                for (JDFNode n2 : nodes) {
                    VString vtypes = n2.getAllTypes();
                    if (vtypes == null || xTypes == null || !vtypes.containsAll(xTypes)) continue;
                    return n2;
                }
            }
        }
        if (n == null && create) {
            n = root.addProcessGroup(new VString(xjdf.getAttribute("Types"), null));
        }
        return n;
    }

    protected JDFNode createProductRoot() {
        JDFNode parent = (JDFNode)this.jdfDoc.createElement("JDF");
        parent.setType(JDFNode.EnumType.Product);
        JDFNode oldParent = this.jdfDoc.getJDFRoot();
        oldParent = (JDFNode)parent.moveElement(oldParent, null);
        this.jdfDoc.appendChild(parent);
        parent.moveAttribute("JobID", oldParent);
        parent.moveAttribute("Version", oldParent);
        parent.moveAttribute("MaxVersion", oldParent);
        parent.moveAttribute("CommentURL", oldParent);
        parent.setJobPartID("rootPart");
        parent.moveElement(oldParent.getResourcePool(), null);
        JDFComponent c = (JDFComponent)parent.addResource("Component", JDFResourceLink.EnumUsage.Output);
        c.setDescriptiveName(PRODUCT_NAME);
        c.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, null);
        this.firstConvert = true;
        return parent;
    }

    protected void convertUnits(KElement element) {
        if (this.convertUnits) {
            new UnitParser().convertUnits(element);
        }
    }

    protected void convertTilde(KElement e2) {
        if (this.bConvertTilde) {
            JDFAttributeMap map = e2.getAttributeMap();
            Iterator<String> keyIt = map.getKeyIterator();
            while (keyIt.hasNext()) {
                StringArray v;
                String key = keyIt.next();
                String val = map.get(key);
                if (!(e2 instanceof JDFElement) || !AttributeInfo.EnumAttributeType.isRange(((JDFElement)e2).getAttributeInfo().getAttributeType(key)) || val.indexOf("~") >= 0 || (v = new StringArray(val, null)).size() % 2 != 0) continue;
                JDFNameRangeList nrl = new JDFNameRangeList();
                for (int i = 0; i < v.size(); i += 2) {
                    nrl.append(new JDFNameRange(v.get(i), v.get(i + 1)));
                }
                String newVal = nrl.getString(0);
                if (val.equals(newVal)) continue;
                e2.setAttribute(key, newVal);
            }
        }
    }

    public void setVersion(JDFElement.EnumVersion version) {
        this.version = version;
    }

    public JDFElement.EnumVersion getVersion() {
        if (this.xjdf != null) {
            String xVersion = this.xjdf.getAttribute("Version");
            int minor = StringUtil.parseInt(StringUtil.token(xVersion, -1, "."), -1);
            if (minor == 1) {
                this.version = (JDFElement.EnumVersion)EnumUtil.max(JDFElement.EnumVersion.Version_1_7, this.version);
            }
            if (minor == 2) {
                this.version = (JDFElement.EnumVersion)EnumUtil.max(JDFElement.EnumVersion.Version_1_8, this.version);
            }
        }
        return this.version;
    }

    protected void attributesToSpan(KElement e) {
        if (e != null) {
            JDFAttributeMap map = e.getAttributeMap();
            JDFElement ir = (JDFElement)e;
            StringArray keys = map.getKeyList();
            VString knownElements = ir.knownElements();
            for (String name : keys) {
                if (!knownElements.contains(name)) continue;
                this.attributeToSpan(e, name);
            }
        }
    }

    protected KElement attributeToSpan(KElement e, String name) {
        KElement subElem = e.appendElement(name);
        subElem.init();
        subElem.setAttribute("Actual", e.getAttribute(name));
        this.convertUnits(subElem);
        this.convertTilde(subElem);
        e.removeAttribute(name);
        return subElem;
    }

    private void moveToLink(JDFResourceLink rl, JDFAttributeMap partmap, JDFAttributeMap map, String a) {
        if (map == null || map.isEmpty() || rl == null) {
            return;
        }
        VString vGW = new VString("Good Waste", null);
        for (String gw : vGW) {
            JDFAttributeMap pm = new JDFAttributeMap(partmap);
            pm.put("Condition", gw);
            if (map.get(a + gw) == null) continue;
            rl.setAmountPoolAttribute(a, map.get(a + gw), null, pm);
            map.remove(a + gw);
        }
    }

    protected void moveAmountsToLink(JDFAttributeMap partmap, JDFAttributeMap map, JDFResourceLink rl) {
        if (rl != null) {
            this.moveToLink(rl, partmap, map, "Amount");
            this.moveToLink(rl, partmap, map, "ActualAmount");
            this.moveToLink(rl, partmap, map, "MaxAmount");
            if (partmap == null && rl.getXPathElement("AmountPool/PartAmount/Part") == null && rl.getAmountPool() != null) {
                JDFPartAmount pa = rl.getAmountPool().getPartAmount(0);
                rl.copyAttribute("Amount", pa);
                rl.copyAttribute("ActualAmount", pa);
                rl.copyAttribute("MaxAmount", pa);
                rl.getAmountPool().deleteNode();
            }
        }
    }

    public void setConvertTilde(boolean b) {
        this.bConvertTilde = b;
    }

    public void setTypeLinks(boolean typeLinks) {
        this.typeLinks = typeLinks;
    }

    public boolean isTypeLinks() {
        return this.typeLinks;
    }

    public boolean isHeuristicLink() {
        return this.heuristicLink;
    }

    public void setHeuristicLink(boolean heuristicLink) {
        this.heuristicLink = heuristicLink;
    }

    public JDFElement.EnumVersion getXJDFVersion() {
        JDFElement.EnumVersion v = this.getVersion();
        if (JDFElement.EnumVersion.Version_1_7.equals((Object)v)) {
            return JDFElement.EnumVersion.Version_2_1;
        }
        return BaseXJDFHelper.getDefaultVersion();
    }
}

