/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.StringUtil;

public class JDFEnumerationState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFEnumerationState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFEnumerationState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFEnumerationState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFEnumerationState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(String value) {
        this.setAttribute("CurrentValue", value);
    }

    public String getCurrentValue() {
        return this.getAttribute("CurrentValue", null, "");
    }

    public void setDefaultValue(String value) {
        this.setAttribute("DefaultValue", value);
    }

    public String getDefaultValue() {
        return this.getAttribute("DefaultValue", null, "");
    }

    public VString getAllowedValueList() {
        String attribute = this.getAttribute("AllowedValueList", null, null);
        return attribute == null ? null : new VString(attribute, null);
    }

    public void setAllowedValueList(VString vs) {
        this.setAttribute("AllowedValueList", StringUtil.setvString(vs, " ", null, null), null);
    }

    public VString getPresentValueList() {
        if (this.hasAttribute("PresentValueList")) {
            return new VString(this.getAttribute("PresentValueList", null, ""), null);
        }
        return this.getAllowedValueList();
    }

    public void setPresentValueList(VString vs) {
        String s = "";
        if (vs != null) {
            s = StringUtil.setvString(vs, " ", null, null);
        }
        this.setAttribute("PresentValueList", s);
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        VString list;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new VString();
            }
            list.appendUnique(value);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new VString();
            }
            list.appendUnique(value);
            this.setPresentValueList(list);
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (this.fitsListType(value)) {
            return this.fitsValueList(value, testlists) && this.fitsRegExp(value, testlists);
        }
        return false;
    }

    private final boolean fitsValueList(String value, JDFBaseDataTypes.EnumFitsValue valuelist) {
        VString vs = new VString(value, null);
        VString list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(vs, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(vs, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(vs, list);
        }
        int v_size = vs.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            boolean bFound = false;
            for (int j = 0; j < l_size; ++j) {
                String le;
                String ve = vs.elementAt(i);
                if (ve.compareTo(le = list.elementAt(j)) != 0) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteList(VString value, VString list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!this.isUnique(value)) {
            return false;
        }
        VString valueList = new VString(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.elementAt(i).equals(valueList.elementAt(j))) continue;
                valueList.remove(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(VString value, VString list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!this.isUnique(value)) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.elementAt(i).equals(value.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(VString value, VString list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.elementAt(i).equals(list.elementAt(j))) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isUnique(VString v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                String sj;
                String si;
                if (j == i || (si = v.elementAt(i)).compareTo(sj = v.elementAt(j)) != 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getAllowedRegExp() {
        return this.getAttribute("AllowedRegExp", null, "");
    }

    @Override
    public String getPresentRegExp() {
        if (this.hasAttribute("PresentRegExp")) {
            return this.getAttribute("PresentRegExp");
        }
        return this.getAllowedRegExp();
    }

    public void setAllowedRegExp(String value) {
        this.setAttribute("AllowedRegExp", value);
    }

    public void setPresentRegExp(String value) {
        this.setAttribute("PresentRegExp", value);
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.EnumerationEvaluation;
    }

    static {
        JDFEnumerationState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333331L, AttributeInfo.EnumAttributeType.enumerations, null, null);
        JDFEnumerationState.atrInfoTable[1] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, null, null);
        JDFEnumerationState.atrInfoTable[2] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, null, null);
        JDFEnumerationState.atrInfoTable[3] = new AtrInfoTable("PresentValueList", 0x33333331L, AttributeInfo.EnumAttributeType.enumerations, null, null);
        JDFEnumerationState.atrInfoTable[4] = new AtrInfoTable("AllowedRegExp", 0x33331111L, AttributeInfo.EnumAttributeType.RegExp, null, null);
        JDFEnumerationState.atrInfoTable[5] = new AtrInfoTable("PresentRegExp", 0x33331111L, AttributeInfo.EnumAttributeType.RegExp, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFEnumerationState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

