/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.intent;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoColorIntent;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFColorIntent
extends JDFAutoColorIntent {
    private static final long serialVersionUID = 1L;

    public JDFColorIntent(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFColorIntent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFColorIntent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFColorIntent[  --> " + super.toString() + " ]";
    }

    public int getNumColorsRaw() {
        return super.getNumColors();
    }

    @Override
    public int getNumColors() {
        int n = super.getNumColors();
        JDFSeparationList sl = this.getColorsUsed();
        if (sl == null) {
            return n;
        }
        VString vSep = sl.getSeparations();
        if (n >= 1) {
            vSep.remove("Black");
        }
        if (n == 4) {
            vSep.remove("Cyan");
            vSep.remove("Magenta");
            vSep.remove("Yellow");
        }
        return n + vSep.size();
    }

    public int getNumVarnish() {
        JDFSeparationList sl = this.getColorsUsed();
        if (sl == null) {
            return 0;
        }
        VString seps = sl.getSeparations();
        int n = 0;
        for (String sep : seps) {
            if (!JDFColorIntent.isVarnish(sep)) continue;
            ++n;
        }
        return n;
    }

    public static boolean isVarnish(String color) {
        if ((color = StringUtil.normalize(color, true)) == null) {
            return false;
        }
        if (color.indexOf("varnish") >= 0) {
            return true;
        }
        return "aqueous".equals(color) || "bronzing".equals(color);
    }
}

