/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.PlatformUtil;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.UrlUtil;

public class FileUtil {
    private static Log log = LogFactory.getLog(FileUtil.class);

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(File file) {
        if (!FileUtil.exists(file)) {
            return false;
        }
        boolean locked = false;
        FileLock lock = null;
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            channel = randomAccessFile.getChannel();
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            locked = true;
        }
        catch (IOException e) {
            locked = true;
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception e) {}
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception e) {}
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception e) {}
        }
        return locked;
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static File getAuxDir(File hotFile) {
        String name = hotFile == null ? null : hotFile.getName();
        String base = UrlUtil.newExtension(name, null);
        if (StringUtil.isEmpty(base)) {
            return null;
        }
        File parentDir = hotFile.getParentFile();
        File auxFile = FileUtil.getFileInDirectory(parentDir, new File(base));
        if (!auxFile.isDirectory()) {
            auxFile = null;
            File[] v = FileUtil.listDirectories(parentDir);
            if (v != null) {
                String ext = FileUtil.getExtension(hotFile);
                for (File f : v) {
                    File newExtension = FileUtil.newExtension(f, ext);
                    if (newExtension == null || !name.equals(newExtension.getName())) continue;
                    auxFile = f;
                    break;
                }
            }
        }
        return auxFile;
    }

    public static File[] listFilesWithExtension(File dir, String extension) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new ExtensionFileFilter(extension));
        return files == null || files.length == 0 ? null : files;
    }

    public static File[] listFilesWithExpression(File dir, String expression) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new ExpressionFileFilter(expression));
        return files == null || files.length == 0 ? null : files;
    }

    public static Vector<File> listFilesInTree(File dir, FileFilter filter) {
        Vector v = null;
        if (dir == null) {
            return null;
        }
        File[] f = dir.listFiles(filter);
        v = ContainerUtil.toVector(f);
        File[] dirs = FileUtil.listDirectories(dir);
        if (dirs != null) {
            for (File d : dirs) {
                Vector<File> v2 = FileUtil.listFilesInTree(d, filter);
                v = (Vector)ContainerUtil.addAll(v, v2);
            }
        }
        return v;
    }

    public static Vector<File> listFilesInTree(File dir, String expression) {
        Vector<File> v = null;
        if (dir == null) {
            return null;
        }
        if (expression == null) {
            return FileUtil.listFilesInTree(dir, (FileFilter)null);
        }
        int posSlash = expression.indexOf(47);
        v = posSlash < 0 ? FileUtil.listNoSlash(dir, expression) : FileUtil.listSlash(dir, expression, posSlash);
        return v;
    }

    static Vector<File> listSlash(File dir, String expression, int posSlash) {
        String nextDir = expression.substring(0, posSlash);
        File[] files = FileUtil.listFilesWithExpression(dir, nextDir);
        Vector<File> v = new Vector<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                v.add(file);
            }
            if (v.size() == 0) {
                v = null;
            }
            if (posSlash + 1 != expression.length() && v != null) {
                Vector<File> ret = new Vector<File>();
                String next = expression.substring(posSlash + 1);
                for (int i = 0; i < v.size(); ++i) {
                    Vector<File> v2 = FileUtil.listFilesInTree(v.get(i), next);
                    if (v2 == null) continue;
                    ret.addAll(v2);
                }
                v = ret.size() == 0 ? null : ret;
            }
        }
        return v;
    }

    static Vector<File> listNoSlash(File dir, String expression) {
        File[] f = FileUtil.listFilesWithExpression(dir, expression);
        Vector v = ContainerUtil.toVector(f);
        File[] dirs = FileUtil.listDirectories(dir);
        if (dirs != null) {
            for (File d : dirs) {
                Vector<File> v2 = FileUtil.listFilesInTree(d, expression);
                v = (Vector)ContainerUtil.addAll(v, v2);
            }
        }
        return v;
    }

    public static File[] listDirectories(File dir) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new DirectoryFileFilter());
        return files == null || files.length == 0 ? null : files;
    }

    public static boolean deleteAll(File dirToZapp) {
        File[] ff;
        if (dirToZapp == null) {
            return false;
        }
        boolean b = true;
        if (dirToZapp.isDirectory() && (ff = dirToZapp.listFiles()) != null) {
            int siz = ff.length;
            for (int i = 0; i < siz; ++i) {
                b = FileUtil.deleteAll(ff[i]) && b;
            }
        }
        return FileUtil.forceDelete(dirToZapp, 3, false) && b;
    }

    public static File streamToFile(InputStream fis, String fileName) {
        if (fis == null) {
            return null;
        }
        File tmp = UrlUtil.urlToFile(fileName);
        if (tmp == null) {
            return null;
        }
        return FileUtil.streamToFile(fis, tmp);
    }

    public static File writeFile(IStreamWriter w, File file) {
        boolean b = FileUtil.createNewFile(file);
        if (!b) {
            return null;
        }
        try {
            BufferedOutputStream fos = FileUtil.getBufferedOutputStream(file);
            if (fos == null) {
                return null;
            }
            w.writeStream(fos);
            ((OutputStream)fos).flush();
            ((OutputStream)fos).close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    public static File newExtension(File f, String newExt) {
        if (f == null) {
            return null;
        }
        return new File(UrlUtil.newExtension(f.getPath(), newExt));
    }

    public static File streamToFile(InputStream fis, File fil) {
        if (fis == null || fil == null) {
            return null;
        }
        boolean ok = FileUtil.createNewFile(fil);
        if (!ok) {
            log.warn((Object)("Could not create target file: " + fil.getAbsolutePath()));
        }
        try {
            BufferedOutputStream fos = FileUtil.getBufferedOutputStream(fil);
            if (fos == null) {
                return null;
            }
            IOUtils.copyLarge((InputStream)fis, (OutputStream)fos);
            ((OutputStream)fos).flush();
            ((OutputStream)fos).close();
            fis.close();
        }
        catch (IOException x) {
            log.error((Object)("Snafu streaming to " + fil.getAbsolutePath()), (Throwable)x);
            return null;
        }
        return fil;
    }

    public static File stringToFile(String s, File fil) {
        if (s == null || fil == null) {
            return null;
        }
        return FileUtil.streamToFile((InputStream)new ByteArrayInputStream(s.getBytes()), fil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFastMD5(File f, int maxSize) {
        MessageDigest md5;
        BufferedInputStream bufferedInputStream = FileUtil.getBufferedInputStream(f);
        if (bufferedInputStream == null || !f.canRead()) {
            return null;
        }
        if (maxSize <= 0 || f.length() <= (long)maxSize * 2L) {
            return StreamUtil.getMD5(bufferedInputStream);
        }
        byte[] b = new byte[maxSize];
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        try {
            MessageDigest e = md5;
            synchronized (e) {
                int tmp = 0;
                while (maxSize - tmp > 0) {
                    int read = bufferedInputStream.read(b);
                    md5.update(b, 0, read);
                    tmp += read;
                    if (read != 0) continue;
                    break;
                }
                long skipped = 42L;
                for (long toSkip = f.length() - 2L * (long)maxSize; toSkip > 0L && skipped != 0L; toSkip -= skipped) {
                    skipped = bufferedInputStream.skip(toSkip);
                }
                tmp = 0;
                while (maxSize - tmp > 0) {
                    int read = bufferedInputStream.read(b);
                    md5.update(b, 0, read);
                    tmp += read;
                    if (read != 0) continue;
                    break;
                }
                bufferedInputStream.close();
                return md5.digest();
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyPair<File, byte[]> streamToMD5File(InputStream fis, File fil) {
        MessageDigest md5;
        if (fis == null) {
            return null;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            DigestInputStream dis = new DigestInputStream(fis, md5);
            File fRet = FileUtil.streamToFile((InputStream)dis, fil);
            return fRet == null ? null : new MyPair<File, byte[]>(fRet, md5.digest());
        }
    }

    public static String fileToString(File file, Charset s) {
        byte[] a = FileUtil.fileToByteArray(file);
        if (s == null) {
            s = Charset.defaultCharset();
        }
        return a == null ? null : new String(a, s);
    }

    public static byte[] fileToByteArray(File file) {
        if (file == null || !file.canRead()) {
            return null;
        }
        try {
            int len = (int)file.length();
            if (len <= 0) {
                return null;
            }
            BufferedInputStream fis = FileUtil.getBufferedInputStream(file);
            byte[] b = new byte[len];
            int l = ((InputStream)fis).read(b);
            ((InputStream)fis).close();
            fis = null;
            if (l != len) {
                if (l == 0) {
                    return null;
                }
                byte[] b2 = new byte[l];
                for (int i = 0; i < l; ++i) {
                    b2[i] = b[i];
                }
                b = b2;
            }
            return b;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static File moveFileToDir(File fromFile, File toDir) {
        File newFile;
        boolean b;
        if (fromFile == null || toDir == null) {
            return null;
        }
        if (!toDir.isDirectory()) {
            toDir.mkdirs();
        }
        return (b = FileUtil.moveFile(fromFile, newFile = new File(toDir, fromFile.getName()))) ? newFile : null;
    }

    public static boolean moveFile(File fromFile, File toFile) {
        if (fromFile == null || toFile == null || !fromFile.exists()) {
            return false;
        }
        if (fromFile.equals(toFile)) {
            return true;
        }
        if (fromFile.isDirectory()) {
            File parent = toFile.getParentFile();
            String parentPath = parent == null ? null : parent.getAbsolutePath();
            FileUtil.getCreateDirectory(parentPath);
        }
        FileUtil.forceDelete(toFile, 2);
        if (fromFile.renameTo(toFile)) {
            return true;
        }
        if (!FileUtil.copyFile(fromFile, toFile)) {
            return false;
        }
        return FileUtil.forceDelete(fromFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyBytes(byte[] buf, File toFile) {
        if (buf == null || toFile == null) {
            return false;
        }
        if (!toFile.canWrite()) {
            FileUtil.createNewFile(toFile);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(toFile, true);
            fileOutputStream.write(buf);
            fileOutputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static boolean copyFile(File fromFile, File toFile) {
        if (fromFile == null || toFile == null || fromFile.equals(toFile)) {
            return false;
        }
        try {
            FileUtils.copyFile((File)fromFile, (File)toFile);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Problems copying " + fromFile + " -> " + toFile), (Throwable)e);
            return false;
        }
    }

    public static File ensureFileInDir(File fromFile, File toDir) {
        File newFile;
        boolean b;
        if (fromFile == null || toDir == null) {
            return null;
        }
        if (!toDir.isDirectory()) {
            toDir.mkdirs();
        }
        if (!(b = (newFile = FileUtil.getFileInDirectory(toDir, new File(fromFile.getName()))).canRead())) {
            b = FileUtil.copyFile(fromFile, newFile);
        }
        return b ? newFile : null;
    }

    public static File cleanDots(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        if (!"/".equals(File.separator)) {
            path = StringUtil.replaceString(path, File.separator, "/");
            path = UrlUtil.cleanDots(path);
            path = StringUtil.replaceString(path, "/", File.separator);
        } else {
            path = UrlUtil.cleanDots(path);
        }
        return new File(path);
    }

    public static File copyFileToDir(File fromFile, File toDir) {
        File newFile;
        boolean b;
        if (fromFile == null || toDir == null) {
            return null;
        }
        if (!toDir.isDirectory()) {
            toDir.mkdirs();
        }
        return (b = FileUtil.copyFile(fromFile, newFile = FileUtil.getFileInDirectory(toDir, new File(fromFile.getName())))) ? newFile : null;
    }

    public static File getFileInDirectory(File dir, File localFile) {
        if (dir == null) {
            return localFile;
        }
        if (localFile == null) {
            return null;
        }
        File fullFile = new File(dir, localFile.getPath());
        return FileUtil.cleanDots(fullFile);
    }

    public static boolean forceDelete(File file) {
        return FileUtil.forceDelete(file, 42, true);
    }

    public static boolean forceDelete(File file, int loops) {
        return FileUtil.forceDelete(file, loops, true);
    }

    private static boolean forceDelete(File file, int loops, boolean recurse) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        boolean bOK = recurse && file.isDirectory() ? FileUtil.deleteAll(file) : file.delete();
        int i = 1;
        while (!bOK) {
            boolean bMod = file.setReadable(true);
            bMod = file.setExecutable(true) && bMod;
            bMod = file.setWritable(true) && bMod;
            boolean bInterupt = !ThreadUtil.sleep(i * 42);
            boolean bl = bOK = recurse && file.isDirectory() ? FileUtil.deleteAll(file) : file.delete();
            if (!bInterupt && i++ <= loops) continue;
            log.warn((Object)("cannot force delete of file: " + file.getAbsolutePath() + " modifications=" + bMod));
            break;
        }
        return bOK;
    }

    public static File getCreateDirectory(String newDir) {
        File f = UrlUtil.urlToFile(newDir);
        if (f == null) {
            return null;
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            return null;
        }
        return f;
    }

    public static File cleanURL(File f) {
        String s = UrlUtil.fileToUrl(f, false);
        return UrlUtil.urlToFile(s);
    }

    public static boolean isDirectory(File f) {
        if (f == null || !f.exists()) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        try {
            File canonical = f.getCanonicalFile();
            return canonical.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isDirectory(String s) {
        return FileUtil.isDirectory(UrlUtil.urlToFile(s));
    }

    public static boolean isAbsoluteFile(File f) {
        String s = f == null ? null : f.getPath();
        return FileUtil.isAbsoluteFile(s);
    }

    public static boolean isAbsoluteFile(String f) {
        if (f == null) {
            return false;
        }
        if (f.startsWith(File.separator)) {
            return true;
        }
        File[] roots = File.listRoots();
        if (roots != null) {
            f = f.toLowerCase();
            for (File root : roots) {
                if (!f.startsWith(root.getPath().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        return file == null ? null : UrlUtil.extension(file.getName());
    }

    public static boolean createNewFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            return file.createNewFile();
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean equals(File file1, File file2) {
        return ContainerUtil.equals(file1, file2);
    }

    public static BufferedInputStream getBufferedInputStream(File file) {
        FileInputStream fis;
        if (file == null) {
            LogFactory.getLog(FileUtil.class).warn((Object)"extracting stream from null file");
            return null;
        }
        if (!file.canRead()) {
            LogFactory.getLog(FileUtil.class).warn((Object)("cannot access: " + file));
            return null;
        }
        if (file.isDirectory()) {
            LogFactory.getLog(FileUtil.class).warn((Object)("cannot extract stream from directory: " + file));
            return null;
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (IOException x) {
            LogFactory.getLog(FileUtil.class).warn((Object)("extracting stream from non-existing file: " + file.getAbsolutePath()), (Throwable)x);
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        return bis;
    }

    public static BufferedOutputStream getBufferedOutputStream(File file) {
        return FileUtil.getBufferedOutputStream(file, false);
    }

    public static BufferedOutputStream getBufferedOutputStream(File file, boolean append) {
        FileOutputStream fos;
        if (file == null) {
            return null;
        }
        if (!append || !file.exists()) {
            FileUtil.createNewFile(file);
        }
        try {
            fos = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException x) {
            return null;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        return bos;
    }

    @Deprecated
    public static boolean isWindows() {
        return PlatformUtil.isWindows();
    }

    protected static class ExpressionFileFilter
    implements FileFilter {
        private final String regExp;

        public ExpressionFileFilter(String _regExp) {
            this.regExp = StringUtil.simpleRegExptoRegExp(_regExp);
        }

        @Override
        public boolean accept(File checkFile) {
            return checkFile != null && StringUtil.matchesSimple(checkFile.getName(), this.regExp);
        }
    }

    protected static class DirectoryFileFilter
    implements FileFilter {
        protected DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File checkFile) {
            return checkFile != null && checkFile.isDirectory();
        }
    }

    public static class ExtensionFileFilter
    implements FileFilter {
        private Set<String> m_extension;

        protected ExtensionFileFilter(String fileExtension) {
            if (fileExtension != null) {
                VString list = StringUtil.tokenize(fileExtension, ",", false);
                this.m_extension = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    String st = list.get(i);
                    if (st.startsWith(".")) {
                        st = st.substring(1);
                    }
                    st = st.toLowerCase();
                    this.m_extension.add(st);
                }
            }
        }

        protected ExtensionFileFilter(VString fileExtensionVector) {
            if (fileExtensionVector != null) {
                this.m_extension = new HashSet<String>();
                for (String st : fileExtensionVector) {
                    if (st.startsWith(".")) {
                        st = st.substring(1);
                    }
                    st = st.toLowerCase();
                    this.m_extension.add(st);
                }
            }
        }

        @Override
        public boolean accept(File checkFile) {
            if (checkFile == null || !checkFile.isFile()) {
                return false;
            }
            if (this.m_extension == null) {
                return true;
            }
            String xt = UrlUtil.extension(checkFile.getPath());
            xt = xt == null ? "" : xt.toLowerCase();
            return this.m_extension.contains(xt);
        }
    }
}

