/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StringUtil;

public class UnitParser {
    public static final String UNIT_IN = "in";
    public static final String UNIT_CM = "cm";
    public static final String UNIT_MM = "mm";
    public static final String UNIT_PT = "pt";
    static final Set<String> unitKeys = new HashSet<String>();
    private int precision;

    public UnitParser() {
        this.setPrecision(4);
        this.getUnitKeys();
    }

    public void convertUnits(KElement element) {
        boolean elemSpan;
        JDFAttributeMap map = element.getAttributeMap_KElement();
        Iterator<String> keyIt = map.getKeyIterator();
        boolean bl = elemSpan = element instanceof JDFSpanBase && this.isUnit(element.getLocalName());
        while (keyIt.hasNext()) {
            JDFDate d;
            String newVal;
            String key = keyIt.next();
            if (!elemSpan && !this.isUnit(key)) continue;
            String val = map.get(key);
            if (!val.equals(newVal = this.extractUnits(val))) {
                element.setAttribute(key, newVal);
            }
            if (!(element instanceof JDFElement) || !AttributeInfo.EnumAttributeType.dateTime.equals((Object)((JDFElement)element).getAttributeInfo().getAttributeType(key)) || (d = JDFDate.createDate(val)) == null || val.equals(d.getDateTimeISO())) continue;
            element.setAttribute(key, d.getDateTimeISO());
        }
    }

    public boolean isUnit(String key) {
        return unitKeys.contains(key);
    }

    public void addUnitKey(String key) {
        unitKeys.add(key);
    }

    private void getUnitKeys() {
        if (unitKeys.isEmpty()) {
            unitKeys.add("BackOverfold");
            unitKeys.add("BleedBottom");
            unitKeys.add("BleedFace");
            unitKeys.add("BleedFoot");
            unitKeys.add("BleedHead");
            unitKeys.add("BleedLeft");
            unitKeys.add("BleedRight");
            unitKeys.add("BleedSpine");
            unitKeys.add("BoundingBox");
            unitKeys.add("Center");
            unitKeys.add("CutBox");
            unitKeys.add("Diameter");
            unitKeys.add("Dimension");
            unitKeys.add("Dimensions");
            unitKeys.add("Extent");
            unitKeys.add("FinishedDimensions");
            unitKeys.add("FoldingWidth");
            unitKeys.add("FoldingWidthBack");
            unitKeys.add("FrontOverfold");
            unitKeys.add("Height");
            unitKeys.add("Length");
            unitKeys.add("MillingDepth");
            unitKeys.add("Pitch");
            unitKeys.add("Position");
            unitKeys.add("Spine");
            unitKeys.add("TabExtensionDistance");
            unitKeys.add("Thickness");
            unitKeys.add("TrimBottom");
            unitKeys.add("TrimBox");
            unitKeys.add("TrimFace");
            unitKeys.add("TrimFoot");
            unitKeys.add("TrimHead");
            unitKeys.add("TrimLeft");
            unitKeys.add("TrimRight");
            unitKeys.add("TrimSize");
            unitKeys.add("TrimTop");
            unitKeys.add("Width");
        }
    }

    public double getFactor(String unit) {
        double factor = UNIT_MM.equals(unit = StringUtil.normalize(unit, true)) ? 2.834645669291339 : (UNIT_CM.equals(unit) ? 28.346456692913385 : (UNIT_IN.equals(unit) ? 72.0 : 1.0));
        return factor;
    }

    public String extractUnits(String key, String val) {
        if (key != null && unitKeys.contains(key)) {
            return this.extractUnits(val);
        }
        return val;
    }

    public String extractUnits(String val) {
        if (val == null) {
            return val;
        }
        VString v = StringUtil.tokenize(val, " ", false);
        VString keep = new VString(v);
        boolean oneGood = false;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            String tmp = v.get(i).toLowerCase();
            double factor = 1.0;
            if (tmp.endsWith(UNIT_MM)) {
                factor = 2.834645669291339;
                tmp = StringUtil.leftStr(tmp, -2);
            } else if (tmp.endsWith(UNIT_CM)) {
                factor = 28.346456692913385;
                tmp = StringUtil.leftStr(tmp, -2);
            } else if (tmp.endsWith(UNIT_IN)) {
                factor = 72.0;
                tmp = StringUtil.leftStr(tmp, -2);
            }
            if (factor > 0.0 && i > 0 && tmp == null && StringUtil.isNumber(keep.get(i - 1))) {
                if (i < 2 || !"\"".equals(v.get(i - 2))) {
                    tmp = v.get(i - 1);
                    v.setElementAt("\"", i - 1);
                } else {
                    oneGood = false;
                    break;
                }
            }
            if (!StringUtil.isNumber(tmp)) {
                factor = 0.0;
            }
            if (factor != 0.0) {
                if (factor == 1.0 && (tmp.startsWith("0") || tmp.startsWith("-0")) && StringUtil.isInteger(tmp)) {
                    v.setElementAt(tmp, i);
                    continue;
                }
                oneGood = true;
                double dbl = StringUtil.parseDouble(tmp, -1.0) * factor;
                v.setElementAt(new NumberFormatter().formatDouble(dbl, this.precision), i);
                continue;
            }
            oneGood = false;
            break;
        }
        if (oneGood) {
            val = StringUtil.setvString(v, " ", null, null);
            val = StringUtil.replaceString(val, "\" ", "");
        }
        return val;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String toString() {
        return "UnitParser [precision=" + this.precision + "]";
    }
}

