/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.RollingBackupFile;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.StorageHotFolder;
import org.cip4.jdflib.util.thread.MultiTaskQueue;

class StorageHotFolderListener
implements HotFolderListener {
    private final File storage;
    private File errorStorage;
    private File okStorage;
    final StorageHotFolder parent;
    protected final Log log;
    private final AtomicInteger nHotOK = new AtomicInteger();
    private final AtomicInteger nHotError = new AtomicInteger();
    private final AtomicInteger nQueued = new AtomicInteger();
    private int maxStore;
    HotFolderListener theListener;
    private int maxAux;

    StorageHotFolderListener(File storageDir, HotFolderListener hfListener, StorageHotFolder parent) {
        this.setMaxStore(42);
        this.errorStorage = null;
        this.okStorage = null;
        this.log = LogFactory.getLog(this.getClass());
        if (hfListener == null) {
            this.log.error((Object)"hfListner MUST NOT be null");
            throw new IllegalArgumentException("hfListner MUST NOT be null");
        }
        this.theListener = hfListener;
        this.storage = storageDir;
        this.parent = parent;
    }

    void setOKStorage(File ok) {
        this.okStorage = ok;
        if (ok != null) {
            this.okStorage.mkdirs();
            this.okStorage.setWritable(true);
            if (!this.okStorage.isDirectory()) {
                this.log.error((Object)("OK Directory is not a directory: " + this.okStorage.getAbsolutePath()));
            }
        }
    }

    void setErrorStorage(File error) {
        this.errorStorage = error;
        if (error != null) {
            this.errorStorage.mkdirs();
            this.errorStorage.setWritable(true);
            if (!this.errorStorage.isDirectory()) {
                this.log.error((Object)("Error Directory is not a directory: " + this.errorStorage.getAbsolutePath()));
            }
        }
    }

    @Override
    public boolean hotFile(File hotFile) {
        DelayedRunner runner = new DelayedRunner(hotFile);
        if (this.parent.isSynchronous()) {
            runner.run();
            return runner.ok;
        }
        MultiTaskQueue.getCreateQueue("DelayedRunner", this.parent.getMaxConcurrent()).queue(runner);
        return true;
    }

    void copyCompleted(File storedFile, boolean bOK) {
        File auxFile = FileUtil.getAuxDir(storedFile);
        if (bOK) {
            if (this.okStorage != null) {
                File okFile = FileUtil.getFileInDirectory(this.okStorage, new File(storedFile.getName()));
                RollingBackupFile roller = new RollingBackupFile(okFile, 10);
                roller.setWantExtension(true);
                roller.getNewFile();
                File copied = FileUtil.moveFileToDir(storedFile, this.okStorage);
                if (copied == null) {
                    this.handleBad(storedFile, true);
                } else {
                    this.log.info((Object)("Copied good file: " + storedFile.getName() + " to " + this.okStorage));
                    copied.setLastModified(System.currentTimeMillis());
                    if (auxFile != null) {
                        File auxbackup = FileUtil.getFileInDirectory(this.okStorage, new File(auxFile.getName()));
                        RollingBackupFile rollingBackupFile = new RollingBackupFile(auxbackup, 10);
                        rollingBackupFile.setWantExtension(true);
                        rollingBackupFile.getNewFile();
                        File movedAux = FileUtil.moveFileToDir(auxFile, this.okStorage);
                        if (movedAux != null) {
                            this.log.info((Object)("Copied good aux dir: " + auxFile.getName() + " to " + movedAux));
                        } else {
                            this.log.warn((Object)("Could not copy good aux dir: " + auxFile.getName() + " to " + this.okStorage));
                        }
                    }
                }
                this.cleanup(bOK);
            } else {
                boolean ok = FileUtil.forceDelete(storedFile);
                if (!ok) {
                    this.log.warn((Object)("failed to delete temporary file " + storedFile.getAbsolutePath()));
                }
                FileUtil.deleteAll(auxFile);
            }
        } else if (this.errorStorage != null) {
            File backup = FileUtil.getFileInDirectory(this.errorStorage, new File(storedFile.getName()));
            RollingBackupFile roller = new RollingBackupFile(backup, 10);
            roller.setWantExtension(true);
            roller.getNewFile();
            File copied = FileUtil.moveFileToDir(storedFile, this.errorStorage);
            if (copied == null) {
                this.handleBad(storedFile, false);
            } else {
                this.log.warn((Object)("Copied error file: " + storedFile.getName() + " to " + this.errorStorage));
                copied.setLastModified(System.currentTimeMillis());
                if (auxFile != null) {
                    File auxbackup = FileUtil.getFileInDirectory(this.errorStorage, new File(auxFile.getName()));
                    RollingBackupFile rollingBackupFile = new RollingBackupFile(auxbackup, 10);
                    rollingBackupFile.setWantExtension(true);
                    rollingBackupFile.getNewFile();
                    File movedAux = FileUtil.moveFileToDir(auxFile, this.errorStorage);
                    if (movedAux != null) {
                        this.log.info((Object)("Copied error aux dir: " + auxFile.getName() + " to " + movedAux));
                    } else {
                        this.log.warn((Object)("Could not copy error aux dir: " + auxFile.getName() + " to " + this.okStorage));
                    }
                }
            }
            this.cleanup(bOK);
        } else {
            boolean ok = FileUtil.forceDelete(storedFile);
            if (!ok) {
                this.log.warn((Object)("failed to delete temporary file " + storedFile.getAbsolutePath()));
            }
            FileUtil.deleteAll(auxFile);
        }
        File tmp = storedFile.getParentFile();
    }

    protected boolean handleBad(File storedFile, boolean bOK) {
        if (bOK) {
            this.log.warn((Object)("could not move ok " + storedFile + " to " + this.okStorage.getAbsolutePath()));
        } else {
            this.log.warn((Object)("could not move error " + storedFile + " to " + this.errorStorage.getAbsolutePath()));
        }
        File auxFile = FileUtil.getAuxDir(storedFile);
        FileUtil.deleteAll(auxFile);
        boolean bZapp = storedFile.delete();
        if (bZapp) {
            this.log.warn((Object)("utterly removed hot file: " + storedFile));
        } else {
            this.log.error((Object)("cannot delete hot file: " + storedFile));
        }
        return bZapp;
    }

    void cleanup(boolean bOK) {
        int check;
        int nHot = bOK ? this.nHotOK.incrementAndGet() : this.nHotError.incrementAndGet();
        if (nHot % (check = Math.max(1, this.maxAux / 4)) == 0 || Math.random() < 0.1) {
            FileSorter fs = new FileSorter(bOK ? this.okStorage : this.errorStorage);
            File[] list = fs.sortLastModified(true);
            ArrayList<File> vList = new ArrayList<File>();
            for (File f : list) {
                if (f.isDirectory()) continue;
                vList.add(f);
            }
            int i = 0;
            for (File hotFile : vList) {
                this.cleanupSingle(i++, hotFile);
            }
        }
    }

    void cleanupSingle(int i, File hotFile) {
        File aux;
        if (i > this.maxStore) {
            boolean ok = FileUtil.forceDelete(hotFile);
            if (ok) {
                this.log.debug((Object)("deleted temporary file " + hotFile.getAbsolutePath()));
            } else {
                this.log.warn((Object)("failed to delete temporary file " + hotFile.getAbsolutePath()));
            }
        }
        File file = aux = i > this.maxStore || i > this.maxAux ? FileUtil.getAuxDir(hotFile) : null;
        if (aux != null) {
            boolean ok = FileUtil.deleteAll(aux);
            if (ok) {
                this.log.info((Object)("deleted temporary aux directory " + aux.getAbsolutePath()));
            } else {
                this.log.warn((Object)("failed to delete temporary aux directory " + aux.getAbsolutePath()));
            }
        }
    }

    MyPair<File, File> getStoredFile(File hotFile) {
        if (hotFile == null) {
            this.log.error((Object)("invalid hot file: " + hotFile));
            return null;
        }
        String name = hotFile.getName();
        File tmpDir = this.getTmpDir();
        File newAbsoluteFile = FileUtil.getFileInDirectory(tmpDir, new File(name));
        boolean ok = false;
        for (int i = 0; !ok && i < this.parent.getRetry(); ++i) {
            ok = FileUtil.moveFile(hotFile, newAbsoluteFile);
            if (ok) continue;
            this.log.warn((Object)("retry " + i + " moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
            if (!hotFile.exists() || !hotFile.canRead()) {
                this.log.error((Object)("file disappeared while waiting: " + hotFile.getAbsolutePath()));
                return null;
            }
            if (ThreadUtil.sleep((i + 2) * this.parent.getStabilizeTime())) continue;
            this.log.error((Object)("Interrupted while waiting to move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
            return null;
        }
        if (ok) {
            this.log.info((Object)("moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        } else {
            this.log.error((Object)("cannot move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        }
        if (ok) {
            this.processAux(hotFile, tmpDir);
        }
        return ok ? new MyPair<File, File>(newAbsoluteFile, tmpDir) : null;
    }

    void processAux(File hotFile, File tmpDir) {
        File aux = FileUtil.getAuxDir(hotFile);
        if (aux != null) {
            File newaux = FileUtil.getFileInDirectory(tmpDir, new File(aux.getName()));
            FileUtil.moveFile(aux, newaux);
            this.log.info((Object)("moving aux file " + aux + " to " + tmpDir));
            int i = 1;
            while (true) {
                File moved;
                if ((moved = FileUtil.moveFileToDir(newaux, tmpDir)) != null) {
                    this.log.info((Object)("moved aux dir " + aux + " to " + moved));
                    break;
                }
                this.log.warn((Object)("could not move aux dir " + aux + " to " + tmpDir + " #" + i));
                if (i == 3 || !ThreadUtil.sleep(4242 * i)) break;
                ++i;
            }
        }
    }

    private synchronized File getTmpDir() {
        return FileUtil.getFileInDirectory(this.storage, new File("tmp." + this.nQueued.incrementAndGet()));
    }

    void setMaxStore(int maxStore) {
        this.maxStore = maxStore;
        this.maxAux = maxStore;
    }

    public void setMaxAux(int maxAuxDirs) {
        this.maxAux = maxAuxDirs;
    }

    public String toString() {
        return "StorageHotFolderListener [" + (this.storage != null ? "storage=" + this.storage + ", " : "") + (this.errorStorage != null ? "errorStorage=" + this.errorStorage + ", " : "") + (this.okStorage != null ? "okStorage=" + this.okStorage + ", " : "") + (this.parent != null ? "parent=" + this.parent + ", " : "") + "nHotOK=" + this.nHotOK + ", nHotError=" + this.nHotError + ", nQueued=" + this.nQueued + ", maxStore=" + this.maxStore + ", maxAux=" + this.maxAux + "]";
    }

    class DelayedRunner
    implements Runnable {
        boolean ok;
        final File hotFile;

        public DelayedRunner(File hotFile) {
            this.hotFile = hotFile;
            this.ok = false;
        }

        public String toString() {
            return "DelayedRunner [hotFile=" + this.hotFile + ", ok=" + this.ok + "]";
        }

        @Override
        public void run() {
            StorageHotFolderListener.this.log.info((Object)("processing hot file: " + this.hotFile));
            MyPair<File, File> storedFiles = StorageHotFolderListener.this.getStoredFile(this.hotFile);
            if (storedFiles == null) {
                StorageHotFolderListener.this.log.warn((Object)("snafu retrieving file " + this.hotFile.getAbsolutePath()));
                StorageHotFolderListener.this.copyCompleted(this.hotFile, false);
                this.ok = false;
            } else {
                try {
                    this.ok = StorageHotFolderListener.this.theListener.hotFile(storedFiles.getA());
                }
                catch (Throwable t) {
                    StorageHotFolderListener.this.log.error((Object)("Could not process " + this.hotFile), t);
                }
                StorageHotFolderListener.this.copyCompleted(storedFiles.getA(), this.ok);
                StorageHotFolderListener.this.log.info((Object)("deleting tmp file: " + storedFiles.getB()));
                boolean deleted = FileUtil.deleteAll(storedFiles.getB());
                if (!deleted) {
                    StorageHotFolderListener.this.log.warn((Object)("Problems deleting: " + storedFiles.getB()));
                }
            }
        }
    }
}

