/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.net;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.URLAuthenticator;
import org.cip4.jdflib.util.net.URLProxySelector;

public class ProxyUtil {
    private static final String USE_SYSTEM_PROXIES = "java.net.useSystemProxies";

    public static URI getHostURI(URL url) {
        URI uri;
        if (url == null) {
            return null;
        }
        try {
            int port = url.getPort();
            String str = url.getProtocol() + "://" + url.getHost();
            if (port > 0) {
                str = str + ":" + port;
            }
            uri = new URI(str);
        }
        catch (Exception x) {
            uri = null;
        }
        return uri;
    }

    public static void setUseSystemDefault(boolean use) {
        System.setProperty(USE_SYSTEM_PROXIES, "" + use);
    }

    public static boolean isUseSystemDefault(boolean use) {
        String def = System.getProperty(USE_SYSTEM_PROXIES);
        return StringUtil.parseBoolean(def, use);
    }

    public static List<Proxy> getProxiesWithLocal(URI uri) {
        ProxySelector selector = ProxySelector.getDefault();
        List<Proxy> list = selector.select(uri);
        if (!list.contains(Proxy.NO_PROXY)) {
            ArrayList<Proxy> list2 = new ArrayList<Proxy>();
            list2.add(Proxy.NO_PROXY);
            list2.addAll(list);
            return list2;
        }
        return list;
    }

    public static void setProxy(String proxy, int port, String user, String pw) {
        if (StringUtil.getNonEmpty(proxy = UrlUtil.removeProtocol(proxy)) == null) {
            URLProxySelector ups = new URLProxySelector(null);
            ProxySelector.setDefault(ups);
        } else {
            Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(StringUtil.token(proxy, 0, ":"), port));
            URLProxySelector ups = new URLProxySelector(p);
            ProxySelector.setDefault(ups);
            if (user != null) {
                Authenticator.setDefault(new URLAuthenticator(user, pw));
            }
        }
    }

    public static void setProxy(String proxy) {
        if (StringUtil.getNonEmpty(proxy) == null) {
            ProxyUtil.setProxy(null, 0, null, null);
        } else {
            proxy = UrlUtil.removeProtocol(proxy);
            int port = StringUtil.parseInt(StringUtil.token(StringUtil.token(proxy, 1, ":"), 0, "/"), -1);
            proxy = StringUtil.token(proxy, 0, ":");
            ProxyUtil.setProxy(proxy, port, null, null);
        }
    }
}

