/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkIntentResource;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFColorIntent;

public class WalkColorIntent
extends WalkIntentResource {
    final VString backAtts = new VString("Coatings ColorStandard Coverage", null);

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        this.evaluateColorsUsed(e);
        if (e.hasAttribute("NumColors")) {
            this.evaluateNumColors(e, trackElem);
        }
        for (String att : this.backAtts) {
            this.evaluateBackAttribute(e, att);
        }
        KElement ret = super.walk(e, trackElem);
        this.repartitionSide(e, trackElem);
        return ret;
    }

    private void repartitionSide(KElement e, KElement trackElem) {
        KElement cuBack = e.getElement("ColorsUsedBack");
        KElement cuFront = e.getElement("ColorsUsed");
        if (cuBack != null && cuFront != null) {
            VElement sepsBack;
            VElement sepsFront = cuFront.getChildElementVector("SeparationSpec", null);
            if (!sepsFront.isEqual(sepsBack = cuBack.getChildElementVector("SeparationSpec", null))) {
                if (cuFront.getElement("SeparationSpec") != null) {
                    JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                    ciFront.moveElement(cuFront, null);
                } else {
                    cuFront.deleteNode();
                }
                if (cuBack.getElement("SeparationSpec") != null) {
                    JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                    cuBack.renameElement("ColorsUsed", null);
                    ciBack.moveElement(cuBack, null);
                } else {
                    cuBack.deleteNode();
                }
            } else {
                cuBack.deleteNode();
            }
        } else if (cuBack == null && cuFront != null) {
            if (cuFront.getElement("SeparationSpec") != null) {
                JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                ciFront.moveElement(cuFront, null);
            } else {
                cuFront.deleteNode();
            }
        } else if (cuBack != null && cuFront == null) {
            if (cuBack.getElement("SeparationSpec") != null) {
                JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                ciBack.moveElement(cuBack, null);
            } else {
                cuBack.deleteNode();
            }
        }
        for (String att : this.backAtts) {
            String back = att + "Back";
            KElement coatBack = e.getElement(back);
            if (coatBack != null) {
                KElement coatings = e.getElement(att);
                if (coatings != null) {
                    JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                    ciFront.moveElement(coatings, null);
                }
                JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                ciBack.moveElement(e.getElement(back), null).renameElement(att, null);
            }
            this.evaluateBackAttribute(e, att);
        }
    }

    private void evaluateColorsUsed(KElement e) {
        JDFSeparationList sl = this.createSeparationList(e, "ColorsUsed");
        if (e.hasAttribute("ColorsUsedBack")) {
            if (sl != null) {
                sl = (JDFSeparationList)sl.deleteNode();
            }
            e.renameAttribute("ColorsUsedBack", "ColorsUsed", null, null);
            JDFSeparationList slBack = this.createSeparationList(e, "ColorsUsed");
            slBack.renameElement("ColorsUsedBack", null);
            if (sl != null) {
                e.moveElement(sl, slBack);
            }
        }
    }

    private void evaluateBackAttribute(KElement e, String front) {
        String back = front + "Back";
        if (e.hasAttribute(back)) {
            String frontVal = e.getAttribute(front, null, null);
            e.renameAttribute(back, front, null, null);
            KElement span = this.xjdfToJDFImpl.attributeToSpan(e, front);
            span.renameElement(back, null);
            e.setAttribute(front, frontVal);
        }
    }

    private void evaluateNumColors(KElement e, KElement trackElem) {
        JDFXYPair xyp = JDFXYPair.createXYPair(e.getAttribute("NumColors", null, null));
        e.removeAttribute("NumColors");
        if (xyp != null) {
            int back;
            int front = (int)xyp.getX();
            if (front == (back = (int)xyp.getY())) {
                trackElem.setAttribute("NumColors", front, (String)null);
            } else if (trackElem instanceof JDFColorIntent) {
                JDFColorIntent ci = (JDFColorIntent)trackElem;
                if (front > 0) {
                    JDFColorIntent cif = (JDFColorIntent)ci.getCreatePartition(new JDFAttributeMap("Side", "Front"), null);
                    cif.setNumColors(front);
                }
                if (back > 0) {
                    JDFColorIntent cib = (JDFColorIntent)ci.getCreatePartition(new JDFAttributeMap("Side", "Back"), null);
                    cib.setNumColors(back);
                }
            }
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && toCheck instanceof JDFColorIntent;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("ColorIntent", null);
    }
}

