/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Set;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDPart;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.StringUtil;

public class WalkXElement
extends BaseWalker {
    protected XJDFToJDFImpl xjdfToJDFImpl = null;

    public void setParent(XJDFToJDFImpl xjdftojdf) {
        this.xjdfToJDFImpl = xjdftojdf;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        this.cleanRefs(e, trackElem);
        if (ResourceHelper.isResourceElement(e) || IntentHelper.isIntentResource(e)) {
            trackElem.setAttributes(e);
        } else {
            String nodeName = this.getJDFName(e);
            KElement e2 = trackElem.appendElement(nodeName, e.getNamespaceURI());
            e2.setAttributes(e);
            e2.setText(e.getText());
            this.fixNamespace(e2);
            trackElem = e2;
        }
        this.xjdfToJDFImpl.convertUnits(trackElem);
        this.xjdfToJDFImpl.convertTilde(trackElem);
        if (trackElem instanceof JDFElement) {
            JDFAttributeMap map = trackElem.getAttributeMap_KElement();
            ((JDFElement)trackElem).init();
            trackElem.setAttributes(map);
            trackElem.getText();
        }
        this.updateAttributes(trackElem);
        return trackElem;
    }

    String getJDFName(KElement e) {
        if (JDFElement.isInXJDFNameSpaceStatic(e)) {
            return e.getLocalName();
        }
        return e.getNodeName();
    }

    protected void updateAttributes(KElement elem) {
        elem.renameAttribute("ExternalID", "ProductID");
        elem.renameAttribute("BinderySignatureIDs", "AssemblyIDs");
        elem.renameAttribute("BinderySignatureID", "AssemblyIDs");
    }

    protected String updateColor(String xjdfcolor) {
        if (StringUtil.isEmpty(xjdfcolor)) {
            return null;
        }
        Set values = JDFElement.EnumNamedColor.getEnumMap().keySet();
        String lower = xjdfcolor.toLowerCase();
        for (String value : values) {
            if (!value.toLowerCase().equals(lower)) continue;
            return value;
        }
        return null;
    }

    void moveFromSender(KElement parent, KElement sender) {
        if (sender != null) {
            parent.setAttributes(sender);
            sender.deleteNode();
        }
    }

    void moveCostCenterID(KElement elem) {
        if (elem.hasNonEmpty("CostCenterID")) {
            elem.appendElement("CostCenter").moveAttribute("CostCenterID", elem);
        }
    }

    private void fixNamespace(KElement e2) {
        if (JDFElement.isInXJDFNameSpaceStatic(e2)) {
            e2.setNamespaceURI(JDFElement.getSchemaURL(1, 1));
            if (StringUtil.getNonEmpty(e2.getPrefix()) != null) {
                e2.setPrefix(null);
            }
        }
    }

    protected String getRefName(String val) {
        String refName = val.endsWith("Refs") ? StringUtil.leftStr(val, -1) : val;
        return refName;
    }

    protected JDFSeparationList createSeparationList(KElement rPart, String elem) {
        String c = rPart.getAttribute(elem, null, null);
        JDFSeparationList sepList = null;
        if (c != null) {
            sepList = (JDFSeparationList)rPart.getCreateElement(elem);
            sepList.setSeparations(new VString(c, null));
            rPart.removeAttribute(elem);
        }
        return sepList;
    }

    protected JDFNode getNode(KElement xjdfRes, KElement jdfNode) {
        if (jdfNode instanceof JDFNode) {
            JDFAttributeMap partMap;
            JDFNode theNode = (JDFNode)jdfNode;
            JDFPart part = (JDFPart)xjdfRes.getElement("Part");
            JDFAttributeMap jDFAttributeMap = partMap = part == null ? null : part.getAttributeMap();
            if (partMap != null) {
                String types;
                JDFNode newNode;
                String productID = StringUtil.getNonEmpty(partMap.get("ProductPart"));
                if (productID != null && (newNode = (JDFNode)theNode.getChildWithAttribute("JDF", "ID", null, productID, 0, false)) != null) {
                    theNode = newNode;
                }
                if ((types = StringUtil.getNonEmpty(partMap.get("ProcessType"))) != null && theNode.isProduct()) {
                    JDFNode newNode2 = (JDFNode)theNode.getChildWithAttribute("JDF", "Types", null, types, 0, false);
                    if (newNode2 == null) {
                        newNode2 = theNode.addProcessGroup(new VString(types, null));
                    }
                    theNode = newNode2;
                }
            }
            return theNode;
        }
        return null;
    }

    protected void cleanRefs(KElement e, KElement trackElem) {
        JDFAttributeMap map = e.getAttributeMap();
        if (map == null) {
            return;
        }
        StringArray keys = map.getKeyList();
        if (keys != null) {
            for (String key : keys) {
                if (!key.endsWith("Ref") && !key.endsWith("Refs") || key.equals("rRef") || key.equals("ChildRefs")) continue;
                String value = map.get(key);
                this.cleanRef(e, trackElem, key, value);
            }
        }
    }

    protected void cleanRef(KElement e, KElement trackElem, String val, String values) {
        VString vValues = StringUtil.tokenize(values, null, false);
        for (String value : vValues) {
            IDPart p = this.xjdfToJDFImpl.idMap.get(value);
            String refName = this.getRefName(val);
            if (refName == null) continue;
            KElement refOld = trackElem != null ? trackElem.getElement(refName) : null;
            KElement ref = e.appendElement(refName);
            if (p == null) {
                ref.setAttribute("rRef", value);
            } else {
                ref.setAttribute("rRef", p.getID());
                VJDFAttributeMap vpartmap = p.getPartMap();
                if (!VJDFAttributeMap.isEmpty(vpartmap)) {
                    KElement part = ref.appendElement("Part");
                    part.setAttributes(vpartmap.get(0));
                    for (int j = 1; j < vpartmap.size(); ++j) {
                        JDFAttributeMap map = vpartmap.get(j);
                        for (String key : map.keySet()) {
                            part.appendAttribute(key, map.get(key), null, null, true);
                        }
                    }
                }
            }
            if (ref.isEqual(refOld)) {
                ref.deleteNode();
            }
            e.removeAttribute(val);
        }
    }

    protected void fixAuthor(KElement e) {
        String pID;
        String author = e.getAttribute("Author", null, null);
        if (StringUtil.getNonEmpty(author) != null) {
            e.removeAttribute("Author");
            JDFEmployee emp = (JDFEmployee)e.getCreateElement("Employee", null, 0);
            emp.setDescriptiveName(author);
        }
        if (StringUtil.getNonEmpty(pID = e.getAttribute("PersonalID", null, null)) != null) {
            e.removeAttribute("PersonalID");
            JDFEmployee emp = (JDFEmployee)e.getCreateElement("Employee", null, 0);
            emp.setPersonalID(pID);
        }
    }

    String getCoating(String coating) {
        if (coating == null) {
            return null;
        }
        if ("gloss".equalsIgnoreCase(coating)) {
            return "Glossy";
        }
        return coating;
    }
}

