/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDevCaps;
import org.cip4.jdflib.auto.JDFAutoMessageService;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.ifaces.IDeviceCapable;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.resource.devicecapability.JDFDevCaps;

public class JDFMessageService
extends JDFAutoMessageService
implements IDeviceCapable {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[5];

    public JDFMessageService(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFMessageService(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFMessageService(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFMessageService[  --> " + super.toString() + " ]";
    }

    public JDFMessage.EnumType getEnumType() {
        return JDFMessage.EnumType.getEnum(this.getAttribute("Type", null, null));
    }

    public void setType(JDFMessage.EnumType value) {
        String typeName = value == null ? null : value.getName();
        this.setType(typeName);
    }

    @Deprecated
    public boolean isCommand() {
        return this.getCommand();
    }

    @Deprecated
    public boolean isQuery() {
        return this.getQuery();
    }

    @Override
    public JDFDevCaps appendDevCaps() {
        JDFDevCaps dcs = super.appendDevCaps();
        dcs.setContext(JDFAutoDevCaps.EnumContext.JMF);
        return dcs;
    }

    @Override
    public final VString getNamePathVector() {
        VString vResult = new VString();
        Vector<JDFMessage.EnumFamily> families = this.getFamilies();
        if (families != null) {
            int siz = families.size();
            for (int i = 0; i < siz; ++i) {
                vResult.add(families.get(i).getName());
            }
        }
        return vResult;
    }

    public Vector<JDFMessage.EnumFamily> getFamilies() {
        Vector<JDFMessage.EnumFamily> fams = new Vector<JDFMessage.EnumFamily>();
        if (this.getCommand()) {
            fams.add(JDFMessage.EnumFamily.Command);
        }
        if (this.getSignal()) {
            fams.add(JDFMessage.EnumFamily.Signal);
        }
        if (this.getQuery()) {
            fams.add(JDFMessage.EnumFamily.Query);
        }
        if (this.getRegistration()) {
            fams.add(JDFMessage.EnumFamily.Registration);
        }
        if (this.getAcknowledge()) {
            fams.add(JDFMessage.EnumFamily.Acknowledge);
        }
        return fams.size() == 0 ? null : fams;
    }

    public void setFamilies(Vector<JDFMessage.EnumFamily> fams) {
        this.setCommand(false);
        this.setSignal(false);
        this.setQuery(false);
        this.setRegistration(false);
        this.setAcknowledge(false);
        this.setPersistent(false);
        if (fams == null) {
            return;
        }
        for (int i = 0; i < fams.size(); ++i) {
            try {
                JDFMessage.EnumFamily family = fams.elementAt(i);
                this.setFamily(family);
                if (!JDFMessage.EnumFamily.Signal.equals((Object)family)) continue;
                this.setPersistent(true);
                continue;
            }
            catch (JDFException jDFException) {
                // empty catch block
            }
        }
    }

    public void setFamily(JDFMessage.EnumFamily family) {
        if (family == null || JDFMessage.EnumFamily.Response.equals((Object)family)) {
            throw new JDFException("setFamily: illegal family:" + (Object)((Object)family));
        }
        this.setAttribute(family.getName(), true, null);
    }

    @Override
    public ICapabilityElement getTargetCap(String id) {
        KElement e = this.getTarget(id, null);
        if (e instanceof ICapabilityElement) {
            return (ICapabilityElement)((Object)e);
        }
        return null;
    }

    static {
        JDFMessageService.elemInfoTable[0] = new ElemInfoTable("IntegerState", 0x66661111L);
        JDFMessageService.elemInfoTable[1] = new ElemInfoTable("NameState", 0x66661111L);
        JDFMessageService.elemInfoTable[2] = new ElemInfoTable("StringState", 0x66661111L);
        JDFMessageService.elemInfoTable[3] = new ElemInfoTable("DurationState", 0x66661111L);
        JDFMessageService.elemInfoTable[4] = new ElemInfoTable("EnumerationState", 0x66661111L);
    }
}

