/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFDateTimeRange;
import org.cip4.jdflib.datatypes.JDFDateTimeRangeList;
import org.cip4.jdflib.datatypes.JDFDurationRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;

public class JDFDateTimeEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFDateTimeEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDateTimeEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDateTimeEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDateTimeEvaluation[  --> " + super.toString() + " ]";
    }

    public void setValueList(JDFDateTimeRangeList value) {
        this.setAttribute("ValueList", value.toString());
    }

    public JDFDateTimeRangeList getValueList() {
        try {
            String attribute = this.getAttribute("ValueList", null, null);
            return attribute == null ? null : new JDFDateTimeRangeList(attribute);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public void setValueDurationList(JDFDurationRangeList value) {
        this.setAttribute("ValueDurationList", value.toString());
    }

    public JDFDurationRangeList getValueDurationList() {
        try {
            return new JDFDurationRangeList(this.getAttribute("ValueDurationList"));
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    @Override
    public final boolean fitsValue(String value) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFDateTimeRangeList rangelist = null;
        try {
            rangelist = new JDFDateTimeRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        return this.fitsValueList(rangelist) && this.fitsValueDurationList(rangelist);
    }

    private final boolean fitsListType(String value) {
        JDFDateTimeRangeList rangelist;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFDateTimeRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            if (value.indexOf("P") != 0) {
                return false;
            }
            try {
                new JDFDate(value);
            }
            catch (JDFException e) {
                return false;
            }
            catch (DataFormatException e) {
                return false;
            }
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.RangeList) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.List)) {
            return rangelist.isList();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && rangelist.isUniqueOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return rangelist.isUniqueOrdered();
        }
        throw new JDFException("JDFDateTimeEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueList(JDFDateTimeRangeList rangelist) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        return this.getValueList().isPartOfRange(rangelist);
    }

    private final boolean fitsValueDurationList(JDFDateTimeRangeList rangelist) {
        if (this.hasAttribute("ValueDurationList")) {
            JDFDurationRangeList list = this.getValueDurationList();
            int siz = rangelist.size();
            for (int i = 0; i < siz; ++i) {
                JDFDateTimeRange range = (JDFDateTimeRange)rangelist.at(i);
                int duration = (int)((range.getRight().getTimeInMillis() - range.getLeft().getTimeInMillis()) / 1000L);
                JDFDuration d = new JDFDuration();
                d.setDuration(duration);
                if (list.inRange(d)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    static {
        JDFDateTimeEvaluation.atrInfoTable[0] = new AtrInfoTable("ValueDurationList", 0x33333333L, AttributeInfo.EnumAttributeType.DurationRangeList, null, null);
        JDFDateTimeEvaluation.atrInfoTable[1] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.DateTimeRangeList, null, null);
    }
}

