/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoColor;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFCMYKColor;
import org.cip4.jdflib.datatypes.JDFRGBColor;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFColor
extends JDFAutoColor {
    private static final long serialVersionUID = 1L;
    private static final StringArray CMYK = new StringArray("Cyan Magenta Yellow Black", null);

    public static List<String> getCMYKSeparations() {
        return new StringArray(CMYK);
    }

    public static List<String> getKCMYSeparations() {
        StringArray stringArray = new StringArray(CMYK);
        String b = stringArray.remove(3);
        stringArray.add(0, b);
        return stringArray;
    }

    public JDFColor(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFColor(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFColor(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFColor[  --> " + super.toString() + " ]";
    }

    public void set8BitNames(byte[] cName) {
        String rawName = StringUtil.setHexBinaryBytes(cName, -1);
        this.setRawName(rawName);
        try {
            this.setName(new String(cName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHTMLColor() {
        JDFRGBColor rgb = new JDFRGBColor(1, 1, 1);
        if (this.hasAttribute("sRGB")) {
            rgb = this.getsRGB();
        } else if (this.hasAttribute("CMYK")) {
            JDFCMYKColor cmyk = this.getCMYK();
            rgb = cmyk.getRGB();
        } else {
            JDFCMYKColor cmyk = new JDFCMYKColor();
            String name2 = this.getName();
            if (StringUtil.getNonEmpty(name2) == null) {
                name2 = this.getSeparation();
            }
            cmyk.setNamedColor(name2);
            rgb = cmyk.getRGB();
        }
        return rgb.getHTMLColor();
    }

    @Override
    public String getActualColorName() {
        String strName = this.getAttribute("ActualColorName", null, null);
        return strName == null ? this.getName() : strName;
    }

    public String get8BitName() {
        String strName = this.getAttribute("RawName", null, null);
        if (strName != null) {
            byte[] rawName = strName.getBytes();
            byte[] foundName = StringUtil.getHexBinaryBytes(rawName);
            return new String(foundName);
        }
        return this.getActualColorName();
    }

    public JDFFileSpec getColorProfile() {
        VElement v = this.getChildElementVector("FileSpec", null, null, true, 0, false);
        if (v != null) {
            int siz = v.size();
            for (int i = 0; i < siz; ++i) {
                JDFFileSpec res = (JDFFileSpec)v.elementAt(i);
                if (!res.hasAttribute("ResourceUsage") || !res.getResourceUsage().equals("ColorProfile")) continue;
                return res;
            }
        }
        return null;
    }

    public JDFFileSpec getCreateColorProfile() {
        JDFFileSpec res = this.getColorProfile();
        if (res == null) {
            res = this.appendColorProfile();
        }
        return res;
    }

    public JDFFileSpec appendColorProfile() {
        JDFFileSpec res = this.appendFileSpec();
        res.setResourceUsage("ColorProfile");
        return res;
    }

    public JDFFileSpec getTargetProfile() {
        VElement v = this.getChildElementVector("FileSpec", null, null, true, 0, false);
        int siz = v.size();
        for (int i = 0; i < siz; ++i) {
            JDFFileSpec res = (JDFFileSpec)v.elementAt(i);
            if (!res.hasAttribute("ResourceUsage") || !res.getResourceUsage().equals("TargetProfile")) continue;
            return res;
        }
        return null;
    }

    public JDFFileSpec getCreateTargetProfile() {
        JDFFileSpec res = this.getTargetProfile();
        if (res == null) {
            res = this.appendTargetProfile();
        }
        return res;
    }

    public JDFFileSpec appendTargetProfile() {
        JDFFileSpec res = this.appendFileSpec();
        res.setResourceUsage("TargetProfile");
        return res;
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean ignorePrivate, int max) {
        VString v = super.getInvalidAttributes(level, ignorePrivate, max);
        if (v.size() > max && max > 0 || v.contains("Name")) {
            return v;
        }
        KElement parent = this.getParentNode_KElement();
        if (parent instanceof JDFColorPool) {
            String colName = this.getName();
            String actualName = StringUtil.getNonEmpty(this.getActualColorName());
            String colRawName = this.getNonEmpty("RawName");
            for (JDFColor last = (JDFColor)this.getPreviousSiblingElement("Color", null); last != null; last = (JDFColor)last.getPreviousSiblingElement("Color", null)) {
                if (ContainerUtil.equals(colName, last.getName())) {
                    v.add("Name");
                }
                if (colRawName != null && ContainerUtil.equals(colRawName, last.getRawName())) {
                    v.add("RawName");
                }
                if (actualName == null || !ContainerUtil.equals(actualName, last.getActualColorName())) continue;
                v.add("ActualColorName");
            }
        }
        v.unify();
        return v;
    }
}

