/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.hotfolder.HotFolder;
import org.cip4.jdflib.util.thread.MultiTaskQueue;
import org.cip4.jdflib.util.thread.MyMutex;

class HotFolderRunner
extends Thread {
    final List<HotFolder> hotfolders = new ArrayList<HotFolder>();
    MyMutex mutex;
    private static Log log = LogFactory.getLog(HotFolderRunner.class);
    static final AtomicReference<HotFolderRunner> theRunner = new AtomicReference<Object>(null);
    int ran;
    final AtomicBoolean interrupt;
    private int maxConcurrent;

    public static void shutDown() {
        if (HotFolderRunner.getTherunner() != null) {
            log.info((Object)("shutdown hot folder runner: " + HotFolderRunner.getTherunner()));
            HotFolderRunner.getTherunner().quit();
        }
    }

    void quit() {
        String name = this.getName();
        log.info((Object)("Stopping hot folder runner: " + this));
        this.interrupt.set(true);
        ThreadUtil.notifyAll(this.mutex);
        MultiTaskQueue.shutDown(name);
        ThreadUtil.notifyAll(this);
        log.info((Object)("Finished stopping hot folder: " + this));
        theRunner.set(null);
    }

    public synchronized void add(HotFolder hotFolder) {
        this.hotfolders.remove(hotFolder);
        this.hotfolders.add(hotFolder);
        this.setMaxConcurrent(this.hotfolders.size());
        ThreadUtil.notifyAll(this.mutex);
    }

    public synchronized void remove(HotFolder hotFolder) {
        this.hotfolders.remove(hotFolder);
        log.info((Object)("removing " + hotFolder.getDir()));
        if (this.hotfolders.isEmpty()) {
            this.quit();
        }
    }

    public HotFolderRunner() {
        super("HotFolderRunner");
        this.setDaemon(true);
        log.info((Object)("Starting hotfolder runner thread " + this.getName()));
        this.interrupt = new AtomicBoolean(false);
        this.mutex = new MyMutex();
        this.ran = 0;
        this.setMaxConcurrent(1);
        this.start();
    }

    public void setMaxConcurrent(int maxConcurrent) {
        if (maxConcurrent < 1) {
            maxConcurrent = 1;
        } else if (maxConcurrent > 13) {
            maxConcurrent = 13;
        }
        if (maxConcurrent > this.maxConcurrent) {
            log.info((Object)("Setting maxConcurrent to " + maxConcurrent + " " + this.toString()));
            this.maxConcurrent = maxConcurrent;
        }
    }

    @Override
    public void run() {
        log.info((Object)("start of loop " + this));
        while (!this.interrupt.get()) {
            long t0 = System.currentTimeMillis();
            boolean mod = false;
            ArrayList<HotFolder> local = new ArrayList<HotFolder>(this.hotfolders);
            for (HotFolder folder : local) {
                try {
                    boolean bl = mod = folder.loop() || mod;
                    if (!this.interrupt.get()) continue;
                    log.info((Object)("interrupted in hotfolder loop " + folder));
                    break;
                }
                catch (Throwable t) {
                    log.error((Object)("snafu in " + folder), t);
                }
            }
            if (this.interrupt.get()) continue;
            long t1 = System.currentTimeMillis();
            int millis = mod ? 0 : HotFolder.getDefaultStabilizeTime() - (int)(t1 - t0);
            ThreadUtil.wait(this.mutex, Math.max(42, millis));
        }
        log.info((Object)("end of hot folder loop " + this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HotFolderRunner getCreateTherunner() {
        AtomicReference<HotFolderRunner> atomicReference = theRunner;
        synchronized (atomicReference) {
            if (theRunner.get() == null) {
                theRunner.set(new HotFolderRunner());
            }
            return theRunner.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HotFolderRunner getTherunner() {
        AtomicReference<HotFolderRunner> atomicReference = theRunner;
        synchronized (atomicReference) {
            HotFolderRunner hotFolderRunner = theRunner.get();
            return hotFolderRunner == null || hotFolderRunner.interrupt.get() ? null : hotFolderRunner;
        }
    }

    @Override
    public String toString() {
        return "HotFolderRunner [hotfolders[" + this.hotfolders.size() + "] " + (this.interrupt.get() ? "interrupt" : "") + ", maxConcurrent=" + this.maxConcurrent + "]";
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    boolean runFile(HotFolder.HotFileRunner runner) {
        ++this.ran;
        if (this.getMaxConcurrent() != 1) {
            MultiTaskQueue taskQueue = MultiTaskQueue.getCreateQueue(this.getName(), this.getMaxConcurrent());
            if (taskQueue.size() > 2 * this.getMaxConcurrent()) {
                log.warn((Object)("queueing into full " + runner.shortString() + "-->" + taskQueue.shortString()));
            } else {
                log.info((Object)("queueing " + runner.shortString() + "-->" + taskQueue.shortString()));
            }
            return taskQueue.queue(runner);
        }
        log.info((Object)("running concurrent " + runner));
        runner.run();
        return true;
    }

    public boolean contains(HotFolder o) {
        return this.hotfolders.contains(o);
    }
}

