/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.net.IPollHandler;

public class PollHotFolderListener
implements HotFolderListener {
    private final Log log;
    IPollHandler theHandler;

    public PollHotFolderListener(IPollHandler theHandler) {
        this.theHandler = theHandler;
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public boolean hotFile(File hotFile) {
        UrlPart result;
        try {
            result = new UrlPart(hotFile);
        }
        catch (IOException e) {
            this.log.error((Object)"Exception processing hotfile", (Throwable)e);
            result = null;
        }
        IPollHandler.PollResult det = this.theHandler.handlePoll(result, this.getUrl(hotFile));
        return IPollHandler.PollResult.idle.equals((Object)det) || IPollHandler.PollResult.success.equals((Object)det);
    }

    protected String getUrl(File hotFile) {
        File parentFile = hotFile == null ? null : hotFile.getParentFile();
        parentFile = parentFile == null ? null : parentFile.getParentFile();
        return parentFile == null ? "HotFolderSnafu" : parentFile.getName();
    }
}

