/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFDateTimeRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFDateTimeRangeList
extends JDFRangeList {
    public JDFDateTimeRangeList() {
    }

    public JDFDateTimeRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public static JDFDateTimeRangeList createDateTimeRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFDateTimeRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFDateTimeRangeList(JDFDateTimeRangeList rl) {
        this.rangeList = new ArrayList(rl.rangeList);
    }

    public boolean inRange(JDFDate x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFDateTimeRange r = (JDFDateTimeRange)this.rangeList.get(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFDateTimeRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        StringArray vs = StringArray.getVString(zappedWS, " \t");
        this.rangeList.clear();
        for (String str : vs) {
            try {
                JDFDateTimeRange dr = new JDFDateTimeRange(str);
                this.rangeList.add(dr);
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFDateTimeRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFDateTimeRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFDateTimeRange r) {
        this.rangeList.add(r);
    }

    public void append(JDFDate xMin, JDFDate xMax) {
        this.append(new JDFDateTimeRange(xMin, xMax));
    }

    public void append(JDFDate x) {
        this.append(new JDFDateTimeRange(x, x));
    }

    @Override
    public boolean isOrdered() {
        int n1;
        ArrayList<JDFDate> al = this.getOrderedArray();
        int n = n1 = al == null ? 0 : al.size() - 1;
        if (n1 == 0) {
            return true;
        }
        JDFDate first = al.get(0);
        JDFDate last = al.get(n1);
        for (int j = 0; j < n1; ++j) {
            JDFDate value = al.get(j);
            JDFDate nextvalue = al.get(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isEarlier(last) && (value.isEarlier(nextvalue) || value.equals(nextvalue)) || first.isLater(last) && (value.isLater(nextvalue) || value.equals(nextvalue))) continue;
            return false;
        }
        return true;
    }

    protected ArrayList<JDFDate> getOrderedArray() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return null;
        }
        ArrayList<JDFDate> al = new ArrayList<JDFDate>();
        for (int i = 0; i < siz; ++i) {
            JDFDateTimeRange r = (JDFDateTimeRange)this.rangeList.get(i);
            al.add(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            al.add(r.getRight());
        }
        return al;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFDate last;
        int n;
        ArrayList<JDFDate> v = this.getOrderedArray();
        int n2 = n = v == null ? 0 : v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDate first = v.get(0);
        if (first.equals(last = v.get(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFDate value = v.get(j);
            JDFDate nextvalue = v.get(j + 1);
            if (first.isEarlier(last) && value.isEarlier(nextvalue) || first.isLater(last) && value.isLater(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

