/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.LinkRefFinder;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.resource.process.JDFComChannel;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class RemoveEmpty
extends BaseElementWalker {
    boolean zappElements;
    final JDFPart part;
    final Collection<String> ignoreElements = new HashSet<String>();
    LinkRefFinder rf;

    public RemoveEmpty() {
        super(new BaseWalkerFactory());
        this.addIgnoreElement("Position");
        this.zappElements = true;
        this.part = (JDFPart)new JDFDoc("Part").getRoot();
        this.part.appendElement("foo");
        new BaseWalker(this.getFactory());
        this.rf = null;
    }

    public void addIgnoreElement(String name) {
        this.ignoreElements.add(name);
    }

    public void removEmpty(JDFNode n) {
        UnLinkFinder unLinkFinder = new UnLinkFinder();
        unLinkFinder.eraseUnlinked(n);
        if (this.zappElements) {
            this.rf = new LinkRefFinder(true, true);
            this.rf.getMap(n);
        }
        this.removEmptyElement(n);
        unLinkFinder.eraseUnlinked(n);
    }

    public void removEmptyElement(KElement e) {
        this.walkTreeKidsFirst(e);
    }

    public void removEmptyAttributes(KElement e) {
        boolean keep = this.zappElements;
        this.zappElements = false;
        this.walkTreeKidsFirst(e);
        this.zappElements = keep;
    }

    public void setZappElements(boolean zappElements) {
        this.zappElements = zappElements;
    }

    public class WalkMessage
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            String localName = toCheck.getLocalName();
            return localName.startsWith("Response") || localName.startsWith("Query") || localName.startsWith("Command");
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            return e1;
        }
    }

    public class WalkComChannel
    extends WalkResource {
        @Override
        protected StringArray getDummyAttributes() {
            StringArray v = super.getDummyAttributes();
            v.add("ChannelType");
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComChannel;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("ComChannel", null);
        }
    }

    public class WalkResource
    extends WalkElement {
        @Override
        protected StringArray getDummyAttributes() {
            StringArray v = super.getDummyAttributes();
            v.add("Class");
            v.add("Status");
            v.add("PartIDKeys");
            v.add("PartUsage");
            VString partAttribs = RemoveEmpty.this.part.knownAttributes();
            JDFElement foo = (JDFElement)RemoveEmpty.this.part.getElement("foo");
            VString fooAttribs = foo.knownAttributes();
            partAttribs.removeStrings(fooAttribs, 0);
            v.appendUnique(partAttribs);
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResource;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            boolean hasGood = false;
            if (RemoveEmpty.this.zappElements) {
                hasGood = this.walkAttributes(e1);
                JDFResource r = (JDFResource)e1;
                if (!hasGood) {
                    hasGood = this.checkRef(r);
                }
                if (!hasGood) {
                    hasGood = this.checkLinks(r);
                }
            }
            return hasGood ? e1 : super.walk(e1, trackElem);
        }

        boolean checkLinks(JDFResource r) {
            boolean hasGood = false;
            Collection<JDFResourceLink> links = this.getLinks(r);
            if (links != null) {
                for (JDFResourceLink rl : links) {
                    RemoveEmpty.this.removEmptyElement(rl);
                    if (rl.getAmountPool() != null || rl.getPart(0) != null) {
                        hasGood = true;
                        break;
                    }
                    JDFAttributeMap map = rl.getAttributeMap();
                    map.removeKeys(super.getDummyAttributes());
                    map.remove("rRef");
                    map.remove("Usage");
                    if (map.isEmpty()) continue;
                    hasGood = true;
                    break;
                }
            }
            return hasGood;
        }

        boolean checkRef(JDFResource r) {
            boolean hasGood = false;
            Collection<JDFRefElement> v = this.getRefs(r);
            if (v != null) {
                JDFAttributeMap myMap = r.getPartMap();
                for (JDFRefElement e : v) {
                    JDFAttributeMap m = e.getPartMap();
                    if (!myMap.overlapMap(m)) continue;
                    hasGood = true;
                    break;
                }
            }
            return hasGood;
        }

        Collection<JDFRefElement> getRefs(JDFResource r) {
            List v;
            List list = v = RemoveEmpty.this.rf == null ? null : (List)RemoveEmpty.this.rf.getTheMap().get(r.getID());
            if (v != null) {
                ArrayList<JDFRefElement> vr = new ArrayList<JDFRefElement>();
                for (KElement e : v) {
                    if (!(e instanceof JDFRefElement)) continue;
                    vr.add((JDFRefElement)e);
                }
                return vr.isEmpty() ? null : vr;
            }
            return null;
        }

        Collection<JDFResourceLink> getLinks(JDFResource r) {
            List v;
            List list = v = RemoveEmpty.this.rf == null ? null : (List)RemoveEmpty.this.rf.getTheMap().get(r.getID());
            if (v != null) {
                ArrayList<JDFResourceLink> vr = new ArrayList<JDFResourceLink>();
                for (KElement e : v) {
                    if (!(e instanceof JDFResourceLink)) continue;
                    vr.add((JDFResourceLink)e);
                }
                return vr.isEmpty() ? null : vr;
            }
            return null;
        }
    }

    public class WalkIgnore
    extends WalkElement {
        public WalkIgnore() {
            this.depth += 3;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return RemoveEmpty.this.ignoreElements.contains(toCheck.getLocalName());
        }
    }

    public class WalkResourceAudit
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFResourceAudit ra = (JDFResourceAudit)e;
            if (ra.getNewLink() == null) {
                ra.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("ResourceAudit", null);
        }
    }

    public class WalkComment
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String text = StringUtil.getNonEmpty(e.getText());
            if (text == null) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComment;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("Comment", null);
        }
    }

    public class WalkGeneralID
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String idUsage = ((JDFGeneralID)e).getIDUsage();
            String idValue = ((JDFGeneralID)e).getIDValue();
            if (StringUtil.getNonEmpty(idUsage) == null || StringUtil.getNonEmpty(idValue) == null) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFGeneralID;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("GeneralID", null);
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(RemoveEmpty.this.getFactory());
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            boolean hasAny;
            boolean hasreq = RemoveEmpty.this.zappElements ? this.hasRequiredChild(e1) : true;
            boolean b = this.walkAttributes(e1);
            boolean bl = hasAny = hasreq && (b || this.hasChild(e1));
            if (!hasAny) {
                e1.deleteNode();
                return null;
            }
            return e1;
        }

        protected boolean hasChild(KElement e1) {
            return e1.getFirstChildElement() != null || e1.getText() != null || e1.getXMLComment(0) != null;
        }

        protected boolean hasRequiredChild(KElement e1) {
            return true;
        }

        protected boolean walkAttributes(KElement e1) {
            JDFAttributeMap map = e1.getAttributeMap_KElement();
            Set allKeys = map.keySet();
            boolean hasGood = !RemoveEmpty.this.zappElements;
            StringArray dummy = RemoveEmpty.this.zappElements ? this.getDummyAttributes() : null;
            for (String key : allKeys) {
                if (StringUtil.isEmpty(map.get(key))) {
                    e1.removeAttribute(key);
                    continue;
                }
                if (hasGood || dummy.contains(key)) continue;
                hasGood = true;
            }
            return hasGood;
        }

        protected StringArray getDummyAttributes() {
            StringArray dummy = new StringArray();
            dummy.add("ID");
            dummy.add("AgentName");
            dummy.add("AgentVersion");
            return dummy;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }
}

