/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFStripCellParams;
import org.cip4.jdflib.util.StringUtil;

public class WalkPosition
extends WalkXElement {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFPosition;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        JDFStrippingParams stripParams = this.ensurePartition(e, trackElem);
        if (stripParams == null) {
            return null;
        }
        this.doCells(e, stripParams);
        KElement walk = super.walk(e, stripParams);
        this.moveBSRef(e, stripParams);
        return walk;
    }

    JDFStrippingParams ensurePartition(KElement e, KElement trackElem) {
        String bsid;
        JDFStrippingParams ret;
        JDFStrippingParams jDFStrippingParams = ret = trackElem instanceof JDFStrippingParams ? (JDFStrippingParams)trackElem : null;
        if (ret != null && (bsid = e.getNonEmpty("BinderySignatureID")) != null && ret.getBinderySignatureName().isEmpty()) {
            ret = (JDFStrippingParams)ret.getCreatePartition(JDFResource.EnumPartIDKey.BinderySignatureName, bsid, null);
        }
        return ret;
    }

    private void moveBSRef(KElement e, JDFStrippingParams stripParams) {
        if (stripParams != null) {
            String bsID;
            KElement bsRef = e.getElement("BinderySignatureRef");
            if (bsRef != null) {
                stripParams.moveElement(bsRef, null);
            } else if (stripParams.getElement_KElement("BinderySignatureRef", null, 0) == null && (bsID = e.getNonEmpty("BinderySignatureID")) != null) {
                e.removeAttribute("BinderySignatureID");
                SetHelper bsSet = this.xjdfToJDFImpl.xjdf.getSet("BinderySignature", 0);
                if (bsSet != null) {
                    bsSet.getPartition(new JDFAttributeMap("BinderySignatureID", bsID));
                    String id = bsSet.ensureID();
                    JDFRefElement re = (JDFRefElement)stripParams.appendElement("BinderySignatureRef");
                    re.setrRef(id);
                    re.setPartMap(new JDFAttributeMap("BinderySignatureName", bsID));
                }
                stripParams.appendAssemblyIDs(bsID, true);
            }
        }
    }

    private void doCells(KElement e, JDFStrippingParams stripParams) {
        if (stripParams != null && stripParams.getStripCellParams() == null) {
            String id = StringUtil.getNonEmpty(e.getAttribute("BinderySignatureRef", null, null));
            XJDFHelper xh = XJDFHelper.getHelper(e);
            if (xh != null) {
                VElement vSigCell;
                ResourceHelper bsh = xh.getPartition(id);
                VElement vElement = vSigCell = bsh == null ? null : bsh.getResource().getChildElementVector("SignatureCell", null);
                if (vSigCell != null) {
                    for (KElement sigCell : vSigCell) {
                        this.doCell(stripParams, sigCell);
                    }
                }
            }
        }
    }

    void doCell(JDFStrippingParams stripParams, KElement sigCell) {
        JDFStripCellParams stripCell = stripParams.appendStripCellParams();
        VString stripCellKnown = stripCell.knownAttributes();
        JDFAttributeMap sigCelMap = sigCell.getAttributeMap();
        sigCelMap.reduceMap(stripCellKnown);
        if (!sigCelMap.isEmpty()) {
            stripCell.setAttributes(sigCelMap);
            sigCell.removeAttributes(sigCelMap.keySet());
        }
    }

    @Override
    protected void updateAttributes(KElement elem) {
        elem.removeAttribute("BinderySignatureID");
        elem.removeAttribute("ID");
        super.updateAttributes(elem);
    }
}

