/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFNumberRangeList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFShapeRange;
import org.cip4.jdflib.datatypes.JDFShapeRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;

public class JDFShapeState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[14];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFShapeState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFShapeState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFShapeState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFShapeState[  --> " + super.toString() + " ]";
    }

    public void setCurrentValue(JDFShape value) {
        this.setAttribute("CurrentValue", value.toString(), null);
    }

    public JDFShape getCurrentValue() {
        try {
            return new JDFShape(this.getAttribute("CurrentValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getCurrentValue: Attribute CURRENTVALUE is not capable to create JDFShape");
        }
    }

    public void setDefaultValue(JDFShape value) {
        this.setAttribute("DefaultValue", value.toString(), null);
    }

    public JDFShape getDefaultValue() {
        try {
            return new JDFShape(this.getAttribute("DefaultValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getDefaultValue: Attribute DEFAULTVALUE is not capable to create JDFShape");
        }
    }

    public void setAllowedValueList(JDFShapeRangeList value) {
        this.setAttribute("AllowedValueList", value.toString());
    }

    public JDFShapeRangeList getAllowedValueList() {
        try {
            String attribute = this.getAttribute("AllowedValueList", null, null);
            return attribute == null ? null : new JDFShapeRangeList(attribute);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getAllowedValueList: Attribute ALLOWEDVALUELIST is not capable to create JDFShapeRangeList");
        }
    }

    public void setPresentValueList(JDFShapeRangeList value) {
        this.setAttribute("PresentValueList", value.toString(), null);
    }

    public JDFShapeRangeList getPresentValueList() {
        if (this.hasAttribute("PresentValueList")) {
            try {
                return new JDFShapeRangeList(this.getAttribute("PresentValueList"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFShapeState.getPresentValueList: Attribute PRESENTVALUELIST is not capable to create JDFShapeRangeList");
            }
        }
        return this.getAllowedValueList();
    }

    public void setAllowedX(JDFNumberRangeList value) {
        this.setAttribute("AllowedX", value.toString(), null);
    }

    public JDFNumberRangeList getAllowedX() {
        try {
            return new JDFNumberRangeList(this.getAttribute("AllowedX"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getAllowedX: Attribute ALLOWEDX is not capable to create JDFNumberRangeList");
        }
    }

    public void setPresentX(JDFNumberRangeList value) {
        this.setAttribute("PresentX", value.toString(), null);
    }

    public JDFNumberRangeList getPresentX() {
        if (this.hasAttribute("PresentX")) {
            try {
                return new JDFNumberRangeList(this.getAttribute("PresentX"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFShapeState.getPresentX: Attribute PRESENTX is not capable to create JDFNumberRangeList");
            }
        }
        return this.getAllowedX();
    }

    public void setAllowedY(JDFNumberRangeList value) {
        this.setAttribute("AllowedY", value.toString(), null);
    }

    public JDFNumberRangeList getAllowedY() {
        try {
            return new JDFNumberRangeList(this.getAttribute("AllowedY"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getAllowedY: Attribute ALLOWEDY is not capable to create JDFNumberRangeList");
        }
    }

    public void setPresentY(JDFNumberRangeList value) {
        this.setAttribute("PresentY", value.toString(), null);
    }

    public JDFNumberRangeList getPresentY() {
        if (this.hasAttribute("PresentY")) {
            try {
                return new JDFNumberRangeList(this.getAttribute("PresentY"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFShapeState.getPresentY: Attribute PRESENTY is not capable to create JDFNumberRangeList");
            }
        }
        return this.getAllowedY();
    }

    public void setAllowedZ(JDFNumberRangeList value) {
        this.setAttribute("AllowedZ", value.toString(), null);
    }

    public JDFNumberRangeList getAllowedZ() {
        try {
            return new JDFNumberRangeList(this.getAttribute("AllowedZ"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getAllowedZ: Attribute ALLOWEDZ is not capable to create JDFNumberRangeList");
        }
    }

    public void setPresentZ(JDFNumberRangeList value) {
        this.setAttribute("PresentZ", value.toString(), null);
    }

    public JDFNumberRangeList getPresentZ() {
        if (this.hasAttribute("PresentZ")) {
            try {
                return new JDFNumberRangeList(this.getAttribute("PresentZ"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFShapeState.getPresentZ: Attribute PRESENTZ is not capable to create JDFNumberRangeList");
            }
        }
        return this.getAllowedZ();
    }

    public void setAllowedValueMax(JDFShape value) {
        this.setAttribute("AllowedValueMax", value.toString(), null);
    }

    public JDFShape getAllowedValueMax() {
        try {
            return new JDFShape(this.getAttribute("AllowedValueMax"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.getAllowedValueMax: Attribute ALLOWEDVALUEMAX is not capable to create JDFShape");
        }
    }

    public void setPresentValueMax(JDFShape value) {
        this.setAttribute("PresentValueMax", value.toString(), null);
    }

    public JDFShape getPresentValueMax() {
        if (this.hasAttribute("PresentValueMax")) {
            try {
                return new JDFShape(this.getAttribute("PresentValueMax"));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFShapeState.getPresentValueMax: Attribute PRESENTVALUEMAX is not capable to create JDFShape");
            }
        }
        return this.getAllowedValueMax();
    }

    public void setAllowedValueMin(JDFShape value) {
        this.setAttribute("AllowedValueMin", value.toString(), null);
    }

    public JDFShape getAllowedValueMin() {
        try {
            return new JDFShape(this.getAttribute("AllowedValueMin"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeState.setAllowedValueMin: Attribute ALLOWEDVALUEMIN is not capable to create JDFShape");
        }
    }

    public void setPresentValueMin(JDFShape value) {
        this.setAttribute("PresentValueMin", value.toString(), null);
    }

    public JDFShape getPresentValueMin() {
        if (this.hasAttribute("PresentValueMin")) {
            try {
                return new JDFShape(this.getAttribute("PresentValueMin"));
            }
            catch (DataFormatException dfe) {
                throw new JDFException("JDFShapeState.getPresentValueMin: Attribute PRESENTVALUEMIN is not capable to create JDFShape");
            }
        }
        return this.getAllowedValueMin();
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFShapeRangeList list;
        JDFShape rect;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        try {
            rect = new JDFShape(value);
        }
        catch (DataFormatException x) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFShapeRangeList();
            }
            list.append(rect);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFShapeRangeList();
            }
            list.append(rect);
            this.setPresentValueList(list);
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFShapeRangeList rangelist = null;
        try {
            rangelist = new JDFShapeRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        return this.fitsValueList(rangelist, testlists) && this.fitsXYZ(rangelist, testlists);
    }

    private final boolean fitsValueList(JDFShapeRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFShapeRangeList list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFShapeRange range = (JDFShapeRange)rangelist.at(i);
            if (list.isPartOfRange(range)) continue;
            return false;
        }
        return true;
    }

    private boolean fitsXYZ(JDFShapeRangeList rangelist, JDFBaseDataTypes.EnumFitsValue xyzlist) {
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFNumberRangeList z;
            JDFNumberRangeList y;
            JDFNumberRangeList x;
            JDFShapeRange range = (JDFShapeRange)rangelist.at(i);
            JDFShape left = range.getLeft();
            JDFShape right = range.getRight();
            double leftX = left.getY();
            double rightX = right.getY();
            JDFNumberRange rangeX = new JDFNumberRange(leftX, rightX);
            double leftY = left.getX();
            double rightY = right.getX();
            JDFNumberRange rangeY = new JDFNumberRange(leftY, rightY);
            double leftZ = left.getZ();
            double rightZ = right.getZ();
            JDFNumberRange rangeZ = new JDFNumberRange(leftZ, rightZ);
            if (xyzlist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed)) {
                x = this.getAllowedX();
                y = this.getAllowedY();
                z = this.getAllowedZ();
            } else {
                x = this.getPresentX();
                y = this.getPresentY();
                z = this.getPresentZ();
            }
            boolean bFit = true;
            if (x.size() != 0) {
                bFit = x.isPartOfRange(rangeX);
            }
            if (!bFit) {
                return false;
            }
            if (y.size() != 0) {
                bFit = y.isPartOfRange(rangeY);
            }
            if (!bFit) {
                return false;
            }
            if (z.size() != 0) {
                bFit = z.isPartOfRange(rangeZ);
            }
            if (bFit) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteList(JDFShapeRangeList value, JDFShapeRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFShapeRangeList valueList = new JDFShapeRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFShapeRangeList value, JDFShapeRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFShapeRangeList value, JDFShapeRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.RectangleEvaluation;
    }

    static {
        JDFShapeState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333331L, AttributeInfo.EnumAttributeType.ShapeRangeList, null, null);
        JDFShapeState.atrInfoTable[1] = new AtrInfoTable("AllowedValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFShapeState.atrInfoTable[2] = new AtrInfoTable("AllowedValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFShapeState.atrInfoTable[3] = new AtrInfoTable("AllowedX", 0x33333311L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeState.atrInfoTable[4] = new AtrInfoTable("AllowedY", 0x33333311L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeState.atrInfoTable[5] = new AtrInfoTable("AllowedZ", 0x33333311L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeState.atrInfoTable[6] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFShapeState.atrInfoTable[7] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFShapeState.atrInfoTable[8] = new AtrInfoTable("PresentValueList", 0x33333311L, AttributeInfo.EnumAttributeType.ShapeRangeList, null, null);
        JDFShapeState.atrInfoTable[9] = new AtrInfoTable("PresentValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFShapeState.atrInfoTable[10] = new AtrInfoTable("PresentValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFShapeState.atrInfoTable[11] = new AtrInfoTable("PresentX", 0x33333311L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeState.atrInfoTable[12] = new AtrInfoTable("PresentY", 0x33333311L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeState.atrInfoTable[13] = new AtrInfoTable("PresentZ", 0x33333311L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFShapeState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

