/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoObjectResolution;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.MyPair;
import org.w3c.dom.DOMException;

public class JDFObjectResolution
extends JDFAutoObjectResolution
implements IMatches {
    private static final long serialVersionUID = 1L;

    public JDFObjectResolution(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFObjectResolution(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFObjectResolution(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public String addObjectTag(String newTag) {
        return this.appendAttribute("ObjectTags", newTag, null, " ", true);
    }

    public String addSourceObject(JDFAutoObjectResolution.EnumSourceObjects newObject) {
        String newTag = newObject == null ? null : newObject.getName();
        return this.appendAttribute("SourceObjects", newTag, null, " ", true);
    }

    public void setResolution(double resolution) {
        this.setResolution(new JDFXYPair(resolution, resolution));
    }

    @Override
    public String toString() {
        return "JDFObjectResolution[  --> " + super.toString() + " ]";
    }

    public boolean matches(JDFAutoObjectResolution.EnumSourceObjects sourceObject, String objectTag) {
        MyPair<JDFAutoObjectResolution.EnumSourceObjects, String> subset = new MyPair<JDFAutoObjectResolution.EnumSourceObjects, String>(sourceObject, objectTag);
        return this.matches(subset);
    }

    @Override
    public boolean matches(Object subset) {
        if (subset == null) {
            return true;
        }
        if (subset instanceof String) {
            VString objectTags = this.getObjectTags();
            return objectTags == null || objectTags.size() == 0 || objectTags.contains(subset);
        }
        if (subset instanceof JDFAutoObjectResolution.EnumSourceObjects) {
            Vector<? extends ValuedEnum> sourceObjects = this.getSourceObjects();
            return sourceObjects == null || sourceObjects.size() == 0 || sourceObjects.contains(subset) || sourceObjects.contains((Object)JDFAutoObjectResolution.EnumSourceObjects.All);
        }
        if (subset instanceof MyPair) {
            try {
                MyPair pair = (MyPair)subset;
                return this.matches(pair.a) && this.matches(pair.b);
            }
            catch (ClassCastException x) {
                return false;
            }
        }
        return false;
    }
}

