/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JDFDate;

class FileTime {
    protected final File f;
    protected long modified;
    protected long length;
    private final boolean readOnly;

    protected FileTime(File _f, boolean readOnly) {
        this.f = _f;
        this.modified = -1L;
        this.length = 0L;
        this.readOnly = readOnly;
        if (readOnly) {
            this.updateModified();
        }
    }

    protected long updateModified() {
        this.modified = this.modified <= 0L ? System.currentTimeMillis() : Math.max(this.modified, this.lastModified());
        this.length = this.lastLength();
        return this.modified;
    }

    protected boolean exists() {
        return this.f == null ? false : this.f.exists();
    }

    protected boolean sameModified() {
        long lastModified = this.lastModified();
        long lastLength = this.lastLength();
        return lastModified > 0L && this.modified >= lastModified && lastLength >= 0L && this.length == lastLength;
    }

    protected long lastModified() {
        if (this.f == null || this.readOnly && !this.f.canWrite()) {
            return 0L;
        }
        if (FileUtil.isLocked(this.f)) {
            return System.currentTimeMillis();
        }
        return this.f.lastModified();
    }

    protected long lastLength() {
        return this.f == null || !this.readOnly && !this.f.canWrite() ? -1L : this.f.length();
    }

    public String toString() {
        return this.f + " " + (this.modified > 0L ? new JDFDate(this.modified).getDateTimeISO() : "never") + " l=" + this.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileTime other = (FileTime)obj;
        return !(this.f == null ? other.f != null : !this.f.equals(other.f));
    }
}

