/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFValue;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;

public class JDFMatrixEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[4];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFMatrixEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFMatrixEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFMatrixEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFMatrixEvaluation[ --> " + super.toString() + " ]";
    }

    public void setRotateMod(double value) {
        this.setAttribute("RotateMod", value, null);
    }

    public double getRotateMod() {
        return this.getRealAttribute("RotateMod", null, 0.0);
    }

    public void setShift(JDFRectangle value) {
        this.setAttribute("Shift", value.toString());
    }

    public JDFRectangle getShift() {
        try {
            return new JDFRectangle(this.getAttribute("Shift", null, ""));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFMatrixEvaluation.getShift: AttributeValue not capable to create JDFRectangle");
        }
    }

    public Vector<JDFElement.EnumOrientation> getTransforms() {
        return this.getEnumerationsAttribute("Transforms", null, JDFElement.EnumOrientation.getEnum(0), false);
    }

    public void setTransforms(Vector<JDFElement.EnumOrientation> value) {
        this.setEnumerationsAttribute("Transforms", value, null);
    }

    public void setTolerance(JDFXYPair value) {
        this.setAttribute("Tolerance", value.toString(), null);
    }

    @Override
    public JDFXYPair getTolerance() {
        return super.getTolerance();
    }

    public JDFValue getValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", "", iSkip);
        return e;
    }

    public JDFValue appendValue() {
        return (JDFValue)this.appendElement("Value", null);
    }

    public void setValueValue(int iSkip, JDFMatrix value) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        e.setValue(value.toString());
    }

    public final JDFMatrix getValueValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        try {
            return new JDFMatrix(e.getValue());
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFMatrixState.getValueValue: AttributeValue not capable to create JDFMatrix");
        }
    }

    @Override
    public boolean fitsValue(String value) {
        VString vs = new VString(value, " ");
        int siz = vs.size();
        if (siz % 6 != 0) {
            return false;
        }
        VString matrixList = new VString();
        int i = 0;
        StringBuffer sb = new StringBuffer(250);
        sb.append(vs.elementAt(i));
        while (i + 1 < siz) {
            do {
                sb.append(" ");
                sb.append(vs.elementAt(++i));
            } while ((i + 1) % 6 != 0);
            matrixList.add(sb.toString());
            if (i + 1 >= siz) continue;
            sb = new StringBuffer(250);
            sb.append(vs.elementAt(++i));
        }
        if (!this.fitsListType(matrixList)) {
            return false;
        }
        for (int k = 0; k < matrixList.size(); ++k) {
            JDFMatrix matrix;
            String str = matrixList.elementAt(k);
            try {
                matrix = new JDFMatrix(str);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            if (this.fitsRotateMod(matrix) && this.fitsShift(matrix) && this.fitsTransforms(matrix) && this.fitsValueElem(matrix)) continue;
            return false;
        }
        return true;
    }

    public final boolean fitsListType(VString matrixList) {
        int i;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        int size = matrixList.size();
        for (i = 0; i < size; ++i) {
            try {
                new JDFMatrix(matrixList.elementAt(i));
                continue;
            }
            catch (JDFException e) {
                return false;
            }
            catch (DataFormatException dfe) {
                return false;
            }
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            return size == 1;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.List)) {
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            for (i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    String mj;
                    String mi;
                    if (j == i || (mi = matrixList.elementAt(i)).compareTo(mj = matrixList.elementAt(j)) != 0) continue;
                    return false;
                }
            }
            return true;
        }
        throw new JDFException("JDFMatrixEvaluation.fitsListType illegal ListType attribute");
    }

    public final boolean fitsValueElem(JDFMatrix matrix) {
        VElement v = this.getChildElementVector("Value", null, null, true, 0, false);
        int siz = v.size();
        if (siz == 0) {
            return true;
        }
        for (int i = 0; i < siz; ++i) {
            JDFMatrix value = this.getValueValue(i);
            if (!value.equals(matrix)) continue;
            return true;
        }
        return false;
    }

    public final boolean fitsRotateMod(JDFMatrix matrix) {
        double pT;
        double nT;
        if (!this.hasAttribute("RotateMod")) {
            return true;
        }
        double rm = this.getRotateMod();
        double a = matrix.getA();
        double b = matrix.getB();
        double c = matrix.getC();
        double d = matrix.getD();
        if (a * d - b * c == 0.0) {
            return false;
        }
        if (this.hasAttribute("Tolerance")) {
            nT = this.getTolerance().getX();
            pT = this.getTolerance().getY();
        } else {
            pT = 1.0E-6;
            nT = 1.0E-6;
        }
        double param = a / Math.sqrt(Math.abs(a * d - b * c));
        if (param - 1.0E-6 > 1.0 || param + 1.0E-6 < -1.0) {
            return false;
        }
        if (param > 1.0) {
            param -= 1.0E-6;
        }
        if (param < -1.0) {
            param += 1.0E-6;
        }
        double fi = Math.acos(param) * 180.0 / Math.PI;
        double result = fi + nT - rm * (double)((int)((fi + nT) / rm));
        double result180 = fi + 180.0 + nT - rm * (double)((int)((fi + 180.0 + nT) / rm));
        return Math.abs(result) <= nT + pT || Math.abs(result180) <= nT + pT;
    }

    public final boolean fitsShift(JDFMatrix matrix) {
        if (!this.hasAttribute("Shift")) {
            return true;
        }
        JDFRectangle shiftValue = new JDFRectangle(this.getShift());
        double minTx = shiftValue.getLlx();
        double minTy = shiftValue.getLly();
        double maxTx = shiftValue.getUrx();
        double maxTy = shiftValue.getUry();
        double Tx = matrix.getTx();
        double Ty = matrix.getTy();
        if (!this.hasAttribute("Tolerance")) {
            return Tx >= minTx && Tx <= maxTx && Ty >= minTy && Ty <= maxTy;
        }
        double nT = this.getTolerance().getX();
        double pT = this.getTolerance().getY();
        return Tx - nT >= minTx && Tx + pT <= maxTx && Ty - nT >= minTy && Ty + pT <= maxTy;
    }

    public final boolean fitsTransforms(JDFMatrix matrix) {
        double pT;
        double nT;
        Vector<JDFElement.EnumOrientation> vTransf = this.getTransforms();
        if (vTransf == null || vTransf.size() == 0) {
            return true;
        }
        if (this.hasAttribute("Tolerance")) {
            nT = this.getTolerance().getX();
            pT = this.getTolerance().getY();
        } else {
            pT = 1.0E-6;
            nT = 1.0E-6;
        }
        double a = matrix.getA();
        double b = matrix.getB();
        double c = matrix.getC();
        double d = matrix.getD();
        double det = a * d - b * c;
        if (det == 0.0) {
            return false;
        }
        det = Math.sqrt(Math.abs(det));
        a /= det;
        b /= det;
        c /= det;
        d /= det;
        for (JDFElement.EnumOrientation orientation : vTransf) {
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip0)) {
                if (!(a - 1.0 < pT) || !(a - 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d + 1.0 < pT) || !(d + 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip90)) {
                if (!(a < pT) || !(a > -nT) || !(b + 1.0 < pT) || !(b + 1.0 > -nT) || !(c + 1.0 < pT) || !(c + 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip180)) {
                if (!(a + 1.0 < pT) || !(a + 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d - 1.0 < pT) || !(d - 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip270)) {
                if (!(a < pT) || !(a > -nT) || !(b - 1.0 < pT) || !(b - 1.0 > -nT) || !(c - 1.0 < pT) || !(c - 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate0)) {
                if (!(a - 1.0 < pT) || !(a - 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d - 1.0 < pT) || !(d - 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate90)) {
                if (!(a < pT) || !(a > -nT) || !(b - 1.0 < pT) || !(b - 1.0 > -nT) || !(c + 1.0 < pT) || !(c + 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate180)) {
                if (!(a + 1.0 < pT) || !(a + 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d + 1.0 < pT) || !(d + 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate270)) {
                if (!(a < pT) || !(a > -nT) || !(b + 1.0 < pT) || !(b + 1.0 > -nT) || !(c - 1.0 < pT) || !(c - 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    static {
        JDFMatrixEvaluation.atrInfoTable[0] = new AtrInfoTable("RotateMod", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFMatrixEvaluation.atrInfoTable[1] = new AtrInfoTable("Shift", 0x33333333L, AttributeInfo.EnumAttributeType.NumberList, null, null);
        JDFMatrixEvaluation.atrInfoTable[2] = new AtrInfoTable("Tolerance", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, "0 0");
        JDFMatrixEvaluation.atrInfoTable[3] = new AtrInfoTable("Transforms", 0x33333333L, AttributeInfo.EnumAttributeType.enumerations, JDFElement.EnumOrientation.getEnum(0), null);
        elemInfoTable = new ElemInfoTable[1];
        JDFMatrixEvaluation.elemInfoTable[0] = new ElemInfoTable("BasicPreflightTest", 0x33333333L);
    }
}

