/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.StringTokenizer;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.util.HashUtil;

public class JDFNameRange
extends JDFRange {
    private String m_left = "";
    private String m_right = "";

    public JDFNameRange() {
        this("", "");
    }

    public JDFNameRange(String s) {
        this.isValid(s);
    }

    public JDFNameRange(String p_left, String p_right) {
        this.setLeft(p_left);
        this.setRight(p_right);
    }

    public JDFNameRange(JDFNameRange nr) {
        this.setLeft(nr.getLeft());
        this.setRight(nr.getRight());
    }

    @Override
    public String toString() {
        if (this.getLeft().equals(this.getRight())) {
            return this.getRight();
        }
        return this.getLeft() + " ~ " + this.getRight();
    }

    public boolean inRange(String x) {
        return x.compareTo(this.getLeft()) >= 0 && x.compareTo(this.getRight()) <= 0;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.toString().equals(((JDFNameRange)other).toString());
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public String getLowerValue() {
        return this.getLeft().compareTo(this.getRight()) >= 0 ? this.getLeft() : this.getRight();
    }

    public String getUpperValue() {
        return this.getLeft().compareTo(this.getRight()) >= 0 ? this.getRight() : this.getLeft();
    }

    protected void isValid(String s) {
        VString vs = new VString();
        StringTokenizer sToken = new StringTokenizer(s, "~");
        while (sToken.hasMoreElements()) {
            String str = (String)sToken.nextElement();
            vs.addElement(str.trim());
        }
        this.setLeft(vs.elementAt(0));
        if (vs.size() == 2) {
            this.setRight(vs.elementAt(1));
        } else {
            this.setRight(vs.elementAt(0));
        }
    }

    private void setLeft(String left) {
        this.m_left = left;
    }

    public String getLeft() {
        return this.m_left;
    }

    private void setRight(String right) {
        this.m_right = right;
    }

    public String getRight() {
        return this.m_right;
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        return this.equals(ra);
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((String)other);
    }
}

