/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.PartitionGetter;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDFResource
extends WalkXElement {
    private static final StringArray keepKeys = new StringArray("SignatureName SheetName Side PartVersion Separation BlockName Run DocIndex RunIndex SetIndex SheetIndex", null);
    private static final StringArray indexKeys = new StringArray("RunIndex DocIndex SetIndex SheetIndex", null);

    @Override
    public KElement walk(KElement xjdfRes, KElement parent) {
        JDFResource res;
        JDFNode theNode = this.getNode(xjdfRes, parent);
        boolean isNew = true;
        if (theNode != null) {
            MyPair<JDFResource, Boolean> mp = this.getResourceRoot(theNode, xjdfRes);
            res = mp.getA();
            isNew = mp.getB();
        } else if (parent instanceof JDFResourceInfo) {
            res = this.getResInfoRoot((JDFResourceInfo)parent, xjdfRes);
        } else {
            return null;
        }
        ResourceHelper rh = ResourceHelper.getHelper(xjdfRes);
        if (rh == null) {
            return null;
        }
        rh.getCreateResource();
        VJDFAttributeMap vParts = this.getPartMaps(rh);
        JDFAttributeMap p0 = ContainerUtil.isEmpty(vParts) ? new JDFAttributeMap() : vParts.get(0);
        isNew = isNew || !this.hasPartition(res, p0, theNode);
        KElement newPartitionElement = this.createPartition(res, p0, theNode);
        if (newPartitionElement == null) {
            return null;
        }
        JDFAttributeMap map = this.getResMap(xjdfRes);
        if (newPartitionElement instanceof JDFResource) {
            JDFResource newPartition = (JDFResource)newPartitionElement;
            JDFElement rl = null;
            if (theNode != null) {
                rl = this.ensureLink(theNode, newPartition);
            } else if (parent instanceof JDFResourceInfo) {
                rl = (JDFResourceInfo)parent;
            }
            JDFAttributeMap partMap = vParts.get(0);
            this.handleParts(newPartition, vParts, rl);
            this.handleAmountPool(xjdfRes, partMap, map, rl);
            if (rl != null) {
                rl.setAttribute("Orientation", map.remove("Orientation"));
                rl.setAttribute("Transformation", map.remove("Transformation"));
            }
        }
        newPartitionElement.setAttributes(map);
        return isNew ? newPartitionElement : null;
    }

    protected void handleParts(JDFResource res, VJDFAttributeMap vParts, JDFElement rl) {
        if (vParts.size() > 1) {
            for (String key : indexKeys) {
                VString vals = vParts.getPartValues(key, false);
                if (ContainerUtil.size(vals) <= 1) continue;
                VString resVals = new VString(vals);
                for (int i = 0; i < vals.size(); ++i) {
                    String single = vals.get(i);
                    if (StringUtil.token(single, 1, null) != null) continue;
                    resVals.set(i, single + " " + single);
                }
                String newVal = vals.getString();
                vParts.put(key, newVal);
                vParts.unify();
                if (!res.hasAttribute(key)) continue;
                res.setAttribute(key, resVals.getString());
            }
        }
        this.handleLinkParts(vParts, rl);
        this.handleIdentical(vParts, res.getResourceRoot());
    }

    protected void handleLinkParts(VJDFAttributeMap vParts, JDFElement rl) {
        if (rl != null && ContainerUtil.getNonEmpty(vParts) != null) {
            VJDFAttributeMap clone = vParts.clone();
            clone.reduceMap(keepKeys);
            if (clone.containsKey("Run")) {
                for (String index : indexKeys) {
                    if (!clone.containsKey(index)) continue;
                    clone.removeKey("Run");
                    break;
                }
            }
            if (clone.size() > 1) {
                for (String index : indexKeys) {
                    VString values = clone.getPartValues(index, false);
                    if (values == null || values.size() <= 1) continue;
                    clone.removeKey(index);
                    clone.put(index, StringUtil.setvString(values));
                    if (clone.size() != 1) continue;
                    break;
                }
            }
            clone.remove(new JDFAttributeMap());
            this.updatePartMaps(rl, clone);
        }
    }

    void updatePartMaps(JDFElement rl, VJDFAttributeMap clone) {
        VJDFAttributeMap oldParts;
        VJDFAttributeMap vJDFAttributeMap = oldParts = rl instanceof JDFResourceLink ? ((JDFResourceLink)rl).getPartMapVector() : ((JDFResourceInfo)rl).getPartMapVector();
        if (oldParts != null) {
            oldParts.appendUnique(clone);
        } else {
            oldParts = clone;
        }
        if (rl instanceof JDFResourceLink) {
            ((JDFResourceLink)rl).setPartMapVector(oldParts);
        } else {
            ((JDFResourceInfo)rl).setPartMapVector(oldParts);
        }
    }

    private void handleIdentical(VJDFAttributeMap vParts, JDFResource res) {
        if (vParts.size() > 1) {
            JDFAttributeMap targetMap = vParts.get(0);
            for (int i = 1; i < vParts.size(); ++i) {
                JDFAttributeMap partMap = vParts.get(i);
                PartitionGetter partitionGetter = new PartitionGetter(res);
                partitionGetter.setFollowIdentical(false);
                JDFResource rPart = partitionGetter.getCreatePartition(partMap, JDFPart.guessPartIDKeys(partMap));
                rPart.getCreateIdentical().setPartMap(targetMap);
            }
        }
    }

    VJDFAttributeMap getPartMaps(ResourceHelper rh) {
        List<JDFPart> parts = rh.getRoot().getChildArrayByClass(JDFPart.class, false, 0);
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        for (JDFPart part : parts) {
            JDFAttributeMap partMap = this.getPartMap(part);
            vMap.add(partMap);
        }
        if (vMap.isEmpty()) {
            vMap.add(new JDFAttributeMap());
        }
        vMap.unify();
        return vMap;
    }

    JDFAttributeMap getPartMap(JDFPart part) {
        return IDFinder.getPartMap(part);
    }

    protected String getJDFResName(SetHelper sh) {
        String name = sh.getName();
        return name;
    }

    private MyPair<JDFResource, Boolean> getResourceRoot(JDFNode theNode, KElement xjdfRes) {
        JDFNode newRoot = theNode.getJDFRoot();
        ResourceHelper ph = new ResourceHelper(xjdfRes);
        SetHelper sh = ph.getSet();
        String name = this.getJDFResName(sh);
        String processUsage = sh.getProcessUsage();
        JDFResourceLink.EnumUsage inOut = this.getLinkUsage(theNode, sh, name, processUsage);
        String id = this.xjdfToJDFImpl.idMap.get(xjdfRes.getID()).getID();
        JDFResource res = (JDFResource)newRoot.getCreateResourcePool().getChildWithAttribute(null, "ID", null, id, 0, true);
        boolean isNew = false;
        KElement setRoot = sh.getRoot();
        if (res == null) {
            boolean combine = !StringUtil.equals(id, sh.getID());
            JDFResource jDFResource = res = combine ? theNode.getResource(name, inOut, processUsage, null, 0) : null;
            if (res == null) {
                isNew = true;
                res = this.createNewResource(theNode, name, id, setRoot);
            }
            res = res.getResourceRoot();
            if (theNode != newRoot) {
                newRoot.getCreateResourcePool().moveElement(res, null);
            }
        }
        if (inOut != null) {
            JDFResourceLink rl = theNode.getLink(res, inOut);
            if (rl == null) {
                rl = theNode.ensureLinkPU(res, inOut, processUsage);
                rl.copyAttribute("CombinedProcessIndex", setRoot);
                rl.setrRef(id);
                res.removeAttribute("Usage");
                StringArray reslinks = XJDFToJDFConverter.getResLinkAttribs();
                for (String key : reslinks) {
                    if (!res.hasAttribute(key)) continue;
                    rl.moveAttribute(key, res);
                }
            }
            JDFResource.EnumResourceClass resClass = res.getResourceClass();
            if (isNew && JDFResourceLink.EnumUsage.Input.equals((Object)inOut) && (JDFResource.EnumResourceClass.Parameter.equals((Object)resClass) || JDFResource.EnumResourceClass.Consumable.equals((Object)resClass) || JDFResource.EnumResourceClass.Intent.equals((Object)resClass))) {
                res.setResStatus(JDFResource.EnumResStatus.Available, false);
            }
        }
        return new MyPair<JDFResource, Boolean>(res, isNew);
    }

    protected JDFResource createNewResource(JDFNode theNode, String name, String id, KElement setRoot) {
        JDFResource res = theNode.addResource(name, null);
        res.setID(id);
        res.copyAttribute("DescriptiveName", setRoot);
        res.copyAttribute("CommentURL", setRoot);
        res.copyAttribute("Unit", setRoot);
        return res;
    }

    JDFResourceLink.EnumUsage getLinkUsage(JDFNode theNode, SetHelper sh, String name, String processUsage) {
        JDFResourceLink.EnumUsage inOut = sh.getUsage();
        if (!(inOut != null || !this.xjdfToJDFImpl.isHeuristicLink() || "Contact".equals(name) || "LayoutElement".equals(name) || "RunList".equals(name) || "Component".equals(name) || "ColorPool".equals(name) || "Media".equals(name) || "ExposedMedia".equals(name) || !theNode.isValidLink(name, JDFResourceLink.EnumUsage.Input, processUsage))) {
            inOut = JDFResourceLink.EnumUsage.Input;
        }
        return inOut;
    }

    private JDFResource getResInfoRoot(JDFResourceInfo parent, KElement xjdfRes) {
        ResourceHelper ph = new ResourceHelper(xjdfRes);
        SetHelper sh = ph.getSet();
        String name = this.getJDFResName(sh);
        String processUsage = sh.getProcessUsage();
        parent.setProcessUsage(processUsage);
        JDFResourceLink.EnumUsage inOut = sh.getUsage();
        parent.setUsage(inOut);
        parent.setResourceName(name);
        JDFResource res = parent.getCreateResource(name);
        StringArray reslinks = XJDFToJDFConverter.getResLinkAttribs();
        for (String key : reslinks) {
            if (!res.hasAttribute(key)) continue;
            parent.moveAttribute(key, res);
        }
        return res;
    }

    protected JDFAttributeMap getResMap(KElement xjdfRes) {
        JDFAttributeMap map = xjdfRes.getAttributeMap();
        map.remove("ID");
        map.remove("PartIDKeys");
        return map;
    }

    private void handleAmountPool(KElement xjdfRes, JDFAttributeMap partmap, JDFAttributeMap map, JDFElement rl) {
        KElement ap = xjdfRes.getElement("AmountPool");
        if (ap != null && rl != null) {
            KElement newAmountPool = rl.getCreateElement("AmountPool");
            List<JDFPartAmount> vpa = ap.getChildArrayByClass(JDFPartAmount.class, false, 0);
            for (JDFPartAmount pa : vpa) {
                VJDFAttributeMap vParts = pa.getPartMapVector();
                if (vParts == null) {
                    if (!JDFAttributeMap.isEmpty(partmap)) {
                        vParts = new VJDFAttributeMap(partmap);
                    }
                } else {
                    vParts.put(partmap);
                }
                pa.setPartMapVector(vParts);
                this.xjdfToJDFImpl.walkTree(pa, newAmountPool);
            }
            ap.deleteNode();
        }
        if (rl instanceof JDFResourceLink) {
            this.xjdfToJDFImpl.moveAmountsToLink(partmap, map, (JDFResourceLink)rl);
        }
    }

    private JDFResourceLink ensureLink(JDFNode partialProductNode, JDFResource newPartition) {
        if (partialProductNode != null) {
            return partialProductNode.getLink(newPartition, null);
        }
        return null;
    }

    protected boolean hasPartition(JDFResource jdfRes, JDFAttributeMap partMap, JDFNode theNode) {
        if (JDFAttributeMap.isEmpty(partMap)) {
            return true;
        }
        JDFAttributeMap reduced = this.removeImplicitParts(jdfRes, partMap);
        if (JDFAttributeMap.isEmpty(reduced)) {
            return true;
        }
        JDFResource p0 = jdfRes.getPartition(reduced, JDFResource.EnumPartUsage.Explicit);
        return p0 != null;
    }

    protected KElement createPartition(JDFResource jdfRes, JDFAttributeMap partMap, JDFNode theNode) {
        if (JDFAttributeMap.isEmpty(partMap)) {
            return jdfRes;
        }
        JDFAttributeMap reduced = this.removeImplicitParts(jdfRes, partMap);
        if (JDFAttributeMap.isEmpty(reduced)) {
            return jdfRes;
        }
        try {
            return jdfRes.getCreatePartition(reduced, JDFPart.guessPartIDKeys(reduced));
        }
        catch (Exception x) {
            this.log.error((Object)("Cannot create partition for: " + jdfRes.getNodeName()), (Throwable)x);
            return null;
        }
    }

    protected JDFAttributeMap removeImplicitParts(JDFResource jdfRes, JDFAttributeMap partMap) {
        Vector<JDFResource.EnumPartIDKey> implicitPartitions = jdfRes.getImplicitPartitions();
        if (implicitPartitions != null) {
            JDFAttributeMap ret = partMap.clone();
            for (JDFResource.EnumPartIDKey key : implicitPartitions) {
                ret.remove(key.getName());
            }
            return ret;
        }
        return partMap;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && ResourceHelper.isAsset(toCheck);
    }
}

