/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoIDInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.util.StringUtil;

public class JDFIDInfo
extends JDFAutoIDInfo
implements INodeIdentifiable {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[1];

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFIDInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFIDInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFIDInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFIDInfo[  --> " + super.toString() + " ]";
    }

    public static JDFIDInfo createFromJDF(JDFNode n, JDFMessage message) {
        JDFIDInfo newInfo;
        JDFIDInfo jDFIDInfo = newInfo = message == null ? (JDFIDInfo)new JDFDoc("IDInfo").getRoot() : message.appendIDInfo();
        if (n != null) {
            String[] directCopy = new String[]{"Type", "Types", "DescriptiveName", "JobPartID", "Category"};
            for (int i = 0; i < directCopy.length; ++i) {
                newInfo.copyAttribute(directCopy[i], n);
            }
            newInfo.setJobID(StringUtil.getNonEmpty(n.getJobID(true)));
            JDFNode parent = n.getParentJDF();
            if (parent != null) {
                newInfo.setParentJobID(StringUtil.getNonEmpty(parent.getJobID(true)));
                newInfo.setParentJobPartID(StringUtil.getNonEmpty(parent.getJobPartID(false)));
            }
        }
        return newInfo;
    }

    @Override
    public String getParentJobID() {
        String s = StringUtil.getNonEmpty(super.getParentJobID());
        return s == null ? this.getJobID() : s;
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(), this.getJobPartID(), null);
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
    }

    static {
        JDFIDInfo.elemInfoTable[0] = new ElemInfoTable("JDF", 0x66666611L);
    }
}

