/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.HashUtil;
import org.cip4.jdflib.util.StringUtil;

public class VJDFAttributeMap
extends Vector<JDFAttributeMap> {
    private static final long serialVersionUID = 1L;

    public VJDFAttributeMap() {
    }

    public VJDFAttributeMap(Vector<JDFAttributeMap> toAdd) {
        if (toAdd != null) {
            for (JDFAttributeMap map : toAdd) {
                this.add(map.clone());
            }
        }
    }

    public VJDFAttributeMap(JDFAttributeMap[] toAdd) {
        this.clear();
        if (toAdd != null) {
            for (JDFAttributeMap map : toAdd) {
                this.add(map);
            }
        }
    }

    public VJDFAttributeMap(JDFAttributeMap moreMap) {
        this();
        if (moreMap != null) {
            this.add(moreMap);
        }
    }

    @Override
    public synchronized String toString() {
        return "VJDFAttributeMap: " + this.showKeys("\n", " ");
    }

    public static VJDFAttributeMap getNonEmpty(VJDFAttributeMap v) {
        return VJDFAttributeMap.isEmpty(v) ? null : v;
    }

    public static VJDFAttributeMap getVector(JDFAttributeMap partMap) {
        return JDFAttributeMap.isEmpty(partMap) ? null : new VJDFAttributeMap(partMap);
    }

    public static boolean isEmpty(VJDFAttributeMap v) {
        return v == null || v.isEmpty() || v.size() == 1 && JDFAttributeMap.isEmpty(v.get(0));
    }

    public String showKeys(String sepMap, String sepEntry) {
        StringBuilder sb = new StringBuilder();
        int nPartMaps = this.size();
        for (int i = 0; i < nPartMaps; ++i) {
            JDFAttributeMap amParts = this.elementAt(i);
            sb.append("[").append(i).append("]").append(amParts.showKeys(sepEntry));
            if (i + 1 >= nPartMaps) continue;
            sb.append(sepMap);
        }
        return sb.toString();
    }

    public VString getPartValues(String strKey, boolean bUnique) {
        VString vsPartValues = new VString();
        for (JDFAttributeMap map : this) {
            String strValue = map.get(strKey);
            if (strValue == null) continue;
            vsPartValues.add(strValue);
        }
        if (bUnique) {
            vsPartValues.unify();
        }
        return vsPartValues;
    }

    public void extendMap(String strKey, List<String> vsValues) {
        if (StringUtil.isEmpty(vsValues) || StringUtil.isEmpty(strKey)) {
            return;
        }
        VJDFAttributeMap vec = new VJDFAttributeMap();
        if (this.isEmpty()) {
            this.add(new JDFAttributeMap());
        }
        for (JDFAttributeMap map : this) {
            for (String val : vsValues) {
                JDFAttributeMap mapNew = new JDFAttributeMap(map);
                mapNew.put(strKey, val);
                vec.add(mapNew);
            }
        }
        this.clear();
        ContainerUtil.addAll(this, vec);
    }

    public VJDFAttributeMap getAndMaps(JDFAttributeMap map) {
        if (map == null) {
            return new VJDFAttributeMap(this);
        }
        VJDFAttributeMap newMap = new VJDFAttributeMap();
        for (int i = 0; i < this.size(); ++i) {
            JDFAttributeMap map0 = this.get(i);
            if (map0 != null) {
                map0 = map0.getAndMap(map);
            }
            if (map0 == null) continue;
            newMap.add(map0);
        }
        if (newMap.size() > 0) {
            newMap.unify();
        } else {
            newMap = null;
        }
        return newMap;
    }

    public VJDFAttributeMap getOrMaps(JDFAttributeMap map) {
        if (JDFAttributeMap.isEmpty(map)) {
            return new VJDFAttributeMap(this);
        }
        VJDFAttributeMap newMap = new VJDFAttributeMap();
        for (JDFAttributeMap map0 : this) {
            if ((map0 = map0.getOrMap(map)) == null) continue;
            newMap.add(map0);
        }
        if (newMap.isEmpty()) {
            newMap = null;
        } else {
            newMap.unify();
        }
        return newMap;
    }

    public VJDFAttributeMap getOrMaps(VJDFAttributeMap vMap) {
        if (VJDFAttributeMap.isEmpty(vMap)) {
            return new VJDFAttributeMap(this);
        }
        VJDFAttributeMap newMap = new VJDFAttributeMap();
        for (JDFAttributeMap map : vMap) {
            VJDFAttributeMap maps0 = this.getOrMaps(map);
            if (maps0 == null) continue;
            newMap.addAll(maps0);
        }
        if (newMap.isEmpty()) {
            newMap = null;
        } else {
            newMap.unify();
        }
        return newMap;
    }

    public boolean containsKey(Object key) {
        boolean isFound = false;
        int size = this.size();
        for (int i = 0; i < size && !isFound; ++i) {
            JDFAttributeMap map = this.elementAt(i);
            isFound = map.containsKey(key);
        }
        return isFound;
    }

    public void setVector(List<JDFAttributeMap> vec) {
        this.clear();
        if (vec != null) {
            this.addAll(vec);
        }
    }

    public int maxSize() {
        int maxSize = 0;
        for (JDFAttributeMap map : this) {
            if (map == null || map.size() <= maxSize) continue;
            maxSize = map.size();
        }
        return maxSize;
    }

    public int minSize() {
        int minSize = 9999999;
        if (this.size() > 0) {
            JDFAttributeMap map;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && ((map = (JDFAttributeMap)iterator.next()) == null || map.size() >= minSize || (minSize = map.size()) != 0)) {
            }
        } else {
            minSize = 0;
        }
        return minSize;
    }

    @Override
    public JDFAttributeMap elementAt(int i) {
        return this.get(i);
    }

    @Override
    public JDFAttributeMap get(int i) {
        if (i < 0) {
            i += this.size();
        }
        return (JDFAttributeMap)super.get(i);
    }

    public void removeKeys(Collection<String> set) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.elementAt(i).removeKeys(set);
            if (!this.elementAt(i).isEmpty()) continue;
            this.removeElementAt(i);
        }
        this.unify();
    }

    @Override
    public void removeElementAt(int i) {
        this.remove(i);
    }

    public void removeKey(String key) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.elementAt(i).remove(key);
            if (!this.elementAt(i).isEmpty()) continue;
            this.removeElementAt(i);
        }
        this.unify();
    }

    @Deprecated
    public boolean hasEntryWithEqualKeyValuePairs(JDFAttributeMap attmap) {
        boolean bEquals = false;
        for (int i = 0; i < this.size(); ++i) {
            if (attmap == this.elementAt(i)) {
                return true;
            }
            bEquals = false;
            JDFAttributeMap map = this.elementAt(i);
            if (map.size() != attmap.size()) continue;
            bEquals = true;
            Set mapSet = map.keySet();
            for (String key : mapSet) {
                String value2;
                if (!attmap.containsKey(key)) {
                    bEquals = false;
                    break;
                }
                String value1 = map.get(key);
                if (value1.equals(value2 = attmap.get(key))) continue;
                bEquals = false;
                break;
            }
            if (!bEquals) continue;
            return bEquals;
        }
        return bEquals;
    }

    @Deprecated
    public void reduceKey(Vector vKeys) {
        VJDFAttributeMap v = new VJDFAttributeMap();
        for (int i = 0; i < this.size(); ++i) {
            JDFAttributeMap map = this.elementAt(i);
            map.reduceMap(vKeys);
            if (map.isEmpty()) continue;
            v.add(map);
        }
        v.unify();
        this.setVector(v);
    }

    public void reduceMap(Collection<String> keySet) {
        VJDFAttributeMap v = new VJDFAttributeMap();
        for (JDFAttributeMap map : this) {
            boolean bNullMap = map.isEmpty();
            map.reduceMap(keySet);
            if (!bNullMap && map.isEmpty()) continue;
            v.add(map);
        }
        v.unify();
        this.setVector(v);
    }

    public VString getKeys() {
        VString v = new VString();
        for (JDFAttributeMap map : this) {
            v.addAll(map.getKeyList());
        }
        v.unify();
        return v;
    }

    @Deprecated
    public Vector<JDFAttributeMap> getVector() {
        return this;
    }

    public JDFAttributeMap getCommonMap() {
        JDFAttributeMap newMap = new JDFAttributeMap();
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return this.get(0).clone();
        }
        JDFAttributeMap map0 = this.get(0);
        Set keys = map0.keySet();
        for (String key : keys) {
            String val0 = map0.get(key);
            if (val0 == null) continue;
            for (JDFAttributeMap map : this) {
                String val = map.get(key);
                if (val0.equals(val)) continue;
                val0 = null;
                break;
            }
            if (val0 == null) continue;
            newMap.put(key, val0);
        }
        return newMap;
    }

    public void appendUnique(JDFAttributeMap map) {
        ContainerUtil.appendUnique(this, map);
    }

    @Override
    public void addElement(JDFAttributeMap map) {
        this.add(map);
    }

    public void unify() {
        ContainerUtil.unify(this);
    }

    public void appendUnique(VJDFAttributeMap maps) {
        ContainerUtil.appendUnique(this, maps);
    }

    @Deprecated
    public void addall(VJDFAttributeMap v) {
        this.addAll(v);
    }

    public void overlapMap(JDFAttributeMap map) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).overlapMap(map)) continue;
            this.remove(i);
        }
    }

    public VJDFAttributeMap getOverlapMaps(JDFAttributeMap map) {
        VJDFAttributeMap newV = new VJDFAttributeMap();
        for (JDFAttributeMap m : this) {
            if (!m.overlapMap(map)) continue;
            newV.add(m);
        }
        return newV;
    }

    public VJDFAttributeMap getMatchingMaps(String key, String regExp, boolean ignoreCase) {
        VJDFAttributeMap newV = new VJDFAttributeMap();
        for (JDFAttributeMap m : this) {
            if (!m.matches(key, regExp, ignoreCase)) continue;
            newV.add(m);
        }
        return newV;
    }

    public void overlapMap(VJDFAttributeMap vMap) {
        if (vMap == null) {
            return;
        }
        Set<JDFAttributeMap> set = ContainerUtil.toHashSet(vMap);
        for (int i = this.size() - 1; i >= 0; --i) {
            JDFAttributeMap attributeMap = this.get(i);
            if (set.contains(attributeMap) || attributeMap.overlapMap(vMap)) continue;
            this.remove(i);
        }
    }

    public boolean overlapsMap(JDFAttributeMap map) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.elementAt(i).overlapMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean subMap(JDFAttributeMap map) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.elementAt(i).subMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean subMap(VJDFAttributeMap vMap) {
        if (VJDFAttributeMap.isEmpty(vMap)) {
            return true;
        }
        for (JDFAttributeMap map : vMap) {
            if (!this.subMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean overlapsMap(VJDFAttributeMap vMap) {
        int size;
        int n = size = vMap == null ? 0 : vMap.size();
        if (size == 0) {
            return true;
        }
        if (vMap != null) {
            for (int i = 0; i < size; ++i) {
                if (!this.overlapsMap(vMap.elementAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VJDFAttributeMap)) {
            return false;
        }
        int size = this.size();
        if (size != ((VJDFAttributeMap)other).size()) {
            return false;
        }
        VJDFAttributeMap vOther = new VJDFAttributeMap();
        vOther.addAll((VJDFAttributeMap)other);
        for (JDFAttributeMap map : this) {
            int index = vOther.indexOf(map);
            if (index < 0) {
                return false;
            }
            vOther.removeElementAt(index);
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        return HashUtil.hashCode(0, this);
    }

    public void put(Object key, Object value) {
        String s1 = null;
        if (key instanceof String) {
            s1 = (String)key;
        } else if (key instanceof ValuedEnum) {
            s1 = ((ValuedEnum)key).getName();
        }
        String s2 = null;
        if (value instanceof String) {
            s2 = (String)value;
        } else if (value instanceof ValuedEnum) {
            s2 = ((ValuedEnum)value).getName();
        }
        if (s1 == null || s2 == null) {
            throw new IllegalArgumentException("wrong key and value types in put: " + key + " " + value);
        }
        this.put(s1, s2);
    }

    public void put(String key, String value) {
        int size = this.size();
        if (size == 0) {
            this.add(new JDFAttributeMap(key, value));
        } else {
            for (int i = 0; i < size; ++i) {
                this.elementAt(i).put(key, value);
            }
        }
    }

    @Override
    public VJDFAttributeMap clone() {
        return new VJDFAttributeMap(this);
    }

    public void removeMaps(JDFAttributeMap map) {
        if (JDFAttributeMap.isEmpty(map)) {
            this.clear();
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                JDFAttributeMap map0 = this.get(i);
                if (map0 == null || !map0.subMap(map)) continue;
                this.removeElementAt(i);
            }
        }
    }

    public void put(JDFAttributeMap commonMap) {
        if (commonMap != null) {
            for (Map.Entry entry : commonMap.entrySet()) {
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    public void setElementAt(JDFAttributeMap mTmp, int j) {
        this.set(j, mTmp);
    }
}

