/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.List;
import org.cip4.jdflib.auto.JDFAutoAssembly;
import org.cip4.jdflib.auto.JDFAutoBinderySignature;
import org.cip4.jdflib.auto.JDFAutoContentObject;
import org.cip4.jdflib.auto.JDFAutoImageShift;
import org.cip4.jdflib.auto.JDFAutoLayoutPreparationParams;
import org.cip4.jdflib.auto.JDFAutoPageCell;
import org.cip4.jdflib.auto.JDFAutoSignatureCell;
import org.cip4.jdflib.auto.JDFAutoStripCellParams;
import org.cip4.jdflib.auto.JDFAutoStripMark;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFImageShift;
import org.cip4.jdflib.resource.JDFLayoutPreparationParams;
import org.cip4.jdflib.resource.JDFModified;
import org.cip4.jdflib.resource.JDFPageCell;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFAssembly;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFExternalImpositionTemplate;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStripMark;
import org.cip4.jdflib.util.StringUtil;

public class StrippingConverter {
    private final JDFLayoutPreparationParams layPrepParams;
    private JDFAssembly assembly = null;
    private JDFBinderySignature binderySignature = null;
    private JDFStrippingParams strippingParams = null;
    private final JDFNode parent;

    public StrippingConverter(JDFLayoutPreparationParams layoutPreparationParams, JDFNode n) {
        this.layPrepParams = layoutPreparationParams;
        this.parent = n == null ? this.layPrepParams.getParentJDF() : n;
    }

    public JDFBinderySignature getBinderySignature() {
        return this.binderySignature != null ? this.binderySignature : this.strippingParams.getBinderySignature();
    }

    public void convert() {
        this.convertParentNode();
        this.convertAssembly();
        this.strippingParams = (JDFStrippingParams)this.parent.addResource("StrippingParams", JDFResourceLink.EnumUsage.Input);
        this.strippingParams.setAutomated(true);
        this.strippingParams.clonePartitions(this.layPrepParams, null);
        List<JDFResource> vThis = this.layPrepParams.getLeafArray(false);
        for (KElement kElement : vThis) {
            new StrippingConverter((JDFLayoutPreparationParams)kElement, this.parent).convertLeaf();
        }
    }

    protected void convertLeaf() {
        this.strippingParams = (JDFStrippingParams)this.parent.getResource("StrippingParams", JDFResourceLink.EnumUsage.Input, 0);
        JDFAttributeMap partMap = this.layPrepParams.getPartMap();
        if (partMap != null && partMap.size() > 0) {
            this.strippingParams = (JDFStrippingParams)this.strippingParams.getPartition(partMap, null);
        }
        this.convertStrippingParams();
        this.convertBinderySignature();
        this.setSignatureCell();
        this.setStripCellParams();
        this.removeObsolete();
    }

    private void removeObsolete() {
        VElement v = this.layPrepParams.getLinksAndRefs(true, true);
        if (v != null) {
            for (KElement e : v) {
                e.deleteNode();
            }
        }
        this.layPrepParams.deleteNode();
    }

    private void convertStrippingParams() {
        JDFMedia media = this.layPrepParams.getMedia();
        if (media != null) {
            media.makeRootResource(null, null, true);
            this.strippingParams.refElement(media);
        }
        JDFExternalImpositionTemplate template = this.layPrepParams.getExternalImpositionTemplate();
        this.strippingParams.copyElement(template, null);
        this.strippingParams.copyElement(this.layPrepParams.getFitPolicy(), null);
        this.setPosition();
        this.setStripMarks(this.layPrepParams.getFrontMarkList(), JDFAutoStripMark.EnumMarkSide.Front);
        this.setStripMarks(this.layPrepParams.getBackMarkList(), JDFAutoStripMark.EnumMarkSide.Back);
    }

    void setStripCellParams() {
        JDFAutoLayoutPreparationParams.EnumSides sides;
        JDFXYPair ts;
        JDFPageCell pageCell = this.layPrepParams.getPageCell();
        if (pageCell != null && (ts = pageCell.getTrimSize()) != null) {
            this.strippingParams.getCreateStripCellParams().setTrimSize(ts);
        }
        if (JDFAutoLayoutPreparationParams.EnumSides.TwoSidedFlipY.equals((Object)(sides = this.layPrepParams.getSides()))) {
            this.strippingParams.getCreateStripCellParams().setSides(JDFAutoStripCellParams.EnumSides.TwoSidedHeadToHead);
        } else if (JDFAutoLayoutPreparationParams.EnumSides.TwoSidedFlipX.equals((Object)sides)) {
            this.strippingParams.getCreateStripCellParams().setSides(JDFAutoStripCellParams.EnumSides.TwoSidedHeadToFoot);
        } else if (JDFAutoLayoutPreparationParams.EnumSides.OneSidedBackFlipX.equals((Object)sides) || JDFAutoLayoutPreparationParams.EnumSides.OneSidedBackFlipY.equals((Object)sides)) {
            this.strippingParams.getCreateStripCellParams().setSides(JDFAutoStripCellParams.EnumSides.OneSidedBack);
        } else {
            this.strippingParams.getCreateStripCellParams().setSides(JDFAutoStripCellParams.EnumSides.OneSided);
        }
    }

    void setSignatureCell() {
        JDFPageCell pageCell = this.layPrepParams.getPageCell();
        if (pageCell == null) {
            return;
        }
        JDFSignatureCell signatureCell = this.getBinderySignature().getCreateSignatureCell(0);
        signatureCell.setOrientation(this.getSigCellOrientation(pageCell.getRotate()));
        this.convertImageShift(pageCell, signatureCell);
        signatureCell.copyElement(pageCell.getFitPolicy(), null);
    }

    private void convertImageShift(JDFPageCell pageCell, JDFSignatureCell signatureCell) {
        JDFAutoContentObject.EnumAnchor ea;
        JDFImageShift imageShift = pageCell.getImageShift();
        if (imageShift == null) {
            return;
        }
        JDFAutoImageShift.EnumPositionX posX = imageShift.getPositionX();
        JDFAutoImageShift.EnumPositionY posY = imageShift.getPositionY();
        if (posX == null || posY == null) {
            return;
        }
        String anchor = posY.getName() + posX.getName();
        if ("CenterCenter".equals(anchor)) {
            anchor = "Center";
        }
        if ((ea = JDFAutoContentObject.EnumAnchor.getEnum(anchor)) != null) {
            signatureCell.setAttribute("Anchor", anchor);
        }
    }

    private JDFAutoSignatureCell.EnumOrientation getSigCellOrientation(JDFAutoPageCell.EnumRotate rotate) {
        if (JDFAutoPageCell.EnumRotate.Rotate90.equals((Object)rotate)) {
            return JDFAutoSignatureCell.EnumOrientation.Left;
        }
        if (JDFAutoPageCell.EnumRotate.Rotate180.equals((Object)rotate)) {
            return JDFAutoSignatureCell.EnumOrientation.Down;
        }
        if (JDFAutoPageCell.EnumRotate.Rotate270.equals((Object)rotate)) {
            return JDFAutoSignatureCell.EnumOrientation.Right;
        }
        return JDFAutoSignatureCell.EnumOrientation.Up;
    }

    private void setPosition() {
        JDFIntegerList sr = this.layPrepParams.getStepRepeat();
        if (sr == null) {
            this.addSinglePosition(1, 1, 0, null);
        } else {
            int iX = sr.getInt(0);
            int iY = sr.getInt(1);
            JDFXYPair numberUp = this.layPrepParams.getNumberUp();
            int total = (int)(numberUp == null ? 1.0 : numberUp.getX() * numberUp.getY());
            for (int i = 0; i < total; ++i) {
                this.addSinglePosition(iX, iY, i, numberUp);
            }
        }
    }

    JDFPosition addSinglePosition(int x, int y, int n, JDFXYPair numberUp) {
        String bsName = this.getBSName(x, y, n, numberUp);
        JDFStrippingParams sp = bsName == null ? this.strippingParams : this.strippingParams.getCreatePartition(new JDFAttributeMap("BinderySignatureName", bsName), null);
        JDFPosition position = sp.appendPosition();
        position.setRelativeBox(this.getRelativeBox(x, y, n, numberUp));
        JDFAutoLayoutPreparationParams.EnumRotate r = this.layPrepParams.getRotate();
        JDFMatrix m = new JDFMatrix(JDFElement.EnumOrientation.getEnum(r.getName()), 0.0, 0.0);
        JDFAutoLayoutPreparationParams.EnumSides sides = this.layPrepParams.getSides();
        if (JDFAutoLayoutPreparationParams.EnumSides.OneSidedBackFlipX.equals((Object)sides)) {
            m.concat(new JDFMatrix(JDFElement.EnumOrientation.Flip0, 0.0, 0.0));
        } else if (JDFAutoLayoutPreparationParams.EnumSides.OneSidedBackFlipY.equals((Object)sides)) {
            m.concat(new JDFMatrix(JDFElement.EnumOrientation.Flip180, 0.0, 0.0));
        }
        position.setAttribute("Orientation", m.getOrientation().getName());
        return position;
    }

    private JDFRectangle getRelativeBox(int srx, int sry, int n, JDFXYPair numberUp) {
        int total = (int)(numberUp == null ? 1.0 : numberUp.getX() * numberUp.getY());
        if (total == 1 || numberUp == null) {
            return new JDFRectangle(0.0, 0.0, 1.0, 1.0);
        }
        double dx = 1.0 / numberUp.getX();
        double dy = 1.0 / numberUp.getY();
        double x = n % (int)numberUp.getX();
        double y = n / (int)numberUp.getX();
        return new JDFRectangle(x /= numberUp.getX(), y /= numberUp.getY(), x + dx, y + dy);
    }

    private String getBSName(int srx, int sry, int n, JDFXYPair numberUp) {
        int total = (int)(numberUp == null ? 1.0 : numberUp.getX() * numberUp.getY());
        if (total == 1) {
            return null;
        }
        int x = n % (int)numberUp.getX();
        int y = n / (int)numberUp.getX();
        return "BS_" + (1 + (x /= srx)) + "_" + (1 + (y /= sry));
    }

    private void setStripMarks(VString marks, JDFAutoStripMark.EnumMarkSide side) {
        for (String markName : marks) {
            JDFStripMark sm = this.strippingParams.appendStripMark();
            sm.setMarkName(markName);
            sm.setMarkSide(side);
        }
    }

    private void convertBinderySignature() {
        this.binderySignature = this.strippingParams.appendBinderySignature();
        this.binderySignature.makeRootResource(null, null, true);
        this.binderySignature.copyAttribute("BindingEdge", this.layPrepParams);
        if (this.layPrepParams.hasAttribute("StepRepeat")) {
            this.binderySignature.setNumberUp(1, 1);
        } else {
            this.binderySignature.copyAttribute("NumberUp", this.layPrepParams);
        }
        this.binderySignature.copyAttribute("FoldCatalog", this.layPrepParams);
        String pageDistribution = this.layPrepParams.getPageDistributionScheme();
        String foldcatalog = StringUtil.getNonEmpty(this.layPrepParams.getFoldCatalog());
        if ("Sequential".equals(pageDistribution) && (foldcatalog == null || "F2-1".equals(foldcatalog))) {
            this.binderySignature.setBinderySignatureType(JDFAutoBinderySignature.EnumBinderySignatureType.Grid);
        } else {
            this.binderySignature.setBinderySignatureType(JDFAutoBinderySignature.EnumBinderySignatureType.Fold);
        }
    }

    private void convertAssembly() {
        this.assembly = (JDFAssembly)this.parent.addResource("Assembly", JDFResourceLink.EnumUsage.Input);
        this.assembly.copyAttribute("BindingSide", this.layPrepParams, "BindingEdge", null, null);
        JDFAutoLayoutPreparationParams.EnumFinishingOrder fo = this.layPrepParams.getFinishingOrder();
        if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.FoldCollect.equals((Object)fo)) {
            this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Collecting);
        } else if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.FoldGather.equals((Object)fo)) {
            this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Gathering);
        } else if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.Gather.equals((Object)fo)) {
            this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Gathering);
        } else if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.GatherFold.equals((Object)fo)) {
            String pageDistribution = this.layPrepParams.getPageDistributionScheme();
            if ("Saddle".equals(pageDistribution)) {
                this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Collecting);
            } else {
                this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Gathering);
            }
        }
    }

    private JDFNode convertParentNode() {
        int n;
        VString types = this.parent.getTypes();
        if (types == null && JDFNode.EnumType.LayoutPreparation.equals((Object)this.parent.getEnumType())) {
            this.parent.setType(JDFNode.EnumType.Stripping);
        } else if (types != null && (n = types.index(JDFNode.EnumType.LayoutPreparation.getName())) >= 0) {
            types.set(n, JDFNode.EnumType.Stripping.getName());
            this.parent.setTypes(types);
        }
        JDFModified mod = this.parent.getCreateAuditPool().addModified(null, null);
        mod.setDescriptiveName("Automatic LayoutPrep to Stripping Conversion");
        return this.parent;
    }

    public JDFAssembly getAssembly() {
        return this.assembly;
    }

    public JDFStrippingParams getStrippingParams() {
        return this.strippingParams;
    }

    public String toString() {
        return "StrippingConverter [layPrepParams=" + this.layPrepParams + ", strippingParams=" + this.strippingParams + ", assembly=" + this.assembly + "]";
    }
}

