/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.List;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.ifaces.IAmountPoolContainer;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class ResourceHelper
extends BaseXJDFHelper
implements IAmountPoolContainer {
    public ResourceHelper(KElement partition) {
        this.theElement = partition;
    }

    public static boolean isAsset(KElement toCheck) {
        if (toCheck == null) {
            return false;
        }
        KElement parent = toCheck.getParentNode_KElement();
        String setName = SetHelper.getSetName(parent);
        return toCheck.getLocalName().equals(setName);
    }

    public static boolean isAsset(KElement toCheck, String resName) {
        if (ResourceHelper.isAsset(toCheck)) {
            if (StringUtil.getNonEmpty(resName) == null) {
                return true;
            }
            KElement parent = toCheck.getParentNode_KElement();
            String name = parent.getAttribute("Name");
            return name.equals(resName);
        }
        return false;
    }

    public static boolean isResourceElement(KElement toCheck) {
        if (toCheck == null) {
            return false;
        }
        KElement parent = toCheck.getParentNode_KElement();
        return ResourceHelper.isAsset(parent) && new ResourceHelper(parent).getResource() == toCheck;
    }

    public static ResourceHelper getHelper(KElement res) {
        if (ResourceHelper.isAsset(res)) {
            return new ResourceHelper(res);
        }
        if (ResourceHelper.isResourceElement(res)) {
            return new ResourceHelper(res.getParentNode_KElement());
        }
        return null;
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        List<KElement> vParts = this.theElement.getChildList("Part", null);
        if (vParts != null) {
            for (KElement e : vParts) {
                vMap.add(e.getAttributeMap());
            }
            if (vParts.size() == 0) {
                vMap.add(new JDFAttributeMap());
            }
        }
        return vMap;
    }

    public boolean hasPartition(JDFAttributeMap exactMap) {
        VJDFAttributeMap partMapVector = this.getPartMapVector();
        if (JDFAttributeMap.isEmpty(exactMap)) {
            return VJDFAttributeMap.isEmpty(partMapVector);
        }
        return partMapVector.contains(exactMap);
    }

    public JDFAttributeMap getPartMap() {
        JDFPart part = (JDFPart)this.theElement.getElement("Part");
        return part == null ? new JDFAttributeMap() : part.getAttributeMap();
    }

    public String getPartKey(String key) {
        VJDFAttributeMap vjdfAttributeMap = this.getPartMapVector();
        JDFAttributeMap cm = vjdfAttributeMap == null ? null : vjdfAttributeMap.getCommonMap();
        return cm == null ? null : cm.get(key);
    }

    public void setPartMap(JDFAttributeMap map) {
        if (this.getPartMapVector().size() > 0) {
            this.theElement.removeChildren("Part", null, null);
        }
        JDFPart part = (JDFPart)this.theElement.getCreateElement("Part");
        part.setAttributes(map);
    }

    public ResourceHelper ensurePart(String key, String value) {
        if (StringUtil.getNonEmpty(value) != null) {
            JDFAttributeMap newMap;
            VJDFAttributeMap partMapVector = this.getPartMapVector();
            if (partMapVector.overlapsMap(newMap = new JDFAttributeMap(key, value))) {
                partMapVector.put(key, value);
            } else {
                partMapVector.add(newMap);
            }
            this.setPartMapVector(partMapVector);
        }
        return this;
    }

    public void ensureReference(KElement src, String key) {
        if (src != null && this.theElement != null) {
            if (StringUtil.isEmpty(key)) {
                key = this.getName();
            }
            if (!key.endsWith("Ref") && !key.endsWith("Refs")) {
                key = key + "Ref";
            }
            String id = this.ensureID();
            src.setAttribute(key, id);
        }
    }

    public void ensureReference(ResourceHelper src, String key) {
        this.ensureReference(src == null ? null : src.getResource(), key);
    }

    public void setPartMapVector(VJDFAttributeMap vPart) {
        this.theElement.removeChildrenByClass(JDFPart.class);
        if (vPart != null && vPart.maxSize() > 0) {
            for (JDFAttributeMap part : vPart) {
                this.appendPartMap(part);
            }
        }
    }

    public void appendPartMapVector(VJDFAttributeMap vPart) {
        VJDFAttributeMap vexisting = this.getPartMapVector();
        if (vexisting != null) {
            vPart = vPart.clone();
            vPart.removeAll(vexisting);
        }
        if (vPart != null && vPart.size() > 0) {
            for (JDFAttributeMap part : vPart) {
                this.appendPartMap(part);
            }
        }
    }

    public void appendPartMap(JDFAttributeMap part) {
        KElement p = this.theElement.appendElement("Part", null);
        p.setAttributes(part);
    }

    public boolean matches(JDFAttributeMap map) {
        if (map == null) {
            map = new JDFAttributeMap();
        }
        return map.subMap(this.getPartMapVector());
    }

    public boolean containsMap(JDFAttributeMap map) {
        if (map == null) {
            map = new JDFAttributeMap();
        }
        VJDFAttributeMap vm = this.getPartMapVector();
        return vm.contains(map);
    }

    public boolean matches(VJDFAttributeMap vmap) {
        if (vmap == null) {
            vmap = new VJDFAttributeMap();
        }
        return vmap.subMap(this.getPartMapVector());
    }

    public KElement getPartition() {
        return this.theElement;
    }

    public SetHelper getSet() {
        KElement parent = this.theElement.getParentNode_KElement();
        if (parent != null && parent.getNodeName().equals(this.theElement.getNodeName() + "Set")) {
            return new SetHelper(parent);
        }
        return null;
    }

    public XJDFHelper getXJDF() {
        return XJDFHelper.getHelper(this.theElement);
    }

    public void setAmount(double amount, JDFAttributeMap moreMap, boolean bGood) {
        this.setVAmount(amount, new VJDFAttributeMap(moreMap), bGood);
    }

    public void setVAmount(double amount, VJDFAttributeMap moreMaps, boolean bGood) {
        VJDFAttributeMap vMap;
        JDFAmountPool ap = this.getCreateAmountPool();
        VJDFAttributeMap vJDFAttributeMap = vMap = moreMaps == null ? null : moreMaps.clone();
        if (vMap != null) {
            VJDFAttributeMap partMap = this.getPartMapVector();
            VString keys = partMap.getKeys();
            vMap.removeKeys(keys);
        }
        JDFPartAmount pa0 = ap.getCreatePartAmount(vMap);
        pa0.setAttribute(bGood ? "Amount" : "Waste", StringUtil.formatDouble(amount), null);
    }

    public KElement getResource() {
        String name = this.getName();
        if (name != null) {
            return this.theElement.getElement(name);
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (e instanceof JDFPart || e instanceof JDFGeneralID || e instanceof JDFAmountPool || e instanceof JDFComment) continue;
            return e;
        }
        return null;
    }

    public String getName() {
        SetHelper set = this.getSet();
        String name = set != null ? set.getAttribute("Name") : null;
        return name;
    }

    public KElement getCreateResource() {
        String name = this.getName();
        if (name != null) {
            return this.theElement.getCreateElement(name);
        }
        return null;
    }

    @Override
    public String toString() {
        return "PartitionHelper: " + this.theElement;
    }

    @Override
    public void cleanUp() {
        VJDFAttributeMap vParts = this.getPartMapVector();
        if (vParts != null && vParts.size() > 0) {
            vParts.unify();
            if (vParts.size() == 1 && vParts.get(0).isEmpty()) {
                vParts = null;
            }
            this.setPartMapVector(vParts);
        }
        super.cleanUp();
    }

    @Override
    public JDFAmountPool getAmountPool() {
        return (JDFAmountPool)this.getRoot().getElement("AmountPool");
    }

    public double getAmount(JDFAttributeMap partMap, boolean bGood) {
        JDFPartAmount pa;
        JDFAmountPool p = this.getAmountPool();
        JDFPartAmount jDFPartAmount = pa = p == null ? null : p.getPartAmount(partMap);
        return pa == null ? 0.0 : pa.getRealAttribute(bGood ? "Amount" : "Waste", null, 0.0);
    }

    public double getAmountSum(boolean bGood) {
        return JDFAmountPool.AmountPoolHelper.getAmountPoolSumDouble(this, bGood ? "Amount" : "Waste", null);
    }

    @Override
    public String getAttribute(String attrib, String nameSpaceURI, String def) {
        return this.getRoot().getAttribute(attrib, nameSpaceURI, def);
    }

    @Override
    public double getRealAttribute(String attName, String namespace, double def) {
        return def;
    }

    @Override
    public JDFResource getLinkRoot() {
        return (JDFResource)(this.getResource() instanceof JDFResource ? this.getResource() : null);
    }

    @Override
    public void setAttribute(String attrib, String value, String nameSpaceURI) {
        this.getRoot().setAttribute(attrib, value, nameSpaceURI);
    }

    public void setResourceAttribute(String attrib, String value) {
        this.getCreateResource().setAttribute(attrib, value);
    }

    public void setResourceEnum(String attrib, ValuedEnum value) {
        this.setResourceAttribute(attrib, value == null ? null : value.getName());
    }

    @Override
    public JDFAmountPool getCreateAmountPool() {
        return (JDFAmountPool)this.getRoot().getCreateElement("AmountPool");
    }

    public void setBrand(String brand) {
        this.setAttribute("Brand", brand);
    }

    public String getBrand() {
        return this.getAttribute("Brand");
    }

    @Override
    public String getComment(int i) {
        KElement root = this.getRoot();
        KElement c = root == null ? null : root.getElement("Comment", null, i);
        return c == null ? null : c.getText();
    }

    @Override
    public void setExternalID(String externalID) {
        super.setExternalID(externalID);
    }

    @Override
    public String getDescriptiveName() {
        return this.getAttribute("DescriptiveName");
    }

    @Override
    public String getExternalID() {
        return this.getAttribute("ExternalID");
    }

    public void setStatus(JDFResource.EnumResStatus status) {
        if (JDFResource.EnumResStatus.Available.equals((Object)status) || JDFResource.EnumResStatus.Unavailable.equals((Object)status)) {
            this.setAttribute("Status", status.getName());
        } else {
            this.setAttribute("Status", null);
        }
    }

    public JDFResource.EnumResStatus getStatus() {
        return JDFResource.EnumResStatus.getEnum(this.getAttribute("Status"));
    }

    @Override
    public void setDescriptiveName(String description) {
        super.setDescriptiveName(description);
    }

    @Override
    public void setGeneralID(String idUsage, String idValue) {
        super.setGeneralID(idUsage, idValue);
    }

    public String getResourceAttribute(String string) {
        KElement resource = this.getResource();
        return resource == null ? null : resource.getNonEmpty(string);
    }

    public ResourceHelper clonePartition() {
        if (this.theElement == null || this.theElement.getParentNode_KElement() == null) {
            return new ResourceHelper(null);
        }
        KElement newElement = this.theElement.getParentNode_KElement().copyElement(this.theElement, this.theElement.getNextSiblingElement());
        return new ResourceHelper(newElement);
    }
}

