/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cip4.jdflib.auto.JDFAutoBinderySignature;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.EnsureNSUri;
import org.cip4.jdflib.elementwalker.RemoveEmpty;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFDeliveryParams;
import org.cip4.jdflib.resource.process.JDFDependencies;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFIdentical;
import org.cip4.jdflib.resource.process.JDFLayoutElement;
import org.cip4.jdflib.resource.process.JDFLayoutElementProductionParams;
import org.cip4.jdflib.resource.process.JDFPageData;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStripCellParams;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

class PostConverter {
    private final XJDFToJDFImpl xjdfToJDFImpl;
    private final JDFNode theNode;

    PostConverter(XJDFToJDFImpl xjdfToJDFImpl, JDFNode theNode) {
        this.xjdfToJDFImpl = xjdfToJDFImpl;
        this.theNode = theNode;
    }

    void postConvert() {
        JDFNode root = this.theNode.getJDFRoot();
        String type = StringUtil.getNonEmpty(root.getType());
        if (type == null || "Product".equals(type)) {
            this.mergeProductLinks(this.theNode, root);
        }
        this.fixDelivery();
        this.fixCSR();
        new GangCleaner().cleanGangLinks();
        new ResourceCleaner().cleanResources();
        new ProcessCleaner().cleanProcesses();
        new DependencyCleaner().fixDependencies(root);
        new LinkAmountCleaner().cleanLinkAmounts();
        new UnLinkFinder().eraseUnlinked(root);
        this.xjdfToJDFImpl.firstConvert = false;
        EnsureNSUri fixNS = new EnsureNSUri();
        fixNS.addNS(null, JDFElement.getSchemaURL());
        fixNS.walk(root);
        RemoveEmpty re = new RemoveEmpty();
        re.addIgnoreElement("BindingIntent");
        re.removEmpty(root);
    }

    void fixCSR() {
        JDFNodeInfo ni;
        JDFEmployee contact = (JDFEmployee)this.theNode.getResource("Employee", null, 0);
        if (contact != null && contact.getRoles().contains("CSR") && (ni = this.theNode.getNodeInfo()) != null) {
            contact.removeAttribute("ID");
            contact.removeAttribute("Status");
            ni.moveElement(contact, null);
        }
    }

    private void fixDelivery() {
        JDFDeliveryParams dp = (JDFDeliveryParams)this.theNode.getResource("DeliveryParams", JDFResourceLink.EnumUsage.Input, 0);
        VString allTypes = this.theNode.getAllTypes();
        if (dp != null && (allTypes.contains("Product") || dp.getChildWithAttribute("Part", "ProductPart", null, "*", 0, false) != null)) {
            boolean keepDI = this.theNode.getResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input, 0) != null;
            JDFDeliveryIntent di = (JDFDeliveryIntent)this.theNode.getCreateResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input, 0);
            boolean bl = keepDI = di.setFromDeliveryParams(dp) || keepDI;
            if (!keepDI) {
                di.deleteNode();
            }
            boolean keepADI = this.theNode.getResource("ArtDeliveryIntent", JDFResourceLink.EnumUsage.Input, 0) != null;
            JDFArtDeliveryIntent adi = (JDFArtDeliveryIntent)this.theNode.getCreateResource("ArtDeliveryIntent", JDFResourceLink.EnumUsage.Input, 0);
            boolean bl2 = keepADI = adi.setFromDeliveryParams(dp) || keepADI;
            if (!keepADI) {
                adi.deleteNode();
            }
            dp.deleteNode();
        }
    }

    public String toString() {
        return "PostConverter [theNode=" + this.theNode + "]";
    }

    private JDFResource mergeProductLink(JDFNode childNode, JDFNode parentProduct, String resName, JDFResourceLink.EnumUsage enumUsage) {
        JDFResourceLink link;
        JDFResource r = parentProduct.getResource(resName, enumUsage, 0);
        int n = 0;
        while (r == null && (link = childNode.getLink(n, resName, new JDFAttributeMap("Usage", enumUsage), null)) != null) {
            if (link.getCombinedProcessIndex() == null) {
                r = link.getLinkRoot();
                parentProduct.ensureLink(r, enumUsage, null);
            }
            ++n;
        }
        return r;
    }

    void mergeProductLinks(JDFNode childNode, JDFNode parentProduct) {
        JDFResource rNode;
        JDFResource r;
        if (childNode == parentProduct) {
            return;
        }
        this.mergeProductLink(childNode, parentProduct, "CustomerInfo", JDFResourceLink.EnumUsage.Input);
        JDFResource ni = this.mergeProductLink(childNode, parentProduct, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        if (ni == null) {
            parentProduct.appendNodeInfo().setDescriptiveName("Generated root NodeInfo");
        }
        if ((r = parentProduct.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null && "generated product component".equals(r.getDescriptiveName()) && (rNode = childNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null) {
            parentProduct.getLink(r, JDFResourceLink.EnumUsage.Output).deleteNode();
            r.deleteNode();
        }
        this.mergeProductLink(childNode, parentProduct, "Component", JDFResourceLink.EnumUsage.Output);
    }

    private class DependencyCleaner {
        private DependencyCleaner() {
        }

        private void fixDependencies(JDFNode root) {
            List<JDFDependencies> vDep = root.getChildArrayByClass(JDFDependencies.class, true, 0);
            if (vDep == null) {
                return;
            }
            for (JDFDependencies dep : vDep) {
                this.fixOneDependencies(dep);
            }
        }

        private void fixOneDependencies(JDFDependencies dep) {
            if (dep == null) {
                return;
            }
            List<KElement> v = dep.getChildArray_KElement("RunListRef", null, null, true, 0);
            if (v == null) {
                return;
            }
            for (KElement e : v) {
                JDFRefElement rl = (JDFRefElement)e;
                rl.renameElement("LayoutElementRef", null);
                JDFResource root = rl.getTargetRoot();
                if (root == null) continue;
                List<JDFResource> vR = root.getLeafArray(true);
                VElement v2 = root.getLinksAndRefs(true, false);
                if (v2 != null) {
                    for (KElement kElement : v2) {
                        kElement.renameElement("LayoutElementLink", null);
                    }
                }
                if ((v2 = root.getLinksAndRefs(false, true)) != null) {
                    for (KElement kElement : v2) {
                        kElement.renameElement("LayoutElementRef", null);
                    }
                }
                for (KElement kElement : vR) {
                    JDFLayoutElement loe;
                    JDFLayoutElement jDFLayoutElement = loe = kElement instanceof JDFRunList ? ((JDFRunList)kElement).getLayoutElement() : null;
                    if (loe != null) {
                        List<KElement> v3 = loe.getChildArray_KElement(null, null, null, true, 0);
                        kElement.moveArray(v3, null);
                        kElement.setAttributes(loe);
                        loe.deleteNode();
                    }
                    kElement.renameElement("LayoutElement", null);
                }
            }
        }
    }

    class ResourceCleaner {
        private VElement products;
        private HashSet<KElement> rootLinks;

        public ResourceCleaner() {
            this.products = PostConverter.this.theNode.getvJDFNode(JDFNode.EnumType.Product.getName(), null, false);
            this.rootLinks = new HashSet();
        }

        void cleanResources() {
            VElement vRes = this.collectResources();
            if (vRes != null) {
                for (KElement rr : vRes) {
                    this.splitDropID((JDFResource)rr);
                }
                vRes = this.collectResources();
                for (KElement rr : vRes) {
                    this.cleanResource(rr);
                }
            }
            for (KElement product : this.products) {
                product.removeAttribute("ExternalID");
            }
            for (KElement link : this.rootLinks) {
                link.deleteNode();
            }
        }

        private VElement collectResources() {
            VElement vRes = new VElement();
            for (JDFNode n = PostConverter.this.theNode; n != null; n = n.getParentJDF()) {
                JDFResourcePool rp = n.getResourcePool();
                VElement v = rp == null ? null : rp.getPoolChildren(null, null, null);
                vRes.addAll(v);
            }
            return vRes;
        }

        void cleanResource(KElement eRoot) {
            JDFResource resRoot = (JDFResource)eRoot;
            if (resRoot != null) {
                String localName;
                JDFResource.EnumResStatus s = resRoot.getStatusFromLeaves(false);
                if (s != null) {
                    resRoot.setResStatus(s, false);
                }
                if ("ColorPool".equals(localName = resRoot.getLocalName())) {
                    this.cleanColorPool(resRoot);
                } else if ("PageList".equals(localName)) {
                    this.cleanPageList(resRoot);
                } else if ("NodeInfo".equals(localName)) {
                    this.updatePersonalID((JDFNodeInfo)resRoot);
                } else if ("BinderySignature".equals(localName)) {
                    this.cleanBinderySignature(resRoot);
                }
                this.cleanLeaf(resRoot, false);
                List<JDFResource> leaves = resRoot.getLeafArray(true);
                for (JDFResource leaf : leaves) {
                    this.checkParts(leaf);
                }
                JDFResource.EnumResourceClass c = resRoot.getResourceClass();
                if (JDFResource.EnumResourceClass.Implementation.equals((Object)c) || JDFResource.EnumResourceClass.Parameter.equals((Object)c) && resRoot.getNodeName().endsWith("Params")) {
                    resRoot.setPartUsage(JDFResource.EnumPartUsage.Implicit);
                }
            }
        }

        void checkParts(JDFResource leaf) {
            for (JDFPart part : leaf.getChildArrayByClass(JDFPart.class, false, 0)) {
                String extID = part.getNonEmpty("Product");
                if (extID == null) {
                    extID = part.getNonEmpty("ProductPart");
                }
                if (extID != null) {
                    for (KElement product : this.products) {
                        if (!product.getID().equals(extID) && !extID.equals(product.getNonEmpty("ExternalID"))) continue;
                        JDFResourceLink baselink = PostConverter.this.theNode.getLink(leaf, null);
                        ((JDFNode)product).ensureLinkPU(leaf, baselink == null ? null : baselink.getUsage(), baselink == null ? null : baselink.getProcessUsage());
                        ContainerUtil.add(this.rootLinks, baselink);
                    }
                }
                part.deleteNode();
            }
        }

        void splitDropID(JDFResource resRoot) {
            VString partIDKeys = resRoot.getPartIDKeys();
            if (partIDKeys.contains("DropID")) {
                int i;
                VJDFAttributeMap partMapVector = resRoot.getPartMapVector(true);
                int pos = partIDKeys.index("DropID") + 1;
                while (pos < partIDKeys.size()) {
                    partIDKeys.remove(pos);
                }
                partMapVector.reduceMap(partIDKeys);
                VString vals = partMapVector.getPartValues("DropID", false);
                VElement copies = new VElement();
                copies.add(resRoot);
                VElement vl = resRoot.getLinksAndRefs(true, false);
                VElement vr = resRoot.getLinksAndRefs(false, true);
                for (i = 1; i < vals.size(); ++i) {
                    copies.add(resRoot.getParentNode_KElement().copyElement(resRoot, resRoot));
                }
                for (i = 0; i < copies.size(); ++i) {
                    this.splitSingleDrop(partMapVector, copies, vl, vr, i);
                }
            }
        }

        private void splitSingleDrop(VJDFAttributeMap partMapVector, VElement copies, VElement vl, VElement vr, int i) {
            JDFResource newRoot = (JDFResource)copies.get(i);
            JDFAttributeMap map = (JDFAttributeMap)partMapVector.remove(0);
            String currentDrop = map.get("DropID");
            JDFResource leaf = newRoot.getPartition(map, JDFResource.EnumPartUsage.Explicit);
            String id = newRoot.getID();
            if (i > 0) {
                id = id + map.get("DropID");
                newRoot.setID(id);
            }
            if (vl != null) {
                this.copyLinks(partMapVector, vl, i, currentDrop, id);
            }
            if (vr != null) {
                this.copyRefs(vr, currentDrop, id);
            }
            for (JDFAttributeMap map2 : partMapVector) {
                newRoot.getPartition(map2, JDFResource.EnumPartUsage.Explicit).deleteNode();
            }
            for (int j = i + 1; j < copies.size(); ++j) {
                ((JDFResource)copies.get(j)).getPartition(map, JDFResource.EnumPartUsage.Explicit).deleteNode();
            }
            leaf.removeAttribute("DropID");
            leaf.getParentNode_KElement().copyInto(leaf, false);
            leaf.deleteNode();
            VString partIDKeys2 = newRoot.getPartIDKeys();
            partIDKeys2.remove("DropID");
            newRoot.setPartIDKeys(partIDKeys2);
        }

        private void copyRefs(VElement vr, String currentDrop, String id) {
            for (KElement r : vr) {
                JDFRefElement ref = (JDFRefElement)r;
                JDFAttributeMap rMap = ref.getPartMap();
                if (JDFAttributeMap.isEmpty(rMap) || !currentDrop.equals(rMap.get("DropID"))) continue;
                rMap.remove("DropID");
                ref.setPartMap(rMap);
                ref.setrRef(id);
            }
        }

        private void copyLinks(VJDFAttributeMap partMapVector, VElement vl, int i, String currentDrop, String id) {
            for (KElement l : vl) {
                JDFResourceLink link = (JDFResourceLink)l;
                VJDFAttributeMap vlMap = link.getPartMapVector();
                if (!VJDFAttributeMap.isEmpty(vlMap) && currentDrop.equals(vlMap.getCommonMap().get("DropID"))) {
                    vlMap.removeKey("DropID");
                    link.setPartMapVector(vlMap);
                    link.setrRef(id);
                    continue;
                }
                if (!VJDFAttributeMap.isEmpty(vlMap) || i != 0) continue;
                for (JDFAttributeMap map2 : partMapVector) {
                    String id2 = id + map2.get("DropID");
                    link.getParentNode_KElement().copyElement(link, null).setAttribute("rRef", id2);
                }
            }
        }

        void updatePersonalID(JDFNodeInfo ni) {
            JDFEmployee e;
            String pi = ni.getNonEmpty("PersonalID");
            if (pi != null && (e = PostConverter.this.theNode.getChildWithAttribute(JDFEmployee.class, "PersonalID", pi, true)) != null && !ni.equals(e.getParentNode())) {
                ni.copyElement(e, null);
                ni.removeAttribute("PersonalID");
            }
        }

        private void cleanBinderySignature(JDFResource bsRoot) {
            JDFResource strippingParams = PostConverter.this.theNode.getResource("StrippingParams", null, 0);
            if (strippingParams != null) {
                JDFResource bs;
                List<JDFResource> spLeaves = strippingParams.getLeafArray(false);
                HashSet<String> moved = new HashSet<String>();
                for (JDFResource sp : spLeaves) {
                    bs = bsRoot.getPartition(sp.getPartMap(), JDFResource.EnumPartUsage.Implicit);
                    moved.addAll(this.moveToStripping(bs, sp));
                }
                if (!moved.isEmpty()) {
                    for (JDFResource sp : spLeaves) {
                        bs = (JDFBinderySignature)bsRoot.getPartition(sp.getPartMap(), JDFResource.EnumPartUsage.Implicit);
                        Collection<JDFSignatureCell> scs = ((JDFAutoBinderySignature)bs).getAllSignatureCell();
                        for (JDFSignatureCell sc : scs) {
                            sc.removeAttributes(moved);
                            if (!JDFAttributeMap.isEmpty(sc.getAttributeMap())) continue;
                            sc.deleteNode();
                        }
                    }
                }
                this.cleanidenticals(bsRoot, strippingParams);
            }
        }

        void cleanidenticals(JDFResource bsRoot, JDFResource spRoot) {
            List<JDFIdentical> ids = bsRoot.getChildArrayByClass(JDFIdentical.class, true, 0);
            if (!ContainerUtil.isEmpty(ids)) {
                List<JDFResource> spLeaves = spRoot.getLeafArray(false);
                for (JDFIdentical id : ids) {
                    String trgBS;
                    JDFResource parentResource = id.getParentResource();
                    JDFAttributeMap src = parentResource.getPartMap();
                    String srcBS = src == null ? null : src.get("BinderySignatureName");
                    JDFAttributeMap trg = id.getPartMap();
                    String string = trgBS = trg == null ? null : trg.get("BinderySignatureName");
                    if (srcBS != null && trgBS != null) {
                        for (JDFResource sp : spLeaves) {
                            JDFRefElement re;
                            JDFPart p;
                            if (!srcBS.equals(sp.getBinderySignatureName()) || (p = (re = (JDFRefElement)sp.getElement_KElement("BinderySignatureRef", null, 0)) == null ? null : re.getPart()) == null) continue;
                            p.setBinderySignatureName(trgBS);
                        }
                    }
                    parentResource.deleteNode();
                }
            }
        }

        Collection<String> moveToStripping(JDFResource bs, JDFResource sp) {
            List<KElement> vsc = bs.getChildArray_KElement("SignatureCell", null, null, false, 0);
            VJDFAttributeMap tmp = new VJDFAttributeMap();
            if (!ContainerUtil.isEmpty(vsc)) {
                for (KElement sc : vsc) {
                    tmp.add(this.moveToStripCell(sc, sp));
                }
            }
            return tmp.getKeys();
        }

        JDFAttributeMap moveToStripCell(KElement signatureCell, JDFResource sp) {
            JDFStripCellParams stripCell = (JDFStripCellParams)sp.appendElement("StripCellParams");
            VString stripCellKnown = stripCell.knownAttributes();
            JDFAttributeMap sigCelMap = signatureCell.getAttributeMap();
            sigCelMap.reduceMap(stripCellKnown);
            if (sigCelMap.isEmpty()) {
                stripCell.deleteNode();
            } else {
                for (String key : sigCelMap.keySet()) {
                    stripCell.copyAttribute(key, signatureCell);
                }
            }
            return sigCelMap;
        }

        private void cleanLeaf(KElement elem, boolean cleanMe) {
            if (cleanMe) {
                elem.removeAttribute_KElement("Class", null);
            }
            for (KElement e2 = elem.getFirstChildElement(); e2 != null; e2 = e2.getNextSiblingElement()) {
                this.cleanLeaf(e2, true);
            }
        }

        private void cleanPageList(JDFResource r) {
            VElement v;
            String id = r.getID();
            JDFPageList pl = (JDFPageList)r;
            Collection<JDFPageData> vpd = pl.getAllPageData();
            if (vpd != null) {
                for (JDFPageData pd : vpd) {
                    pd.removeChildrenByClass(JDFPart.class);
                }
            }
            if (StringUtil.getNonEmpty(id) != null && (v = PostConverter.this.theNode.getRoot().getChildrenByTagName_KElement(null, null, new JDFAttributeMap("rRef", id), false, false, 0)) != null) {
                for (KElement e : v) {
                    String name = e.getLocalName();
                    if ("ContentRef".equals(name)) {
                        e.renameElement("PageListRef", null);
                        if (!(e.getParentNode_KElement() instanceof JDFLayoutElementProductionParams)) continue;
                        this.fixLayoutElementProductionParams(e.getParentNode_KElement());
                        continue;
                    }
                    if (!"ContentLink".equals(name)) continue;
                    e.renameElement("PageListLink", null);
                }
            }
        }

        private void fixLayoutElementProductionParams(KElement lopp) {
            JDFPageList pl = (JDFPageList)lopp.getElement("PageList");
            Collection<JDFPageData> vpd = pl.getAllPageData();
            if (vpd != null) {
                for (JDFPageData pd : vpd) {
                    KElement ren = lopp.moveElement(pd, null).renameElement("LayoutElementPart", null);
                    KElement el = lopp.copyElement(ren, ren);
                    KElement fs = el.getElement("FileSpec");
                    if (fs != null) {
                        el.appendElement("LayoutElement").moveElement(fs, null);
                    }
                    ren.deleteNode();
                }
            }
            lopp.getElement("PageListRef").deleteNode();
        }

        private void cleanColorPool(JDFResource r) {
            VElement v;
            String id = r.getID();
            if (StringUtil.getNonEmpty(id) != null && (v = PostConverter.this.theNode.getRoot().getChildrenByTagName_KElement(null, null, new JDFAttributeMap("rRef", id), false, false, 0)) != null) {
                for (KElement e : v) {
                    String name = e.getLocalName();
                    if ("ColorRef".equals(name)) {
                        e.renameElement("ColorPoolRef", null);
                        continue;
                    }
                    if ("ColorLink".equals(name)) {
                        e.renameElement("ColorPoolLink", null);
                        continue;
                    }
                    if ("ContentRef".equals(name)) {
                        e.renameElement("PageListRef", null);
                        continue;
                    }
                    if (!"ContentLink".equals(name)) continue;
                    e.renameElement("PageListLink", null);
                }
            }
        }
    }

    class ProcessCleaner {
        ProcessCleaner() {
        }

        void cleanProcesses() {
            VString types = PostConverter.this.theNode.getAllTypes();
            if (this.getFixType(types) != null) {
                this.cleanProcess(this.getFixType(types));
            }
        }

        private void cleanProcess(String fixType) {
            VElement v;
            String resName = this.getRes(fixType);
            JDFResourceLink.EnumUsage usage = this.getUsage(fixType);
            if (PostConverter.this.theNode.getLink(resName, usage, null) == null && (v = PostConverter.this.theNode.getChildrenByTagName(resName, null, null, false, true, 0)) != null) {
                for (KElement e : v) {
                    JDFResource r = (JDFResource)e;
                    if (!r.isResourceRootRoot()) continue;
                    PostConverter.this.theNode.ensureLink(r, usage, null);
                }
            }
        }

        private String getRes(String fixType) {
            if (JDFNode.EnumType.DieLayoutProduction.getName().equals(fixType)) {
                return "ShapeDef";
            }
            return null;
        }

        private JDFResourceLink.EnumUsage getUsage(String fixType) {
            if (JDFNode.EnumType.DieLayoutProduction.getName().equals(fixType)) {
                return JDFResourceLink.EnumUsage.Input;
            }
            return null;
        }

        private String getFixType(VString types) {
            if (types != null && types.contains(JDFNode.EnumType.DieLayoutProduction.getName())) {
                return JDFNode.EnumType.DieLayoutProduction.getName();
            }
            return null;
        }
    }

    private class LinkAmountCleaner {
        private LinkAmountCleaner() {
        }

        void cleanLinkAmounts() {
            for (JDFNode n = PostConverter.this.theNode; n != null; n = n.getParentJDF()) {
                VElement links = PostConverter.this.theNode.getResourceLinks(null, null, null);
                if (links == null) continue;
                for (KElement e : links) {
                    this.cleanLink(e);
                }
            }
        }

        void cleanLink(KElement e) {
            if ("BinderySignature".equals(((JDFResourceLink)e).getLinkedResourceName())) {
                e.deleteNode();
            } else {
                this.cleanLinkAmount(e);
            }
        }

        void cleanLinkAmount(KElement e) {
            JDFPartAmount partAmount;
            JDFResourceLink link = (JDFResourceLink)e;
            JDFAmountPool ap = link.getAmountPool();
            JDFPartAmount jDFPartAmount = partAmount = ap == null ? null : ap.getPartAmount(0);
            if (partAmount != null && ap.getPartAmount(1) == null) {
                VJDFAttributeMap linkMaps = link.getPartMapVector();
                VJDFAttributeMap paMaps = partAmount.getPartMapVector();
                if (linkMaps != null && linkMaps.equals(paMaps)) {
                    link.copyAttribute("Amount", partAmount);
                    link.copyAttribute("ActualAmount", partAmount);
                    link.copyAttribute("MaxAmount", partAmount);
                    ap.deleteNode();
                }
            }
        }
    }

    private class GangCleaner {
        private GangCleaner() {
        }

        void cleanGangLinks() {
            for (JDFNode n = PostConverter.this.theNode; n != null; n = n.getParentJDF()) {
                VElement links = PostConverter.this.theNode.getResourceLinks("NodeInfo", null, null);
                if ((links = (VElement)ContainerUtil.addAll(links, PostConverter.this.theNode.getResourceLinks("CustomerInfo", null, null))) == null) continue;
                for (KElement e : links) {
                    this.cleanGangLink(e);
                }
            }
        }

        private void cleanGangLink(KElement e) {
            JDFResourceLink link = (JDFResourceLink)e;
            VJDFAttributeMap linkMaps = link.getPartMapVector();
            if (linkMaps != null) {
                linkMaps.reduceMap(new VString("ProductPart", null));
                if (!linkMaps.isEmpty()) {
                    boolean mustZapp = true;
                    for (JDFAttributeMap map : linkMaps) {
                        String val = map.get("ProductPart");
                        if (!PostConverter.this.theNode.getID().equals(val)) continue;
                        mustZapp = false;
                        break;
                    }
                    if (mustZapp) {
                        link.deleteNode();
                    }
                }
            }
        }
    }
}

