/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.util.ContainerUtil;

public final class NodeIdentifier
implements IMatches,
INodeIdentifiable {
    private String _jobID;
    private String _jobPartID;
    private VJDFAttributeMap _partMapVector;

    public NodeIdentifier(String jobID, String jobPartID, VJDFAttributeMap partMapVector) {
        this.setTo(jobID, jobPartID, partMapVector);
    }

    public void setTo(String jobID, String jobPartID, VJDFAttributeMap partMapVector) {
        this._jobID = KElement.isWildCard(jobID) ? null : jobID;
        this._jobPartID = KElement.isWildCard(jobPartID) ? null : jobPartID;
        this._partMapVector = partMapVector;
    }

    public NodeIdentifier() {
        this.setTo(null, null, null);
    }

    @Override
    public void setIdentifier(NodeIdentifier n) {
        if (n == null) {
            this.setTo(null, null, null);
        } else {
            this.setTo(n._jobID, n._jobPartID, n._partMapVector);
        }
    }

    public void setTo(INodeIdentifiable qe) {
        if (qe == null) {
            this.setTo(null, null, null);
        } else {
            this.setIdentifier(qe.getIdentifier());
        }
    }

    public NodeIdentifier(INodeIdentifiable ni) {
        this();
        this.setTo(ni);
    }

    public boolean equals(Object inObject) {
        if (!(inObject instanceof INodeIdentifiable)) {
            return false;
        }
        NodeIdentifier mt = ((INodeIdentifiable)inObject).getIdentifier();
        boolean b = ContainerUtil.equals(mt._jobID, this._jobID);
        b = b && ContainerUtil.equals(mt._jobPartID, this._jobPartID);
        return b && ContainerUtil.equals(mt._partMapVector, this._partMapVector);
    }

    @Override
    public boolean matches(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return ContainerUtil.equals(this._jobID, o);
        }
        if (!(o instanceof INodeIdentifiable)) {
            return false;
        }
        NodeIdentifier niInput = ((INodeIdentifiable)o).getIdentifier();
        boolean b = KElement.isWildCard(niInput._jobID) || ContainerUtil.equals(niInput._jobID, this._jobID);
        b = b && (KElement.isWildCard(niInput._jobPartID) || ContainerUtil.equals(niInput._jobPartID, this._jobPartID) || this._jobPartID != null && niInput._jobPartID != null && this._jobPartID.startsWith(niInput._jobPartID + "."));
        return b && (this._partMapVector == null || this._partMapVector != null && this._partMapVector.overlapsMap(niInput._partMapVector));
    }

    public int hashCode() {
        return (this._jobID == null ? 0 : this._jobID.hashCode()) + (this._jobPartID == null ? 0 : this._jobPartID.hashCode()) + (this._partMapVector == null ? 0 : this._partMapVector.hashCode());
    }

    public String toString() {
        return "NodeIdentifier :" + this._jobID + " " + this._jobPartID + "\n" + this._partMapVector;
    }

    public String getJobID() {
        return this._jobID;
    }

    public String getJobPartID() {
        return this._jobPartID;
    }

    public VJDFAttributeMap getPartMapVector() {
        return this._partMapVector;
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return this;
    }
}

